/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.data.missile;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.modules.IGuidance;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.api.modules.IRocketEngine;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.content.missile.data.casing.MissileCasingData;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.icbm.content.missile.parts.engine.Engines;
import com.builtbroken.icbm.content.missile.parts.engine.RocketEngine;
import com.builtbroken.icbm.content.missile.parts.guidance.Guidance;
import com.builtbroken.icbm.content.missile.parts.guidance.GuidanceModules;
import com.builtbroken.icbm.content.missile.parts.warhead.Warhead;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.data.item.ItemStackWrapper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Missile
implements IMissile,
IJsonGenObject {
    private static final String NBT_MISSILE_CASING = "missileCasingID";
    public MissileCasingData data;
    public String textureSkinID = "icbm.default";
    private IWarhead warhead;
    private IGuidance guidance;
    private IRocketEngine engine;

    public Missile(MissileCasingData data) {
        this.data = data;
    }

    public Missile(ItemStack stack) throws IllegalArgumentException {
        if (stack.func_77973_b() instanceof IMissileItem) {
            this.data = Missile.getMissileCasingData(stack);
            if (stack.func_77978_p() != null) {
                this.load(stack.func_77978_p());
            }
        } else {
            throw new IllegalArgumentException("Invalid stack input for missile creation, stack = " + stack);
        }
    }

    public final String getSaveID() {
        return MissileModuleBuilder.INSTANCE.getID(this);
    }

    public void save(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p() != null ? stack.func_77978_p() : new NBTTagCompound();
        this.save(nbt);
        if (nbt.func_82582_d()) {
            stack.func_77982_d(null);
        } else {
            stack.func_77982_d(nbt);
        }
    }

    public List<IModule> getSubModules() {
        ArrayList<IModule> module = new ArrayList<IModule>();
        if (this.warhead != null) {
            module.add((IModule)this.warhead);
        }
        if (this.guidance != null) {
            module.add((IModule)this.guidance);
        }
        if (this.engine != null) {
            module.add((IModule)this.engine);
        }
        return module;
    }

    public void load(NBTTagCompound nbt) {
        if (nbt != null) {
            IModule module;
            if (nbt.func_74764_b("warhead")) {
                module = Missile.getModule(nbt, "warhead");
                this.setWarhead(module instanceof IWarhead ? (IWarhead)module : null);
            }
            if (nbt.func_74764_b("engine")) {
                module = Missile.getModule(nbt, "engine");
                this.setEngine(module instanceof IRocketEngine ? (IRocketEngine)module : null);
            }
            if (nbt.func_74764_b("guidance")) {
                module = Missile.getModule(nbt, "guidance");
                this.setGuidance(module instanceof IGuidance ? (IGuidance)module : null);
            }
        }
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        if (nbt != null) {
            if (this.getWarhead() != null) {
                nbt.func_74782_a("warhead", (NBTBase)this.getWarhead().toStack().func_77955_b(new NBTTagCompound()));
            }
            if (this.getEngine() != null) {
                nbt.func_74782_a("engine", (NBTBase)this.getEngine().toStack().func_77955_b(new NBTTagCompound()));
            }
            if (this.getGuidance() != null) {
                nbt.func_74782_a("guidance", (NBTBase)this.getGuidance().toStack().func_77955_b(new NBTTagCompound()));
            }
        }
        return nbt;
    }

    public boolean canInstallModule(IModule module) {
        return module instanceof RocketEngine || module instanceof Warhead || module instanceof Guidance;
    }

    public boolean installModule(IModule module) {
        if (module instanceof RocketEngine && this.engine == null) {
            this.setEngine((RocketEngine)module);
            return this.getEngine() == module;
        }
        if (module instanceof Warhead && this.warhead == null) {
            this.setWarhead((Warhead)module);
            return this.getWarhead() == module;
        }
        if (module instanceof Guidance && this.guidance == null) {
            this.setGuidance((Guidance)module);
            return this.getGuidance() == module;
        }
        return false;
    }

    @Override
    public boolean canLaunch() {
        return this.getEngine() != null && this.getEngine().getMaxDistance(this) > 0.0f && this.getEngine().getSpeed(this) > 0.0f;
    }

    @Override
    public void setWarhead(IWarhead warhead) {
        this.warhead = warhead;
    }

    @Override
    public void setGuidance(IGuidance guidance) {
        this.guidance = guidance;
    }

    @Override
    public void setEngine(IRocketEngine engine) {
        this.engine = engine;
    }

    @Override
    public IWarhead getWarhead() {
        return this.warhead;
    }

    @Override
    public IGuidance getGuidance() {
        return this.guidance;
    }

    @Override
    public IRocketEngine getEngine() {
        return this.engine;
    }

    @Override
    public int getMissileSize() {
        return this.data.getMissileBodySize();
    }

    public String toString() {
        return this.data.getContentID() + " Missile[" + this.getWarhead() + ", " + this.getGuidance() + ", " + this.getEngine() + "]";
    }

    public ItemStack toStack() {
        ItemStack stack = new ItemStack(ICBM_API.itemMissile, 1, this.data != null ? this.data.getMissileBodySize() : 0);
        this.save(stack);
        return stack;
    }

    public String getUnlocalizedName() {
        return this.data.getContentID();
    }

    @Override
    public float getMaxHitPoints() {
        return this.data != null ? this.data.getHealth() : 10.0f;
    }

    @Override
    public double getHeight() {
        return this.data != null ? (double)this.data.getHeight() : 3.0;
    }

    @Override
    public double getWidth() {
        return this.data != null ? (double)this.data.getWidth() : 0.5;
    }

    public Pos getCenterOffset() {
        return this.data.getCenterOffset();
    }

    public static Missile createMissile(MissileSize size, IExplosiveHandler handler) {
        Missile missile = new Missile(size.getDefaultMissileCasing());
        missile.setWarhead(MissileModuleBuilder.INSTANCE.buildWarhead(size.warhead_casing));
        missile.setEngine(Engines.CREATIVE_ENGINE.newModule());
        missile.setGuidance(GuidanceModules.CHIP_THREE.newModule());
        List items = ExplosiveRegistry.getItems((IExplosiveHandler)handler);
        if (items.size() > 0) {
            missile.getWarhead().setExplosiveStack(((ItemStackWrapper)items.get((int)0)).itemStack);
        }
        return missile;
    }

    public static IWarhead loadWarheadFromMissileStack(ItemStack itemStack) {
        NBTTagCompound nbt;
        if (itemStack != null && itemStack.func_77978_p() != null && (nbt = itemStack.func_77978_p()).func_74764_b("warhead")) {
            return (IWarhead)Missile.getModule(nbt, "warhead");
        }
        return null;
    }

    public static MissileCasingData getMissileCasingData(ItemStack stack) {
        MissileSize size = MissileSize.fromMeta(stack.func_77960_j());
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(NBT_MISSILE_CASING)) {
            return size.getMissileData(stack.func_77978_p().func_74779_i(NBT_MISSILE_CASING));
        }
        return size.getDefaultMissileCasing();
    }

    private static IModule getModule(NBTTagCompound nbt, String id) {
        ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l(id));
        if (stack != null && stack.func_77973_b() instanceof IModuleItem) {
            return ((IModuleItem)stack.func_77973_b()).getModule(stack);
        }
        return null;
    }

    public String getLoader() {
        return this.data.getLoader();
    }

    public String getMod() {
        return this.data.getMod();
    }

    public String getContentID() {
        return this.data.getContentID();
    }

    public String getUniqueID() {
        return this.data.getUniqueID();
    }
}

