/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.data.missile;

import com.builtbroken.icbm.content.missile.data.casing.MissileCasingData;
import com.builtbroken.icbm.content.missile.parts.warhead.WarheadCasings;
import java.util.HashMap;

public enum MissileSize {
    MICRO(WarheadCasings.EXPLOSIVE_MICRO, 1200),
    SMALL(WarheadCasings.EXPLOSIVE_SMALL, 12000),
    STANDARD(WarheadCasings.EXPLOSIVE_STANDARD, 72000),
    MEDIUM(WarheadCasings.EXPLOSIVE_MEDIUM, 360000),
    LARGE(WarheadCasings.EXPLOSIVE_LARGE, 1440000);

    public final WarheadCasings warhead_casing;
    public final int maxFlightTimeInTicks;
    public final HashMap<String, MissileCasingData> casingDataMap = new HashMap();
    private MissileCasingData defaultMissileCasing;

    private MissileSize(WarheadCasings warhead, int maxFlightTicks) {
        this.warhead_casing = warhead;
        this.maxFlightTimeInTicks = maxFlightTicks;
    }

    public static MissileSize fromMeta(int itemDamage) {
        if (itemDamage >= 0 && itemDamage < MissileSize.values().length) {
            return MissileSize.values()[itemDamage];
        }
        return SMALL;
    }

    public static MissileSize get(int missileSize) {
        return MissileSize.fromMeta(missileSize);
    }

    public MissileCasingData getMissileData(String missileDataID) {
        if (this.casingDataMap.containsKey(missileDataID)) {
            return this.casingDataMap.get(missileDataID);
        }
        return this.getDefaultMissileCasing();
    }

    public MissileCasingData getDefaultMissileCasing() {
        if (this.defaultMissileCasing == null) {
            this.defaultMissileCasing = this.casingDataMap.get("icbm:" + this.name().toLowerCase() + "Missile");
        }
        return this.defaultMissileCasing;
    }
}

