/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.entity;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.blast.IBlastHandler;
import com.builtbroken.icbm.api.blast.IExHandlerTileMissile;
import com.builtbroken.icbm.api.missile.IMissileEntity;
import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.launcher.TileAbstractLauncher;
import com.builtbroken.icbm.content.missile.data.TriggerCauseMissileDestroyed;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.missile.tile.TileCrashedMissile;
import com.builtbroken.icbm.content.missile.tracking.MissileTracker;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.data.EnumProjectileTypes;
import com.builtbroken.mc.api.entity.IFoF;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.content.resources.items.ItemSheetMetal;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.world.edit.WorldChangeHelper;
import com.builtbroken.mc.lib.world.map.radar.RadarRegistry;
import com.builtbroken.mc.prefab.entity.EntityProjectile;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityMissile
extends EntityProjectile
implements IExplosive,
IMissileEntity,
IEntityAdditionalSpawnData,
IFoF {
    private IMissile missile;
    public IPos3D target_pos;
    public boolean noReport = false;
    public String fofTag = "";

    public EntityMissile(World w) {
        super(w);
        this.hasHealth = true;
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
    }

    public EntityMissile(EntityLivingBase entity) {
        super(entity.field_70170_p, entity, 1.0f);
        this.hasHealth = true;
        this.func_70105_a(0.5f, 0.5f);
        this.inAirKillTime = 144000;
    }

    public float getMaxHealth() {
        if (this.missile != null) {
            switch (this.missile.getMissileSize()) {
                case 0: {
                    return 2.0f;
                }
                case 1: {
                    return 10.0f;
                }
                case 2: {
                    return 30.0f;
                }
                case 4: {
                    return 100.0f;
                }
                case 5: {
                    return 1000.0f;
                }
            }
        }
        return 2.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.missile != null) {
            if (this.missile.getEngine() != null) {
                this.missile.getEngine().update(this);
            }
            if (this.missile.getGuidance() != null) {
                this.missile.getGuidance().update(this);
            }
            if (this.missile.getWarhead() != null) {
                this.missile.getWarhead().update(this);
            }
        }
        if (this.ticksInAir == 5 && !this.field_70170_p.field_72995_K) {
            RadarRegistry.add((Entity)this);
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    protected void onDestroyedBy(DamageSource source, float damage) {
        this.destroyMissile(this, DamageSource.field_76377_j, 0.1f, true, true, true);
        this.func_70106_y();
    }

    public void setTarget(IPos3D target, boolean ark) {
        this.target_pos = target;
    }

    @Override
    public void setTarget(double x, double y, double z, boolean ark) {
        this.target_pos = new Pos(x, y, z);
    }

    @Override
    public void setTarget(Entity entity, boolean track) {
        this.setTarget((IPos3D)new Pos(entity), false);
    }

    public IPos3D getCurrentTargetPos() {
        return this.target_pos;
    }

    @Override
    public int[] getCurrentTarget() {
        if (this.target_pos != null) {
            return new int[]{(int)this.target_pos.x(), (int)this.target_pos.y(), (int)this.target_pos.z()};
        }
        return null;
    }

    @Override
    public void destroyMissile(Object source, DamageSource damage, float scaleExplosion, boolean allowDetonationOfWarhead, boolean allowDetonationOfEngine, boolean allowDetonationOfOther) {
        WorldChangeHelper.ChangeResult result;
        if (allowDetonationOfWarhead && this.getMissile().getWarhead() != null && ((result = this.getMissile().getWarhead().trigger(new TriggerCauseMissileDestroyed(source, damage, scaleExplosion), this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v)) == WorldChangeHelper.ChangeResult.COMPLETED || result == WorldChangeHelper.ChangeResult.PARTIAL_COMPLETE_WITH_FAILURE)) {
            this.field_70170_p.func_72908_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, "random.explode", 2.0f, 0.5f + this.field_70170_p.field_73012_v.nextFloat() * 0.2f);
        }
        this.func_70106_y();
    }

    public static void fireMissileByEntity(Entity entity, ItemStack missile) {
        ICBM.INSTANCE.logger().info("Entity: " + entity + " has fire a missile " + missile);
        Entity entityMissile = null;
        if (missile.func_77973_b() instanceof IMissileItem) {
            entityMissile = ((IMissileItem)missile.func_77973_b()).getMissileEntity(missile, entity);
            entityMissile.func_70029_a(entity.field_70170_p);
        }
        EntityMissile.fireMissileByEntity(entityMissile);
    }

    public static void fireMissileByEntity(Entity entityMissile) {
        if (entityMissile instanceof IMissileEntity) {
            ICBM.INSTANCE.logger().info("Missile created and fired -> " + entityMissile);
            ((IMissileEntity)entityMissile).setIntoMotion();
            entityMissile.field_70170_p.func_72838_d(entityMissile);
            entityMissile.field_70170_p.func_72956_a(entityMissile, "icbm:icbm.missilelaunch", ICBM.missile_firing_volume, (1.0f + (entityMissile.field_70170_p.field_73012_v.nextFloat() - entityMissile.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    public String func_70005_c_() {
        return this.getMissile() == null ? "Unknown-Missile" : (this.getMissile().getWarhead() == null ? "Missile-Module" : "Missile with " + this.getMissile().getWarhead().getExplosive().toString() + " warhead");
    }

    @Override
    public void setIntoMotion() {
        if (this.missile != null && this.missile.canLaunch()) {
            this.ticksInAir = 1;
            this.updateMotion();
            this.missile.getEngine().onLaunch(this, this.missile);
        }
    }

    protected void updateMotion() {
        super.updateMotion();
        if (this.target_pos != null && !this.field_70170_p.field_72995_K && this.field_70163_u >= (double)MissileTracker.MAX_SPAWN_OUT_Y) {
            MissileTracker.addToTracker(this);
            RadarRegistry.remove((Entity)this);
        }
        if (this.field_70170_p.field_72995_K && this.ticksInAir > 0) {
            for (int i = 0; i < 4; ++i) {
                ICBM.proxy.spawnRocketTail((Entity)this);
            }
            if (this.ticksInAir % 5 == 0) {
                // empty if block
            }
        }
    }

    public IExplosiveHandler getExplosive() {
        return this.getMissile() != null && this.getMissile().getWarhead() != null ? this.getMissile().getWarhead().getExplosive() : null;
    }

    public NBTTagCompound getAdditionalExplosiveData() {
        return this.getMissile() != null && this.getMissile().getWarhead() != null ? this.getMissile().getWarhead().getAdditionalExplosiveData() : null;
    }

    public double getExplosiveSize() {
        return this.getMissile() != null && this.getMissile().getWarhead() != null ? this.getMissile().getWarhead().getExplosiveSize() : 0.0;
    }

    protected void onImpactEntity(Entity ent, float v) {
        super.onImpactEntity(ent, v);
        this.onImpact(ent.field_70165_t, ent.field_70163_u, ent.field_70161_v, false, (TriggerCause)new TriggerCause.TriggerEntityImpact(ent, (Entity)this, v));
    }

    public void onImpactTile(MovingObjectPosition hit) {
        IExplosiveHandler handler;
        ITileNode tile;
        super.onImpactTile(hit);
        if (!this.noReport && this.sourceOfProjectile != null && (tile = this.sourceOfProjectile.getTileNode((IBlockAccess)this.field_70170_p)) instanceof TileAbstractLauncher) {
            ((TileAbstractLauncher)tile).onImpactOfMissile(this);
        }
        if ((handler = this.getExplosive()) instanceof IExHandlerTileMissile && ((IExHandlerTileMissile)handler).doesSpawnMissileTile(this.missile, this)) {
            Pos pos = (Pos)new Pos(hit.field_72307_f).add(ForgeDirection.getOrientation((int)this.sideTile));
            TileCrashedMissile.placeFromMissile(this, this.field_70170_p, pos.xi(), pos.yi(), pos.zi());
        } else {
            this.onImpact(hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, true, (TriggerCause)new TriggerCause.TriggerBlockImpact(this.inBlockID, (Entity)this, this.getSpeed()));
        }
    }

    public void func_70106_y() {
        ITileNode tile;
        if (!this.field_70170_p.field_72995_K) {
            RadarRegistry.remove((Entity)this);
        }
        super.func_70106_y();
        if (!this.noReport && this.sourceOfProjectile != null && (tile = this.sourceOfProjectile.getTileNode((IBlockAccess)this.field_70170_p)) instanceof TileAbstractLauncher) {
            ((TileAbstractLauncher)tile).onDeathOfMissile(this);
        }
    }

    protected void onImpact(double x, double y, double z, boolean tile, TriggerCause triggerCause) {
        if (!this.field_70170_p.field_72995_K) {
            ICBM.INSTANCE.logger().info(this + String.format(" impact %1$,.2fx %1$,.2fy %1$,.2fz", x, y, z));
            boolean canPlaceTile = true;
            boolean doDrops = true;
            boolean engineBlew = false;
            boolean explosiveBlew = false;
            IExplosiveHandler handler = null;
            if (this.missile.getWarhead() != null) {
                handler = this.missile.getWarhead().getExplosive();
                WorldChangeHelper.ChangeResult result = this.missile.getWarhead().trigger(triggerCause, this.field_70170_p, x, y, z);
                boolean bl = explosiveBlew = result == WorldChangeHelper.ChangeResult.COMPLETED || result == WorldChangeHelper.ChangeResult.PARTIAL_COMPLETE_WITH_FAILURE;
            }
            if (this.missile != null && this.missile.getEngine() != null) {
                engineBlew = this.missile.getEngine().onDestroyed(this, this.missile);
            }
            if (engineBlew) {
                if (this.field_70170_p.field_73012_v.nextFloat() >= 0.8f) {
                    // empty if block
                }
                this.missile.setEngine(null);
            }
            if (explosiveBlew) {
                this.missile.getWarhead().setExplosiveStack(null);
            }
            if (!(handler instanceof IBlastHandler) || ((IBlastHandler)handler).doesDamageMissile(this, this.missile, this.missile.getWarhead(), explosiveBlew, engineBlew) || !((IBlastHandler)handler).allowMissileToDrop(this, this.missile, this.missile.getWarhead())) {
                canPlaceTile = false;
            }
            if (canPlaceTile) {
                if (tile) {
                    Pos pos = (Pos)new Pos((double)this.xTile, (double)this.yTile, (double)this.zTile).add(ForgeDirection.getOrientation((int)this.sideTile));
                    TileCrashedMissile.placeFromMissile(this, this.field_70170_p, pos.xi(), pos.yi(), pos.zi());
                } else {
                    InventoryUtility.dropItemStack((IWorldPosition)this, (ItemStack)this.missile.toStack());
                }
            } else if (doDrops) {
                this.doDropsOnDeath(explosiveBlew, engineBlew);
            }
            this.func_70106_y();
        } else {
            this.doClientImpact(x, y, z);
        }
    }

    protected void doDropsOnDeath(boolean warheadBlew, boolean engineBlew) {
        boolean genScraps;
        IExplosiveHandler handler = this.missile.getWarhead().getExplosive();
        if (handler instanceof IBlastHandler && ((IBlastHandler)handler).doesVaporizeParts(this, this.missile, this.missile.getWarhead(), warheadBlew, engineBlew)) {
            return;
        }
        List<Object> drops = null;
        boolean bl = genScraps = warheadBlew || engineBlew;
        if (handler instanceof IBlastHandler) {
            drops = ((IBlastHandler)handler).getDropsForMissile(this, this.missile, this.missile.getWarhead(), warheadBlew, engineBlew);
            genScraps = ((IBlastHandler)handler).doesDamageMissile(this, this.missile, this.missile.getWarhead(), warheadBlew, engineBlew);
        }
        if (drops == null) {
            drops = new ArrayList<ItemStack>();
            if (Engine.itemSheetMetal != null) {
                drops.add(ItemSheetMetal.SheetMetal.EIGHTH.stack());
                drops.add(ItemSheetMetal.SheetMetal.EIGHTH.stack());
                drops.add(ItemSheetMetal.SheetMetal.EIGHTH.stack());
                drops.add(ItemSheetMetal.SheetMetal.EIGHTH.stack());
            }
            if (this.missile.getEngine() != null) {
                if (!genScraps) {
                    drops.add(this.missile.getEngine().toStack());
                }
                this.missile.setEngine(null);
            }
            if (this.missile.getWarhead() != null) {
                if (!genScraps) {
                    drops.add(this.missile.getWarhead().toStack());
                }
                this.missile.setWarhead(null);
            }
            if (this.missile.getGuidance() != null) {
                if (!genScraps) {
                    drops.add(this.missile.getGuidance().toStack());
                }
                this.missile.setGuidance(null);
            }
        }
        if (drops != null) {
            for (ItemStack itemStack : drops) {
                InventoryUtility.dropItemStack((World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (ItemStack)itemStack, (int)(5 + this.field_70170_p.field_73012_v.nextInt(30)), (float)this.field_70170_p.field_73012_v.nextFloat());
            }
        }
    }

    protected void doClientImpact(double x, double y, double z) {
    }

    protected void decreaseMotion() {
        if (this.ticksInAir > 1000) {
            super.decreaseMotion();
        }
    }

    public IMissile getMissile() {
        return this.missile;
    }

    public void setMissile(IMissile missile) {
        this.missile = missile;
        if (missile != null) {
            this.inAirKillTime = MissileSize.get((int)missile.getMissileSize()).maxFlightTimeInTicks;
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        ItemStack stack;
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("missileStack") && (stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("missileStack"))) != null && stack.func_77973_b() instanceof IMissileItem) {
            this.setMissile(((IMissileItem)stack.func_77973_b()).toMissile(stack));
        }
        if (nbt.func_74764_b("fofTag")) {
            this.fofTag = nbt.func_74779_i("fofTag");
        }
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.getMissile() != null) {
            ItemStack stack = this.getMissile().toStack();
            nbt.func_74782_a("missileStack", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        if (this.fofTag != null && !this.fofTag.isEmpty()) {
            nbt.func_74778_a("fofTag", this.fofTag);
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70014_b(tag);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)tag);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70037_a(ByteBufUtils.readTag((ByteBuf)additionalData));
    }

    public String getFoFTag() {
        return this.fofTag;
    }

    public String toString() {
        return String.format("Missile[ %d@dim %.2fx %.2fy %.2fz ]@", this.field_70170_p.field_73011_w.field_76574_g, this.field_70165_t, this.field_70163_u, this.field_70161_v) + this.hashCode();
    }

    public EnumProjectileTypes getProjectileType() {
        return EnumProjectileTypes.ROCKET;
    }
}

