/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.item;

import com.builtbroken.icbm.api.crafting.IModularMissileItem;
import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.api.warhead.IWarheadHandler;
import com.builtbroken.icbm.content.missile.data.ammo.AmmoDataMissile;
import com.builtbroken.icbm.content.missile.data.casing.MissileCasingData;
import com.builtbroken.icbm.content.missile.data.missile.Missile;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.icbm.content.missile.parts.engine.Engines;
import com.builtbroken.icbm.content.missile.parts.engine.RocketEngine;
import com.builtbroken.icbm.content.missile.parts.guidance.Guidance;
import com.builtbroken.icbm.content.missile.parts.guidance.GuidanceModules;
import com.builtbroken.icbm.content.missile.parts.warhead.Warhead;
import com.builtbroken.icbm.content.missile.parts.warhead.WarheadCasings;
import com.builtbroken.jlib.data.Colors;
import com.builtbroken.mc.api.data.weapon.IAmmoData;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveContainerItem;
import com.builtbroken.mc.api.items.explosives.IExplosiveItem;
import com.builtbroken.mc.api.items.weapons.IItemAmmo;
import com.builtbroken.mc.api.items.weapons.IItemReloadableWeapon;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.client.ExplosiveRegistryClient;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.item.ItemBase;
import com.builtbroken.mc.lib.data.item.ItemStackWrapper;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemMissile
extends ItemBase
implements IExplosiveItem,
IItemAmmo.IItemAmmoFireHandler,
IMissileItem,
IModularMissileItem,
IExplosiveContainerItem,
IModuleItem {
    @SideOnly(value=Side.CLIENT)
    IIcon emptyIcon;

    public ItemMissile() {
        super("missile", "icbm", "missile");
        this.func_77656_e(0);
        this.func_77627_a(true);
        this.func_77625_d(1);
    }

    public String getRenderContentID(ItemStack stack) {
        MissileCasingData data = Missile.getMissileCasingData(stack);
        if (data != null) {
            return data.getContentID();
        }
        return super.getRenderContentID(stack);
    }

    public List<String> getRenderContentIDs() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getRenderContentID(0));
        for (MissileSize size : MissileSize.values()) {
            for (MissileCasingData data : size.casingDataMap.values()) {
                String id = data.getContentID();
                if (id == null || this.field_111218_cA.isEmpty()) continue;
                list.add(id);
            }
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        this.emptyIcon = reg.func_94245_a("voltzengine:blank");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass > 0) {
            IIcon icon = ExplosiveRegistryClient.getCornerIconFor((ItemStack)stack, (int)(pass - 1));
            if (icon == null) {
                return this.emptyIcon;
            }
            return icon;
        }
        return super.getIcon(stack, pass);
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77658_a() {
        return "item.icbm:missile";
    }

    public String func_77667_c(ItemStack item) {
        if (item.func_77960_j() < MissileSize.values().length) {
            MissileSize size = MissileSize.values()[item.func_77960_j()];
            if (this.getExplosive(item) == null) {
                return this.func_77658_a() + "." + size.toString().toLowerCase() + ".empty";
            }
            return this.func_77658_a() + "." + size.toString().toLowerCase();
        }
        return this.func_77658_a();
    }

    public IExplosiveHandler getExplosive(ItemStack itemStack) {
        IWarhead warhead = Missile.loadWarheadFromMissileStack(itemStack);
        return warhead != null ? warhead.getExplosive() : null;
    }

    public NBTTagCompound getAdditionalExplosiveData(ItemStack itemStack) {
        IWarhead warhead = Missile.loadWarheadFromMissileStack(itemStack);
        return warhead != null ? warhead.getAdditionalExplosiveData() : null;
    }

    public double getExplosiveSize(ItemStack itemStack) {
        IWarhead warhead = Missile.loadWarheadFromMissileStack(itemStack);
        return warhead != null ? warhead.getExplosiveSize() : 0.0;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (MissileSize size : MissileSize.values()) {
            ItemMissile.getSubItems(size, list);
        }
    }

    public static void getSubItems(MissileSize size, List list) {
        if (!size.casingDataMap.isEmpty()) {
            for (MissileCasingData data : size.casingDataMap.values()) {
                list.add(new Missile(data).toStack());
            }
            for (IExplosiveHandler ex : ExplosiveRegistry.getExplosives()) {
                List items = ExplosiveRegistry.getItems((IExplosiveHandler)ex);
                if (items == null) continue;
                for (ItemStackWrapper wrapper : items) {
                    Warhead warhead = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.values()[size.ordinal()], wrapper.itemStack);
                    warhead.explosive.field_77994_a = warhead.getMaxExplosives();
                    Missile missile = new Missile(size.getDefaultMissileCasing());
                    if (missile.data == null) {
                        // empty if block
                    }
                    missile.setWarhead(warhead);
                    missile.setEngine(Engines.CREATIVE_ENGINE.newModule());
                    missile.setGuidance(GuidanceModules.CHIP_THREE.newModule());
                    list.add(missile.toStack());
                }
            }
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        IMissile missile = this.toMissile(stack);
        if (missile != null) {
            IExplosiveHandler ex;
            String guidance_translation = LanguageUtility.getLocal((String)"info.icbm:guidance.name") + ": ";
            guidance_translation = missile.getEngine() != null ? guidance_translation + LanguageUtility.getLocal((String)(missile.getGuidance().getUnlocalizedName() + ".name")) : guidance_translation + "----";
            list.add(guidance_translation);
            String engine_translation = LanguageUtility.getLocal((String)"info.icbm:engine.name") + ": ";
            engine_translation = missile.getEngine() != null ? engine_translation + LanguageUtility.getLocal((String)(missile.getEngine().getUnlocalizedName() + ".name")) : engine_translation + "----";
            list.add(engine_translation);
            IExplosiveHandler iExplosiveHandler = ex = missile.getWarhead() != null ? missile.getWarhead().getExplosive() : null;
            if (ex != null) {
                ArrayList<String> l = new ArrayList<String>();
                if (ex instanceof IWarheadHandler) {
                    ((IWarheadHandler)ex).addInfoToItem(player, missile.getWarhead(), l);
                } else {
                    ex.addInfoToItem(player, missile.getWarhead().toStack(), l);
                }
                for (String s : l) {
                    list.add(s);
                }
            } else {
                String ex_translation = LanguageUtility.getLocal((String)"info.voltzengine:explosive.name") + ": ";
                ex_translation = ex_translation + "----";
                list.add(ex_translation);
            }
        } else {
            list.add(Colors.RED.code + "Error broken NBT data");
            list.add(Colors.RED.code + " Place in crafting grid to fix");
        }
    }

    public boolean isAmmo(ItemStack stack) {
        IMissile missile = this.toMissile(stack);
        return missile != null && missile.canLaunch();
    }

    public boolean isClip(ItemStack stack) {
        return false;
    }

    public IAmmoData getAmmoData(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 1: {
                return AmmoDataMissile.SMALL;
            }
            case 2: {
                return AmmoDataMissile.STANDARD;
            }
            case 3: {
                return AmmoDataMissile.MEDIUM;
            }
            case 4: {
                return AmmoDataMissile.LARGE;
            }
        }
        return AmmoDataMissile.MICRO;
    }

    public int getAmmoCount(ItemStack ammoStack) {
        return ammoStack.field_77994_a;
    }

    public void fireAmmo(IItemReloadableWeapon weapon, ItemStack weaponStack, ItemStack ammoStack, Entity firingEntity) {
        EntityMissile.fireMissileByEntity(firingEntity, ammoStack);
    }

    public void consumeAmmo(IItemReloadableWeapon weapon, ItemStack weaponStack, ItemStack ammoStack, int shotsFired) {
        ammoStack.field_77994_a -= shotsFired;
    }

    @Override
    public Entity getMissileEntity(ItemStack stack) {
        EntityMissile missile = new EntityMissile((World)null);
        missile.setMissile(this.toMissile(stack));
        return missile;
    }

    @Override
    public Entity getMissileEntity(ItemStack stack, Entity firedBy) {
        if (firedBy instanceof EntityLivingBase) {
            EntityMissile missile = new EntityMissile((EntityLivingBase)firedBy);
            missile.setMissile(this.toMissile(stack));
            return missile;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass > 0) {
            return ExplosiveRegistryClient.getColorForCornerIcon((ItemStack)stack, (int)(pass - 1));
        }
        return super.func_82790_a(stack, pass);
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @Override
    public ItemStack getEngine(ItemStack stack) {
        IMissile missile = this.toMissile(stack);
        return missile != null && missile.getEngine() != null ? missile.getEngine().toStack() : null;
    }

    @Override
    public boolean setEngine(ItemStack m_stack, ItemStack stack, boolean simulate) {
        IMissile missile = this.toMissile(m_stack);
        if (missile != null) {
            if (missile.getEngine() == null) {
                IModule module;
                if (stack != null && stack.func_77973_b() instanceof IModuleItem && (module = ((IModuleItem)stack.func_77973_b()).getModule(stack)) instanceof RocketEngine) {
                    if (!simulate) {
                        missile.setEngine((RocketEngine)module);
                        missile.toStack();
                    }
                    return true;
                }
            } else if (stack == null) {
                if (!simulate) {
                    missile.setEngine(null);
                    missile.toStack();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getWarhead(ItemStack stack) {
        IMissile missile = this.toMissile(stack);
        return missile != null && missile.getWarhead() != null ? missile.getWarhead().toStack() : null;
    }

    @Override
    public boolean setWarhead(ItemStack m_stack, ItemStack stack, boolean simulate) {
        Missile missile = new Missile(m_stack);
        if (missile != null) {
            if (missile.getWarhead() == null && stack != null && stack.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)stack.func_77973_b()).getModule(stack);
                if (module instanceof Warhead) {
                    if (!simulate) {
                        missile.setWarhead((Warhead)module);
                        m_stack = missile.toStack();
                    }
                    return true;
                }
            } else if (stack == null) {
                if (!simulate) {
                    missile.setWarhead(null);
                    m_stack = missile.toStack();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public ItemStack getGuidance(ItemStack stack) {
        IMissile missile = this.toMissile(stack);
        return missile != null && missile.getGuidance() != null ? missile.getGuidance().toStack() : null;
    }

    @Override
    public boolean setGuidance(ItemStack m_stack, ItemStack stack, boolean simulate) {
        Missile missile = new Missile(m_stack);
        if (missile != null) {
            if (missile.getGuidance() == null && stack != null && stack.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)stack.func_77973_b()).getModule(stack);
                if (module instanceof Guidance) {
                    if (!simulate) {
                        missile.setGuidance((Guidance)module);
                        m_stack = missile.toStack();
                    }
                    return true;
                }
            } else if (stack == null) {
                if (!simulate) {
                    missile.setGuidance(null);
                    m_stack = missile.toStack();
                }
                return true;
            }
        }
        return false;
    }

    public ItemStack getExplosiveStack(ItemStack stack) {
        IMissile missile = this.toMissile(stack);
        if (missile != null && missile.getWarhead() != null) {
            return missile.getWarhead().getExplosiveStack();
        }
        return null;
    }

    public boolean setExplosiveStack(ItemStack stack, ItemStack explosive) {
        IMissile missile = this.toMissile(stack);
        if (missile != null && missile.getWarhead() != null) {
            return missile.getWarhead().setExplosiveStack(explosive);
        }
        return false;
    }

    @Override
    public IMissile toMissile(ItemStack stack) {
        return new Missile(stack);
    }

    public IMissile getModule(ItemStack stack) {
        return this.toMissile(stack);
    }
}

