/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.parts;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.api.warhead.ITrigger;
import com.builtbroken.icbm.content.missile.parts.MissileModule;
import com.builtbroken.icbm.content.missile.parts.engine.RocketEngine;
import com.builtbroken.icbm.content.missile.parts.guidance.Guidance;
import com.builtbroken.icbm.content.missile.parts.trigger.Trigger;
import com.builtbroken.icbm.content.missile.parts.trigger.Triggers;
import com.builtbroken.icbm.content.missile.parts.warhead.Warhead;
import com.builtbroken.icbm.content.missile.parts.warhead.WarheadCasings;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.lib.data.item.ItemStackWrapper;
import com.builtbroken.mc.prefab.module.ModuleBuilder;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;

public class MissileModuleBuilder<M extends MissileModule>
extends ModuleBuilder<M> {
    public static MissileModuleBuilder INSTANCE = new MissileModuleBuilder();
    public HashMap<String, Class<? extends Warhead>> registeredWarheads = new HashMap();
    public HashMap<String, Class<? extends RocketEngine>> registeredEngines = new HashMap();
    public HashMap<String, Class<? extends Guidance>> registeredGuidances = new HashMap();
    public List<String> idToUseWithModuleItem = new ArrayList<String>();

    public boolean register(String mod_id, String name, Class<M> clazz, boolean useItem) {
        if (this.register(mod_id, name, clazz)) {
            if (useItem) {
                this.idToUseWithModuleItem.add(mod_id + "." + name);
            }
            return true;
        }
        return false;
    }

    public boolean register(String mod_id, String name, Class<M> clazz) {
        if (super.register(mod_id, name, clazz)) {
            String id = mod_id + "." + name;
            if (Warhead.class.isAssignableFrom(clazz)) {
                this.registeredWarheads.put(id, clazz);
            } else if (RocketEngine.class.isAssignableFrom(clazz)) {
                this.registeredEngines.put(id, clazz);
            } else if (Guidance.class.isAssignableFrom(clazz)) {
                this.registeredGuidances.put(id, clazz);
            }
            return true;
        }
        return false;
    }

    public IWarhead buildWarhead(ItemStack stack) {
        IModule module = super.build(stack);
        if (module instanceof IWarhead) {
            return (IWarhead)module;
        }
        return null;
    }

    public RocketEngine buildEngine(ItemStack stack) {
        IModule module = super.build(stack);
        if (module instanceof RocketEngine) {
            return (RocketEngine)module;
        }
        return null;
    }

    public Guidance buildGuidance(ItemStack stack) {
        IModule module = super.build(stack);
        if (module instanceof Guidance) {
            return (Guidance)module;
        }
        return null;
    }

    public Trigger buildTrigger(ItemStack stack) {
        IModule module = super.build(stack);
        if (module instanceof Trigger) {
            return (Trigger)module;
        }
        return null;
    }

    @Deprecated
    public Warhead buildWarhead(WarheadCasings size, IExplosiveHandler ex) {
        try {
            Warhead warhead = size.warhead_clazz.getConstructor(ItemStack.class).newInstance(new ItemStack(ICBM_API.blockWarhead, 1, size.ordinal()));
            ItemStack explosive = this.getExplosiveItem(ex);
            if (explosive != null) {
                warhead.setExplosiveStack(explosive);
            } else {
                warhead.setExplosive(ex, -1.0, null);
            }
            return warhead;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    private ItemStack getExplosiveItem(IExplosiveHandler ex) {
        List stacks = ExplosiveRegistry.getItems((IExplosiveHandler)ex);
        if (stacks != null && stacks.size() > 0) {
            return ((ItemStackWrapper)stacks.get((int)0)).itemStack;
        }
        return null;
    }

    public Warhead buildWarhead(WarheadCasings size, ItemStack explosive) {
        Warhead warhead = this.buildWarhead(size);
        if (explosive != null) {
            warhead.setExplosiveStack(explosive);
        }
        return warhead;
    }

    public Warhead buildWarhead(WarheadCasings size) {
        try {
            return size.warhead_clazz.getConstructor(ItemStack.class).newInstance(new ItemStack(ICBM_API.blockWarhead, 1, size.ordinal()));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public ITrigger buildTrigger(Triggers trigger) {
        try {
            return trigger.clazz.getConstructor(ItemStack.class).newInstance(new ItemStack(ICBM_API.itemTrigger, 1, trigger.ordinal()));
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

