/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.parts.engine;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.icbm.content.missile.parts.engine.RocketEngine;
import com.builtbroken.icbm.content.missile.parts.engine.RocketEngineCreative;
import com.builtbroken.icbm.content.missile.parts.engine.fluid.RocketEngineFuel;
import com.builtbroken.icbm.content.missile.parts.engine.fluid.RocketEngineOil;
import com.builtbroken.icbm.content.missile.parts.engine.solid.RocketEngineCoalPowered;
import com.builtbroken.icbm.content.missile.parts.engine.solid.RocketEngineGunpowder;
import com.builtbroken.mc.prefab.module.AbstractModule;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum Engines {
    CREATIVE_ENGINE("engine.creative", RocketEngineCreative.class, 0.0),
    COAL_ENGINE("engine.coal", RocketEngineCoalPowered.class, 500000.0),
    OIL_ENGINE("engine.oil", RocketEngineOil.class, 104326.0),
    FUEL_ENGINE("engine.fuel", RocketEngineFuel.class, 90326.0),
    GUNPOWDER_ENGINE("engine.gunpowder", RocketEngineGunpowder.class, 500.0);

    public final double mass;
    protected final String moduleName;
    protected final Class<? extends AbstractModule> clazz;
    protected IIcon icon;

    private Engines(String name, Class<? extends AbstractModule> clazz, double mass) {
        this.moduleName = name;
        this.clazz = clazz;
        this.mass = mass;
    }

    public static Engines get(ItemStack stack) {
        return Engines.get(stack.func_77960_j());
    }

    public static Engines get(int meta) {
        if (meta >= 0 && meta < Engines.values().length) {
            return Engines.values()[meta];
        }
        return null;
    }

    public ItemStack newModuleStack() {
        ItemStack stack = new ItemStack(ICBM_API.itemEngineModules, 1, this.ordinal());
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("moduleID", "icbm." + this.moduleName);
        return stack;
    }

    public RocketEngine newModule() {
        return MissileModuleBuilder.INSTANCE.buildEngine(this.newModuleStack());
    }

    public static void register() {
        for (Engines module : Engines.values()) {
            MissileModuleBuilder.INSTANCE.register("icbm", module.moduleName, module.clazz, true);
        }
    }
}

