/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.parts.engine;

import com.builtbroken.icbm.api.missile.IMissileEntity;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.api.modules.IRocketEngine;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.icbm.content.missile.parts.MissileModule;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.imp.transform.rotation.EulerAngle;
import com.builtbroken.mc.imp.transform.vector.Pos;
import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class RocketEngine
extends MissileModule
implements IRocketEngine {
    public Color engineSmokeColor;
    public Color engineFireColor;
    protected boolean isRunning = false;
    protected boolean engineOn = false;

    public RocketEngine(ItemStack item, String name) {
        super(item, name);
    }

    @Override
    public void update(EntityMissile missile) {
        this.engineOn = this.hasFuel();
    }

    protected boolean hasFuel() {
        return true;
    }

    @Override
    public float getSpeed(IMissile missile) {
        return 0.5f;
    }

    @Override
    public float getMaxDistance(IMissile missile) {
        return 1000.0f;
    }

    @Override
    public void onLaunch(IMissileEntity missile, IMissile missileModule) {
        this.startEngine(missileModule);
    }

    public void startEngine(IMissile missileModule) {
        this.isRunning = true;
    }

    @Override
    public boolean onDestroyed(IMissileEntity missile, IMissile missileModule) {
        return false;
    }

    @Override
    public boolean generatesFire(IMissileEntity missile, IMissile missileModule) {
        return true;
    }

    public void initFuel() {
    }

    @Override
    public int getMissileSize() {
        return -1;
    }

    public void doEngineEffects(IMissile missile, Entity entity) {
        Pos motion = (Pos)new Pos(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y).normalize();
        Pos vel = new Pos((double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f), (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f), (double)((entity.field_70170_p.field_73012_v.nextFloat() - 0.5f) / 8.0f));
        vel = (Pos)vel.multiply((IPos3D)motion);
        this.doEngineFlames(missile, vel, motion);
        this.doEngineSmoke(missile, vel, motion);
    }

    public void doEngineEffects(IMissile missile, World world, float yaw, float pitch, Pos missileCenter) {
        Pos angle = new EulerAngle((double)yaw, (double)pitch).toPos();
        Pos vel = (Pos)angle.multiply(0.1 + (double)world.field_73012_v.nextFloat() * 0.2);
        this.doEngineFlames(missile, (Pos)missileCenter.add((IPos3D)angle), vel);
        this.doEngineSmoke(missile, (Pos)missileCenter.add((IPos3D)angle), vel);
    }

    @Override
    public Color getEngineFireColor(IMissileEntity missile, IMissile missileModule) {
        return this.engineFireColor;
    }

    @Override
    public Color getEngineSmokeColor(IMissileEntity missile, IMissile missileModule) {
        return this.engineSmokeColor;
    }

    public void doEngineFlames(IMissile missile, Pos pos, Pos vel) {
    }

    public void doEngineSmoke(IMissile missile, Pos pos, Pos vel) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

