/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.parts.engine.solid;

import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.missile.parts.engine.Engines;
import com.builtbroken.icbm.content.missile.parts.engine.solid.RocketEngineCoalRecipe;
import com.builtbroken.icbm.content.missile.parts.engine.solid.RocketEngineSolid;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.content.resources.items.ItemSheetMetal;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.lib.data.item.ItemStackWrapper;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import cpw.mods.fml.common.registry.GameRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RocketEngineCoalPowered
extends RocketEngineSolid
implements IPostInit {
    public static float VALUE_OF_COAL = 15.0f;
    public static float SPEED_OF_COAL = 0.5f;
    public static final HashMap<ItemStackWrapper, Float> FUEL_DISTANCE_VALUE = new HashMap();
    public static final HashMap<ItemStackWrapper, Float> FUEL_SPEED_VALUE = new HashMap();

    public RocketEngineCoalPowered(ItemStack item) {
        super(item, "engine.coal");
        this.engineSmokeColor = new Color(54, 56, 58);
    }

    @Override
    public float getMaxDistance(IMissile missile) {
        ItemStackWrapper wrapper;
        if (this.fuelStack() != null && FUEL_DISTANCE_VALUE.containsKey(wrapper = new ItemStackWrapper(this.fuelStack()))) {
            return FUEL_DISTANCE_VALUE.get(wrapper).floatValue() * (float)this.fuelStack().field_77994_a;
        }
        return 0.0f;
    }

    @Override
    public float getSpeed(IMissile missile) {
        if (this.fuelStack() != null) {
            ItemStackWrapper wrapper = new ItemStackWrapper(this.fuelStack());
            if (FUEL_SPEED_VALUE.containsKey(wrapper)) {
                return FUEL_SPEED_VALUE.get(wrapper).floatValue();
            }
            return SPEED_OF_COAL;
        }
        return 0.0f;
    }

    @Override
    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        if (stack != null) {
            if (stack.func_77973_b() == Items.field_151044_h || stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150402_ci)) {
                return true;
            }
            int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
            for (int i = 0; i < ids.length; ++i) {
                String id = OreDictionary.getOreName((int)i);
                if (!id.equalsIgnoreCase("blockCoal") && !id.equalsIgnoreCase("coal") && !id.equalsIgnoreCase("charcoal")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void initFuel() {
        this.getInventory().func_70299_a(0, new ItemStack(Items.field_151044_h, 64));
    }

    public void onPostInit() {
        RocketEngineCoalPowered engine = (RocketEngineCoalPowered)Engines.COAL_ENGINE.newModule();
        ItemStack engineStack = engine.toStack();
        if (Engine.itemSheetMetal != null) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(engineStack, new Object[]{" F ", "LRC", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('L'), "flint", Character.valueOf('C'), ItemSheetMetal.SheetMetal.CONE_SMALL.stack()}));
        } else {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(engineStack, new Object[]{"c", "f", "h", Character.valueOf('c'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('f'), Blocks.field_150460_al, Character.valueOf('h'), Blocks.field_150438_bZ}));
        }
        engineStack = Engines.COAL_ENGINE.newModuleStack();
        RecipeSorter.register((String)"icbm:RocketCoalPowered", RocketEngineCoalRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shaped");
        RocketEngineCoalPowered.loadFuelValues();
        for (ItemStackWrapper wrapper : FUEL_DISTANCE_VALUE.keySet()) {
            ItemStack s = wrapper.itemStack;
            if (s == null || s.field_77994_a <= 0) continue;
            GameRegistry.addRecipe((IRecipe)new RocketEngineCoalRecipe(engineStack, engineStack, s));
            GameRegistry.addRecipe((IRecipe)new RocketEngineCoalRecipe(engineStack, engineStack, s, s));
            GameRegistry.addRecipe((IRecipe)new RocketEngineCoalRecipe(engineStack, engineStack, s, s, s));
            GameRegistry.addRecipe((IRecipe)new RocketEngineCoalRecipe(engineStack, engineStack, s, s, s, s));
            GameRegistry.addRecipe((IRecipe)new RocketEngineCoalRecipe(engineStack, engineStack, s, s, s, s, s));
            GameRegistry.addRecipe((IRecipe)new RocketEngineCoalRecipe(engineStack, engineStack, s, s, s, s, s, s));
            GameRegistry.addRecipe((IRecipe)new RocketEngineCoalRecipe(engineStack, engineStack, s, s, s, s, s, s, s));
            GameRegistry.addRecipe((IRecipe)new RocketEngineCoalRecipe(engineStack, engineStack, s, s, s, s, s, s, s, s));
        }
    }

    public static final void loadFuelValues() {
        FUEL_DISTANCE_VALUE.clear();
        FUEL_SPEED_VALUE.clear();
        FUEL_DISTANCE_VALUE.put(new ItemStackWrapper(new ItemStack(Items.field_151044_h)), Float.valueOf(VALUE_OF_COAL));
        FUEL_SPEED_VALUE.put(new ItemStackWrapper(new ItemStack(Items.field_151044_h)), Float.valueOf(SPEED_OF_COAL));
        ArrayList oreStacks = OreDictionary.getOres((String)"dustCoal");
        for (ItemStack stack : oreStacks) {
            FUEL_DISTANCE_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(VALUE_OF_COAL));
            FUEL_SPEED_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(SPEED_OF_COAL * 1.05f));
        }
        oreStacks = OreDictionary.getOres((String)"treeLeaves");
        for (ItemStack stack : oreStacks) {
            FUEL_DISTANCE_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(1.0f));
            FUEL_SPEED_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(SPEED_OF_COAL * 0.65f));
        }
        oreStacks = OreDictionary.getOres((String)"treeSapling");
        for (ItemStack stack : oreStacks) {
            FUEL_DISTANCE_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(1.0f));
            FUEL_SPEED_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(SPEED_OF_COAL * 0.65f));
        }
        oreStacks = OreDictionary.getOres((String)"logWood");
        for (ItemStack stack : oreStacks) {
            FUEL_DISTANCE_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(VALUE_OF_COAL * 0.85f));
            FUEL_SPEED_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(SPEED_OF_COAL * 0.65f));
        }
        oreStacks = OreDictionary.getOres((String)"plankWood");
        for (ItemStack stack : oreStacks) {
            FUEL_DISTANCE_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(VALUE_OF_COAL * 0.2f));
            FUEL_SPEED_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(SPEED_OF_COAL * 0.65f));
        }
        oreStacks = OreDictionary.getOres((String)"stickWood");
        for (ItemStack stack : oreStacks) {
            FUEL_DISTANCE_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(VALUE_OF_COAL * 0.05f));
            FUEL_SPEED_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(SPEED_OF_COAL * 0.65f));
        }
        oreStacks = OreDictionary.getOres((String)"fuelCoke");
        for (ItemStack stack : oreStacks) {
            FUEL_DISTANCE_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(VALUE_OF_COAL * 2.0f));
            FUEL_SPEED_VALUE.put(new ItemStackWrapper(stack), Float.valueOf(SPEED_OF_COAL * 1.1f));
        }
    }

    @Override
    public String toString() {
        return "CoalEngine[" + this.fuelStack() + "]";
    }
}

