/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.parts.guidance;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.icbm.content.missile.parts.guidance.Guidance;
import com.builtbroken.icbm.content.missile.parts.guidance.chips.GuidanceChipOne;
import com.builtbroken.icbm.content.missile.parts.guidance.chips.GuidanceChipThree;
import com.builtbroken.icbm.content.missile.parts.guidance.chips.GuidanceChipTwo;
import com.builtbroken.icbm.content.missile.parts.guidance.clocks.GuidanceGearsDiamond;
import com.builtbroken.icbm.content.missile.parts.guidance.clocks.GuidanceGearsIron;
import com.builtbroken.icbm.content.missile.parts.guidance.clocks.GuidanceGearsStone;
import com.builtbroken.icbm.content.missile.parts.guidance.clocks.GuidanceGearsWood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum GuidanceModules {
    WOOD_GEARS("guidance.gears.wood", GuidanceGearsWood.class),
    STONE_GEARS("guidance.gears.stone", GuidanceGearsStone.class),
    IRON_GEARS("guidance.gears.iron", GuidanceGearsIron.class),
    DIAMOND_GEARS("guidance.gears.diamond", GuidanceGearsDiamond.class),
    CHIP_ONE("guidance.chip.one", GuidanceChipOne.class),
    CHIP_TWO("guidance.chip.two", GuidanceChipTwo.class),
    CHIP_THREE("guidance.chip.three", GuidanceChipThree.class);

    protected final String name;
    protected final Class<? extends Guidance> clazz;
    protected IIcon icon;

    private GuidanceModules(String name, Class<? extends Guidance> clazz) {
        this.name = name;
        this.clazz = clazz;
    }

    public static GuidanceModules get(ItemStack stack) {
        return GuidanceModules.get(stack.func_77960_j());
    }

    public static GuidanceModules get(int meta) {
        if (meta >= 0 && meta < GuidanceModules.values().length) {
            return GuidanceModules.values()[meta];
        }
        return null;
    }

    public ItemStack newModuleStack() {
        ItemStack stack = new ItemStack(ICBM_API.itemGuidanceModules, 1, this.ordinal());
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("moduleID", "icbm." + this.name);
        return stack;
    }

    public Guidance newModule() {
        return MissileModuleBuilder.INSTANCE.buildGuidance(this.newModuleStack());
    }

    public static void register() {
        for (GuidanceModules module : GuidanceModules.values()) {
            MissileModuleBuilder.INSTANCE.register("icbm", module.name, module.clazz, true);
        }
    }
}

