/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.parts.trigger;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.icbm.content.missile.parts.trigger.Trigger;
import com.builtbroken.icbm.content.missile.parts.trigger.impact.ImpactTriggerElectrical;
import com.builtbroken.icbm.content.missile.parts.trigger.impact.ImpactTriggerMechanical;
import com.builtbroken.icbm.content.missile.parts.trigger.impact.ImpactTriggerRedstone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public enum Triggers {
    MECHANICAL_IMPACT("impact.mechanical", ImpactTriggerMechanical.class, 54431.1),
    ELECTRICAL_IMPACT("impact.electrical", ImpactTriggerElectrical.class, 27215.5),
    REDSTONE_IMPACT("impact.redstone", ImpactTriggerRedstone.class, 9071.85);

    public final String moduleName;
    public final double mass;
    public Class<? extends Trigger> clazz;
    @SideOnly(value=Side.CLIENT)
    public IIcon icon;

    private Triggers(String moduleName, Class<? extends Trigger> clazz, double mass) {
        this.moduleName = "trigger." + moduleName;
        this.mass = mass;
        this.clazz = clazz;
    }

    public static Triggers get(ItemStack insert) {
        return Triggers.get(insert.func_77960_j());
    }

    public static Triggers get(int meta) {
        if (meta >= 0 && meta < Triggers.values().length) {
            return Triggers.values()[meta];
        }
        return MECHANICAL_IMPACT;
    }

    public ItemStack newModuleStack() {
        ItemStack stack = new ItemStack(ICBM_API.itemTrigger, 1, this.ordinal());
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("moduleID", "icbm." + this.moduleName);
        return stack;
    }

    public Trigger newModule() {
        return MissileModuleBuilder.INSTANCE.buildTrigger(this.newModuleStack());
    }

    public static void register() {
        for (Triggers module : Triggers.values()) {
            MissileModuleBuilder.INSTANCE.register("icbm", module.moduleName, module.clazz, true);
        }
    }
}

