/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.parts.trigger.impact;

import com.builtbroken.icbm.content.missile.parts.trigger.Trigger;
import com.builtbroken.icbm.content.missile.parts.trigger.Triggers;
import com.builtbroken.mc.api.VoltzEngineAPI;
import com.builtbroken.mc.api.event.TriggerCause;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public abstract class ImpactTrigger
extends Trigger {
    private double minimalForce = 0.0;
    private double maximalForce = 2.147483647E9;
    private float failureChance = 0.0f;

    public ImpactTrigger(ItemStack item, Triggers trigger) {
        super(item, trigger);
    }

    @Override
    public boolean shouldTrigger(TriggerCause triggerCause, World world, double x, double y, double z) {
        if (triggerCause instanceof TriggerCause.TriggerCauseImpact) {
            return this.isEnoughForceToTrigger((TriggerCause.TriggerCauseImpact)triggerCause);
        }
        return false;
    }

    protected boolean isEnoughForceToTrigger(TriggerCause.TriggerCauseImpact cause) {
        double mass = VoltzEngineAPI.massRegistry.getMass(cause.source);
        double ke = 0.5 * mass * (double)cause.velocity * (double)cause.velocity;
        return ke >= this.getMinimalForce() && ke <= this.getMaximalForce();
    }

    public double getMinimalForce() {
        return this.minimalForce;
    }

    public double getMaximalForce() {
        return this.maximalForce;
    }
}

