/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.parts.warhead;

import com.builtbroken.icbm.api.modules.IMissileModule;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.api.warhead.ITrigger;
import com.builtbroken.icbm.api.warhead.ITriggerAccepter;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.icbm.content.missile.parts.MissileModule;
import com.builtbroken.icbm.content.missile.parts.warhead.WarheadCasings;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveHolderItem;
import com.builtbroken.mc.api.items.explosives.IExplosiveItem;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleComponent;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.world.edit.WorldChangeHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class Warhead
extends MissileModule
implements IWarhead,
ITriggerAccepter,
Cloneable {
    public ItemStack explosive;
    public ITrigger trigger;
    public final WarheadCasings casing;

    public Warhead(ItemStack warhead, WarheadCasings casing) {
        super(warhead, "warhead");
        this.casing = casing;
    }

    public double getMass() {
        return this.casing.mass;
    }

    public void load(NBTTagCompound nbt) {
        this.explosive = Warhead.loadExplosiveItemFromNBT(nbt);
    }

    public static ItemStack loadExplosiveItemFromNBT(NBTTagCompound nbt) {
        if (nbt != null && nbt.func_74764_b("exItem")) {
            ItemStack explosive = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("exItem"));
            if (explosive == null) {
                Engine.error((String)"Failed to load explosive item in warhead");
            }
            return explosive;
        }
        return null;
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        if (this.explosive != null) {
            nbt.func_74782_a("exItem", (NBTBase)this.explosive.func_77955_b(new NBTTagCompound()));
        }
        return nbt;
    }

    @Override
    public void update(EntityMissile missile) {
        if (this.getTrigger() instanceof IMissileModule) {
            ((IMissileModule)((Object)this.getTrigger())).update(missile);
        }
    }

    @Override
    public WorldChangeHelper.ChangeResult trigger(TriggerCause triggerCause, World world, double x, double y, double z) {
        if ((this.trigger == null || this.trigger.shouldTrigger(triggerCause, world, x, y, z)) && this.getExplosive() != null) {
            if (world == null || Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
                if (Engine.runningAsDev) {
                    Engine.error((String)("Warhead trigger with an invalid location " + world + " " + x + "x " + y + "y " + z + "z "));
                }
                return WorldChangeHelper.ChangeResult.FAILED;
            }
            return ExplosiveRegistry.triggerExplosive((World)world, (double)x, (double)y, (double)z, (IExplosiveHandler)this.getExplosive(), (TriggerCause)triggerCause, (double)(this.getExplosiveSize() * (double)triggerCause.effectScaleChange), (NBTTagCompound)this.getAdditionalExplosiveData());
        }
        return WorldChangeHelper.ChangeResult.FAILED;
    }

    public boolean setExplosiveStack(ItemStack stack) {
        this.explosive = stack != null ? stack.func_77946_l() : stack;
        return true;
    }

    @Deprecated
    public boolean setExplosive(IExplosiveHandler ex, double size, NBTTagCompound nbt) {
        if (this.explosive != null && this.explosive.func_77973_b() instanceof IExplosiveHolderItem) {
            return ((IExplosiveHolderItem)this.explosive.func_77973_b()).setExplosive(this.explosive, ex, size, nbt);
        }
        return false;
    }

    public ItemStack getExplosiveStack() {
        return this.explosive;
    }

    public NBTTagCompound getAdditionalExplosiveData() {
        if (this.explosive != null && this.explosive.func_77973_b() instanceof IExplosiveItem) {
            return ((IExplosiveItem)this.explosive.func_77973_b()).getAdditionalExplosiveData(this.explosive);
        }
        return null;
    }

    public double getExplosiveSize() {
        return ExplosiveRegistry.getExplosiveSize((ItemStack)this.explosive);
    }

    public IExplosiveHandler getExplosive() {
        return ExplosiveRegistry.get((ItemStack)this.explosive);
    }

    @Override
    public int getMissileSize() {
        return -1;
    }

    @Override
    public ITrigger getTrigger() {
        return this.trigger;
    }

    @Override
    public boolean setTrigger(ITrigger trigger) {
        if (this.trigger instanceof IModuleComponent) {
            ((IModuleComponent)this.trigger).removedFromDevice((IModule)this);
        }
        this.trigger = trigger;
        if (this.trigger instanceof IModuleComponent) {
            ((IModuleComponent)this.trigger).addedToDevice((IModule)this);
        }
        return true;
    }

    @Override
    public ItemStack setTrigger(ItemStack stack) {
        IModule module;
        ItemStack temp;
        ItemStack itemStack = temp = this.trigger != null ? this.trigger.toStack() : null;
        if (stack == null ? this.setTrigger((ITrigger)null) : stack.func_77973_b() instanceof IModuleItem && (module = ((IModuleItem)stack.func_77973_b()).getModule(stack)) instanceof ITrigger && this.setTrigger((ITrigger)module)) {
            return temp;
        }
        return null;
    }

    public String toString() {
        if (this.explosive != null) {
            return LanguageUtility.capitalizeFirst((String)this.casing.name().toLowerCase()) + "Warhead[" + this.explosive.func_82833_r() + " x " + this.explosive.field_77994_a + "]";
        }
        return LanguageUtility.capitalizeFirst((String)this.casing.name().toLowerCase()) + "Warhead[" + this.explosive + "]";
    }

    public abstract Warhead clone();

    public void copyDataInto(Warhead warhead) {
        warhead.explosive = this.explosive != null ? this.explosive.func_77946_l() : null;
    }
}

