/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.tile;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.blast.IBlastTileMissile;
import com.builtbroken.icbm.api.blast.IExHandlerTileMissile;
import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.missile.ITileMissile;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.missile.client.RenderMissile;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.icbm.content.missile.tile.ItemBlockMissile;
import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.render.RenderUtility;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.prefab.tile.Tile;
import com.builtbroken.mc.prefab.tile.TileEnt;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import org.lwjgl.opengl.GL11;

public class TileCrashedMissile
extends TileEnt
implements IPacketIDReceiver,
ITileMissile {
    public static int DECAY_TICKS = 72000;
    public static List<Block> blocksToMimic = new ArrayList<Block>();
    public static String[] renderKeys = new String[]{"missile.crashed", "missile", "entity"};
    public IMissile missile;
    private ForgeDirection attachedSide;
    private float yaw = 0.0f;
    private float pitch = -90.0f;
    private Pos posOffset = new Pos();
    private IBlastTileMissile blast;
    private boolean doBlast = false;
    private TriggerCause cause;
    private int ticksForEngine;
    private int ticksForSmoke;
    private int ticksAlive = 0;
    private Pos misislePos = (Pos)this.toPos().add(0.5);
    private Block block;
    private int meta;

    public TileCrashedMissile() {
        super("missile", Material.field_151573_f);
        this.hardness = 10.0f;
        this.resistance = 10.0f;
        this.itemBlock = ItemBlockMissile.class;
        this.renderNormalBlock = false;
        this.renderTileEntity = true;
        this.isOpaque = false;
        this.bounds = new Cube(0.3, 0.0, 0.3, 0.7, 0.7, 0.7);
    }

    public Tile newTile() {
        return new TileCrashedMissile();
    }

    public ItemStack toItemStack() {
        return this.missile != null ? this.missile.toStack() : null;
    }

    public static void placeFromMissile(EntityMissile missile, World world, int x, int y, int z) {
        Fluid fluid;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        while (!(y >= 255 || blocksToMimic.contains(block) || block.isAir((IBlockAccess)world, x, y, z) || block.isReplaceable((IBlockAccess)world, x, y, z))) {
            block = world.func_147439_a(x, ++y, z);
            meta = world.func_72805_g(x, y, z);
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return;
        }
        if (block instanceof IFluidBlock && (fluid = ((IFluidBlock)block).getFluid()) != null && fluid.getTemperature(world, x, y, z) > 1000) {
            return;
        }
        if (world.func_147449_b(x, y, z, ICBM_API.blockCrashMissile)) {
            ICBM.INSTANCE.logger().info(String.format("Placed missile %d@dim %dx %dy %dz", world.field_73011_w.field_76574_g, x, y, z));
            TileEntity tile = world.func_147438_o(x, y, z);
            if (tile instanceof TileCrashedMissile) {
                if (blocksToMimic.contains(block)) {
                    ((TileCrashedMissile)tile).block = block;
                    ((TileCrashedMissile)tile).meta = meta;
                    switch (missile.sideTile) {
                        case 0: {
                            ((TileCrashedMissile)tile).posOffset.sub(0.0, block.func_149665_z(), 0.0);
                            break;
                        }
                        case 1: {
                            ((TileCrashedMissile)tile).posOffset.add(0.0, block.func_149669_A(), 0.0);
                        }
                    }
                }
                if (missile.getMissile() != null) {
                    ((TileCrashedMissile)tile).missile = missile.getMissile();
                }
                ((TileCrashedMissile)tile).yaw = missile.field_70177_z;
                ((TileCrashedMissile)tile).pitch = missile.field_70125_A;
                ((TileCrashedMissile)tile).cause = new TriggerCause.TriggerCauseEntity((Entity)missile);
                ((TileCrashedMissile)tile).attachedSide = ForgeDirection.getOrientation((int)missile.sideTile);
            }
        }
        missile.func_70106_y();
    }

    public void firstTick() {
        super.firstTick();
        this.misislePos = (Pos)this.misislePos.add((IPos3D)this.posOffset);
    }

    public void update() {
        super.update();
        if (this.isServer()) {
            if (this.blast == null && this.ticks % 20L == 0L && this.missile != null && this.missile.getWarhead() != null && this.missile.getWarhead().getExplosiveStack() != null) {
                IWorldChangeAction action;
                IExplosiveHandler handler = ExplosiveRegistry.get((ItemStack)this.missile.getWarhead().getExplosiveStack());
                if ((this.doBlast || handler instanceof IExHandlerTileMissile && ((IExHandlerTileMissile)handler).doesSpawnMissileTile(this.missile, null)) && (action = handler.createBlastForTrigger(this.oldWorld(), (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5, this.cause, this.missile.getWarhead().getExplosiveSize(), this.missile.getWarhead().getAdditionalExplosiveData())) != null) {
                    if (action instanceof IBlastTileMissile) {
                        this.blast = (IBlastTileMissile)action;
                    } else {
                        this.missile.getWarhead().trigger(this.cause, this.oldWorld(), (double)this.xi() + 0.5, (double)this.yi() + 0.5, (double)this.zi() + 0.5);
                    }
                }
            }
            if (this.blast != null) {
                this.blast.tickBlast(this, this.missile);
                if (this.blast.isCompleted()) {
                    this.blast = null;
                    this.missile.getWarhead().setExplosiveStack(null);
                }
            } else {
                ++this.ticksAlive;
                if (this.ticksAlive > DECAY_TICKS) {
                    this.oldWorld().func_147468_f(this.xi(), this.yi(), this.zi());
                    return;
                }
            }
            if (this.missile == null || this.missile.getEngine() != null) {
                // empty if block
            }
            if (this.ticks % 5L == 0L) {
                if (this.attachedSide != null) {
                    Pos pos = (Pos)this.toPos().add(this.attachedSide.getOpposite());
                    if (pos.isAirBlock(this.oldWorld())) {
                        this.attemptToFall();
                    }
                } else {
                    this.attemptToFall();
                }
            }
        }
    }

    protected void attemptToFall() {
        Pos pos = (Pos)this.toPos().sub(0.0, 1.0, 0.0);
        if (pos.isAirBlock(this.oldWorld())) {
            EntityMissile missile = new EntityMissile(this.oldWorld());
            missile.func_70107_b(this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
            missile.setMissile(this.missile);
            missile.field_70177_z = this.yaw;
            missile.field_70125_A = this.pitch;
            this.toPos().setBlockToAir(this.oldWorld());
        } else {
            this.attachedSide = ForgeDirection.UP;
        }
    }

    public Iterable<Cube> getCollisionBoxes(Cube intersect, Entity entity) {
        ArrayList<Cube> boxes = new ArrayList<Cube>();
        boxes.add(this.getCollisionBounds());
        if (this.block != null) {
            AxisAlignedBB bb = this.block.func_149668_a(this.oldWorld(), this.xi(), this.yi(), this.zi());
            if (bb != null) {
                boxes.add(new Cube(bb).subtract((double)this.xi(), (double)this.yi(), (double)this.zi()));
            } else {
                Cube cube = new Cube(this.block.func_149704_x(), this.block.func_149665_z(), this.block.func_149706_B(), this.block.func_149753_y(), this.block.func_149669_A(), this.block.func_149693_C());
                if (cube.isValid()) {
                    boxes.add(cube);
                }
            }
        }
        return boxes;
    }

    public boolean onPlayerActivated(EntityPlayer player, int side, Pos hit) {
        return this.onPlayerRightClick(player, side, hit);
    }

    protected boolean onPlayerRightClick(EntityPlayer player, int side, Pos hit) {
        ItemStack stack;
        if (this.block != null) {
            // empty if block
        }
        if (this.isServer() && this.missile != null && player.field_71071_by.func_70441_a(stack = this.missile.toStack())) {
            this.toPos().setBlock(this.oldWorld(), this.block != null ? this.block : Blocks.field_150350_a, this.block != null ? this.meta : 0);
            player.field_71069_bz.func_75142_b();
        }
        return true;
    }

    public boolean removeByPlayer(EntityPlayer player, boolean willHarvest) {
        if (this.missile != null && willHarvest) {
            ItemStack stack = this.missile.toStack();
            InventoryUtility.dropItemStack((World)this.oldWorld(), (double)(this.x() + 0.5), (double)(this.y() + 0.5), (double)(this.z() + 0.5), (ItemStack)stack, (int)10, (float)0.0f);
        }
        if (this.block != null) {
            return this.oldWorld().func_147465_d(this.xi(), this.yi(), this.zi(), this.block, this.meta, 3);
        }
        return this.oldWorld().func_147468_f(this.xi(), this.yi(), this.zi());
    }

    public void onCollide(Entity entity) {
        if (this.isServer() && entity != null && entity.field_70170_p != null && this.missile != null && this.blast == null && (double)this.oldWorld().field_73012_v.nextFloat() <= 0.3 && this.missile.getWarhead() != null) {
            this.missile.getWarhead().trigger((TriggerCause)new TriggerCause.TriggerCauseEntity(entity), this.oldWorld(), this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
        }
    }

    public boolean onPlayerLeftClick(EntityPlayer player) {
        if ((double)this.oldWorld().field_73012_v.nextFloat() <= 0.3 && this.missile.getWarhead() != null && this.blast == null) {
            this.missile.getWarhead().trigger((TriggerCause)new TriggerCause.TriggerCauseEntity((Entity)player), this.oldWorld(), this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
        }
        return false;
    }

    public void onDestroyedByExplosion(Explosion ex) {
        if (this.missile != null && this.missile.getWarhead() != null && this.blast == null) {
            this.missile.getWarhead().trigger((TriggerCause)new TriggerCause.TriggerCauseExplosion(ex), this.oldWorld(), this.x() + 0.5, this.y() + 0.5, this.z() + 0.5);
        }
    }

    public void onFillRain() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        ItemStack stack;
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("missile") && (stack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("missile"))) != null) {
            this.missile = stack.func_77973_b() instanceof IMissileItem ? ((IMissileItem)stack.func_77973_b()).toMissile(stack) : null;
        }
        this.yaw = nbt.func_74760_g("yaw");
        this.pitch = nbt.func_74760_g("pitch");
        if (nbt.func_74764_b("offset")) {
            this.posOffset = new Pos(nbt.func_74775_l("offset"));
        }
        if (nbt.func_74764_b("block")) {
            this.block = Block.func_149684_b((String)nbt.func_74779_i("block"));
            this.meta = nbt.func_74762_e("blockMeta");
        }
        this.ticksAlive = nbt.func_74762_e("ticksAlive");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.missile != null) {
            ItemStack stack = this.missile.toStack();
            nbt.func_74782_a("missile", (NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        nbt.func_74776_a("yaw", this.yaw);
        nbt.func_74776_a("pitch", this.pitch);
        if (this.posOffset != null) {
            nbt.func_74782_a("offset", (NBTBase)this.posOffset.toNBT());
        }
        if (this.block != null) {
            nbt.func_74778_a("block", Block.field_149771_c.func_148750_c((Object)this.block));
            nbt.func_74768_a("blockMeta", this.meta);
        }
        nbt.func_74768_a("ticksAlive", this.ticksAlive);
    }

    public void readDescPacket(ByteBuf buf) {
        ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.missile = stack.func_77973_b() instanceof IMissileItem ? ((IMissileItem)stack.func_77973_b()).toMissile(stack) : null;
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
        this.posOffset = new Pos(buf);
        if (buf.readBoolean()) {
            this.block = Block.func_149684_b((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
            this.meta = buf.readShort();
        }
    }

    public void writeDescPacket(ByteBuf buf) {
        if (this.missile != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.missile.toStack());
        } else {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)new ItemStack(Items.field_151049_t));
        }
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        this.posOffset.writeByteBuf(buf);
        buf.writeBoolean(this.block != null);
        if (this.block != null) {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)Block.field_149771_c.func_148750_c((Object)this.block));
            buf.writeShort(this.meta);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos pos, float frame, int pass) {
        GL11.glPushMatrix();
        if (this.missile != null) {
            GL11.glTranslated((double)(pos.x() + 0.5), (double)(pos.y() + (double)((float)(this.missile.getHeight() / 2.0)) - (double)((float)(this.missile.getHeight() / 3.0))), (double)(pos.z() + 0.5));
            if (this.block != null) {
                GL11.glTranslated((double)0.0, (double)this.block.func_149669_A(), (double)0.0);
            }
            if (this.posOffset != null) {
                GL11.glTranslated((double)this.posOffset.x(), (double)this.posOffset.y(), (double)this.posOffset.z());
            }
            RenderMissile.renderMissile(this.missile, this.yaw, this.pitch, renderKeys);
        }
        GL11.glPopMatrix();
        if (this.block != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(pos.x() + 0.5), (double)(pos.y() + 0.5), (double)(pos.z() + 0.5));
            RenderUtility.renderInventoryBlock((RenderBlocks)RenderUtility.getBlockRenderer(), (Block)this.block, (int)this.meta);
            GL11.glPopMatrix();
        }
    }

    public ArrayList<ItemStack> getDrops(int metadata, int fortune) {
        ItemStack m;
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (this.missile != null && (m = this.missile.toStack()) != null && m.func_77973_b() != null) {
            drops.add(m);
        }
        return drops;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.field_150339_S.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int meta, int side) {
        return Blocks.field_150339_S.func_149691_a(0, 0);
    }

    public void setTextureName(String value) {
        this.textureName = value;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
    }

    static {
        blocksToMimic.add((Block)Blocks.field_150329_H);
        blocksToMimic.add(Blocks.field_150431_aC);
        blocksToMimic.add(Blocks.field_150414_aQ);
        blocksToMimic.add(ICBM_API.blockCake);
        blocksToMimic.add((Block)Blocks.field_150480_ab);
        blocksToMimic.add(Blocks.field_150432_aD);
        blocksToMimic.add(Blocks.field_150359_w);
    }
}

