/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.missile.tracking;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.content.missile.data.missile.Missile;
import com.builtbroken.icbm.content.missile.entity.EntityMissile;
import com.builtbroken.icbm.content.missile.tracking.MissileTrackingData;
import com.builtbroken.mc.api.IVirtualObject;
import com.builtbroken.mc.core.handler.SaveManager;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.NBTUtility;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class MissileTracker
implements IVirtualObject {
    public static int MAX_SPAWN_OUT_Y = 400;
    private static HashMap<Integer, MissileTracker> trackers = new HashMap();
    private ArrayList<MissileTrackingData> missiles = new ArrayList();
    private final int dim;
    private final World world;

    private MissileTracker(World world) {
        this.world = world;
        this.dim = world.field_73011_w.field_76574_g;
        SaveManager.register((IVirtualObject)this);
        File file = this.getSaveFile();
        if (file != null && file.exists()) {
            this.load(NBTUtility.loadData((File)file));
        }
    }

    public static void addToTracker(EntityMissile missile) {
        MissileTracker.debug("Adding missile " + missile);
        MissileTracker tracker = MissileTracker.getTrackerForWorld(missile.field_70170_p);
        if (tracker != null) {
            tracker.add(missile);
        }
    }

    public static MissileTracker getTrackerForWorld(World world) {
        if (world != null) {
            int dim = world.field_73011_w.field_76574_g;
            if (!trackers.containsKey(dim)) {
                trackers.put(dim, new MissileTracker(world));
            }
            return trackers.get(dim);
        }
        return null;
    }

    public static void spawnMissileOverTarget(Missile data, Location location, EntityPlayer player) {
        MissileTracker.debug((location.world.field_72995_K ? "Client" : "Server") + "spawning missile over target area. D:" + data + "  L:" + location + "  P:" + player);
        MissileTracker.spawnMissileOverTarget(data, location);
    }

    public static void spawnMissileOverTarget(Missile missileModuleData, Location location) {
        EntityMissile missile = new EntityMissile(location.world);
        missile.setMissile(missileModuleData);
        MissileTracker.spawnMissileOverTarget(missile, location);
    }

    public static void spawnMissileOverTarget(EntityMissile missile, Location location) {
        Random rand = location.world.field_73012_v;
        Pos pos = location.toPos();
        pos = (Pos)pos.sub(0.0, (double)(10.0f + 100.0f * rand.nextFloat()), 0.0);
        float accuracy = 100.0f;
        if (missile.getMissile() != null && missile.getMissile().getGuidance() != null) {
            accuracy = missile.getMissile().getGuidance().getFallOffRange(missile.getMissile());
        }
        pos = (Pos)pos.add((double)(accuracy * rand.nextFloat() - accuracy * rand.nextFloat()), (double)(accuracy * rand.nextFloat() - accuracy * rand.nextFloat()), (double)(accuracy * rand.nextFloat() - accuracy * rand.nextFloat()));
        missile.func_70107_b(pos.x(), pos.y(), pos.z());
        missile.field_70181_x = -1.0;
        location.world.func_72838_d((Entity)missile);
        missile.setIntoMotion();
        MissileTracker.debug("Spawned in missile[" + missile.func_110124_au() + "]  over target " + location + " with data" + missile.getMissile());
    }

    public boolean update(World world) {
        Iterator<MissileTrackingData> it = this.missiles.iterator();
        while (it.hasNext()) {
            MissileTrackingData data = it.next();
            if (data.isValid()) {
                Location loc;
                MissileTrackingData missileTrackingData = data;
                Long l = missileTrackingData.ticks;
                Long l2 = missileTrackingData.ticks = Long.valueOf(missileTrackingData.ticks + 1L);
                if (!data.shouldRespawn() || !(loc = new Location(world, data.target)).isChunkLoaded()) continue;
                Entity entity = EntityList.func_75615_a((NBTTagCompound)data.m_save, (World)world);
                if (entity instanceof EntityMissile) {
                    MissileTracker.spawnMissileOverTarget((EntityMissile)entity, new Location(loc.world, loc.x(), (double)MAX_SPAWN_OUT_Y, loc.z()));
                } else {
                    MissileTracker.debug("Error, entity != missile, loading missile data " + data);
                }
                it.remove();
                continue;
            }
            MissileTracker.debug("Removed invalid missile data " + data);
            it.remove();
        }
        return true;
    }

    public void add(EntityMissile missile) {
        missile.noReport = true;
        MissileTrackingData data = new MissileTrackingData(missile);
        this.world.func_72900_e((Entity)missile);
        this.missiles.add(data);
        MissileTracker.debug("Missile[" + missile.func_110124_au() + "] added " + data);
    }

    public File getSaveFile() {
        return new File(NBTUtility.getSaveDirectory(), "/bbm/icbm/MissileSaveDim" + this.dim + ".dat");
    }

    public void setSaveFile(File file) {
    }

    public boolean shouldSaveForWorld(World world) {
        return world != null && world.field_73011_w.field_76574_g == this.dim;
    }

    public void load(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("missileEntities", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.missiles.add(new MissileTrackingData(this.world, list.func_150305_b(i)));
        }
    }

    public NBTTagCompound save(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        Iterator<MissileTrackingData> it = this.missiles.iterator();
        while (it.hasNext()) {
            list.func_74742_a((NBTBase)it.next().save());
        }
        nbt.func_74782_a("missileEntities", (NBTBase)list);
        return nbt;
    }

    protected static void debug(String msg) {
        if (ICBM.DEBUG_MISSILE_MANAGER) {
            ICBM.INSTANCE.logger().info("[MissileTracker]" + msg);
        }
    }

    static {
        SaveManager.registerClass((String)"MissileTracker", MissileTracker.class);
    }
}

