/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.rail;

import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.missile.IMissileItem;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.rail.MissileCartTypes;
import com.builtbroken.mc.api.IInventoryFilter;
import com.builtbroken.mc.api.modules.IModule;
import com.builtbroken.mc.api.modules.IModuleItem;
import com.builtbroken.mc.api.rails.ITransportCartHasItem;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.lib.helper.WrenchUtility;
import com.builtbroken.mc.prefab.entity.cart.EntityAbstractCart;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityMissileCart
extends EntityAbstractCart
implements IPacketIDReceiver,
IEntityAdditionalSpawnData,
ITransportCartHasItem {
    private MissileCartTypes _cartType = MissileCartTypes.SMALL;
    private IMissile cargoMissile;
    private ItemStack cargoStack;

    public EntityMissileCart(World world) {
        super(world);
    }

    public boolean func_130002_c(EntityPlayer player) {
        if (player.func_70694_bm() == null) {
            if (this.cargoStack != null) {
                if (!this.field_70170_p.field_72995_K) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.cargoStack);
                    player.field_71069_bz.func_75142_b();
                    this.setCargo(null);
                    this.markForClientSync();
                }
                return true;
            }
            if (!this.field_70170_p.field_72995_K) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.toStack());
                player.field_71069_bz.func_75142_b();
                this.func_70076_C();
            }
            return true;
        }
        if (WrenchUtility.isWrench((ItemStack)player.func_70694_bm())) {
            if (!this.field_70170_p.field_72995_K) {
                this.setCartRotation(this.field_70177_z + 90.0f, this.field_70125_A);
            }
            return true;
        }
        if (this.cargoStack == null) {
            ItemStack heldItem = player.func_70694_bm();
            IMissile missile = null;
            if (heldItem.func_77973_b() instanceof IMissileItem) {
                missile = ((IMissileItem)heldItem.func_77973_b()).toMissile(heldItem);
            } else if (heldItem.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)heldItem.func_77973_b()).getModule(heldItem);
                if (module instanceof IMissile) {
                    missile = (IMissile)module;
                }
            } else {
                missile = null;
            }
            if (missile != null) {
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack copyStack = heldItem.func_77946_l();
                    copyStack.field_77994_a = 1;
                    this.setCargo(copyStack);
                    --heldItem.field_77994_a;
                    if (heldItem.field_77994_a <= 0) {
                        heldItem = null;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, heldItem);
                    player.field_71069_bz.func_75142_b();
                    this.markForClientSync();
                }
                return true;
            }
        }
        return false;
    }

    public void setType(MissileCartTypes cartType) {
        this._cartType = cartType;
        this.field_70130_N = this.getType().width;
        this.length = this.getType().length;
        this.markBoundsInvalid();
        this.markForClientSync();
    }

    public MissileCartTypes getType() {
        return this._cartType;
    }

    public ItemStack toStack() {
        return new ItemStack(ICBM_API.itemMissileCart, 1, this.getType().ordinal());
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setType(MissileCartTypes.values()[nbt.func_74762_e("cartType")]);
        if (nbt.func_74764_b("missile")) {
            this.setCargo(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("missile")));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("cartType", this.getType().ordinal());
        if (this.cargoStack != null) {
            nbt.func_74782_a("missile", (NBTBase)this.cargoStack.func_77955_b(new NBTTagCompound()));
        }
    }

    public IMissile getCargoMissile() {
        return this.cargoMissile;
    }

    public void setCargoMissile(IMissile cargoMissile) {
        this.cargoMissile = cargoMissile;
        this.markForClientSync();
    }

    public void setCargo(ItemStack cargo) {
        this.cargoStack = cargo;
        if (cargo == null) {
            this.setCargoMissile(null);
        } else {
            IMissile missile = null;
            if (cargo.func_77973_b() instanceof IMissileItem) {
                missile = ((IMissileItem)cargo.func_77973_b()).toMissile(cargo);
            } else if (cargo.func_77973_b() instanceof IModuleItem) {
                IModule module = ((IModuleItem)cargo.func_77973_b()).getModule(cargo);
                if (module instanceof IMissile) {
                    missile = (IMissile)module;
                }
            } else {
                missile = null;
            }
            this.setCargoMissile(missile);
        }
    }

    public boolean canAcceptMissile(IMissile missile) {
        return missile.getMissileSize() == this.getType().supportedCasingSize.ordinal();
    }

    public void writeSpawnData(ByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeInt(this.getType().ordinal());
        buffer.writeBoolean(this.cargoStack != null);
        if (this.cargoStack != null) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.cargoStack);
        }
    }

    public void readSpawnData(ByteBuf additionalData) {
        super.readSpawnData(additionalData);
        this.setType(MissileCartTypes.values()[additionalData.readInt()]);
        if (additionalData.readBoolean()) {
            this.setCargo(ByteBufUtils.readItemStack((ByteBuf)additionalData));
        } else {
            this.setCargo(null);
        }
        this.markBoundsInvalid();
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return this.toStack();
    }

    public ItemStack getTransportedItem() {
        return this.cargoStack;
    }

    public ItemStack setTransportedItem(ItemStack stack) {
        int room;
        if (stack == null) {
            this.cargoStack = null;
        } else if (this.cargoStack == null) {
            ItemStack copy = stack.func_77946_l();
            copy.field_77994_a = 1;
            --stack.field_77994_a;
            this.cargoStack = copy;
        } else if (InventoryUtility.stacksMatch((ItemStack)this.cargoStack, (ItemStack)stack) && (room = InventoryUtility.roomLeftInStack((ItemStack)this.cargoStack)) > 0) {
            this.cargoStack.field_77994_a += room;
            stack.field_77994_a -= room;
            return stack;
        }
        return stack;
    }

    public boolean canAcceptItemForTransport(ItemStack stack) {
        return this.getInventoryFilter().isStackInFilter(stack);
    }

    public IInventoryFilter getInventoryFilter() {
        return this.getType().filter;
    }
}

