/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.rail;

import com.builtbroken.icbm.api.missile.ICustomMissileRender;
import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.crafting.station.small.TileSmallMissileWorkstationClient;
import com.builtbroken.icbm.content.rail.EntityMissileCart;
import com.builtbroken.icbm.content.rail.MissileCartTypes;
import com.builtbroken.jlib.helpers.MathHelper;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.lib.render.RenderUtility;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class RenderMissileCart
extends Render {
    public RenderMissileCart() {
        this.field_76989_e = 0.0f;
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return Assets.SMALL_WORKSTATION_TEXTURE;
    }

    public void func_76986_a(Entity entity, double xx, double yy, double zz, float p_76986_8_, float delta) {
        EntityMissileCart cart = (EntityMissileCart)entity;
        float f5 = cart.field_70127_C + (cart.field_70125_A - cart.field_70127_C) * delta;
        double x2 = MathHelper.lerp((double)cart.lastRenderX, (double)xx, (double)delta);
        double y2 = MathHelper.lerp((double)cart.lastRenderY, (double)yy, (double)delta);
        double z2 = MathHelper.lerp((double)cart.lastRenderZ, (double)zz, (double)delta);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x2, (double)y2, (double)z2);
        GL11.glRotatef((float)(180.0f - delta), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-f5), (float)0.0f, (float)0.0f, (float)1.0f);
        cart.lastRenderX = x2;
        cart.lastRenderY = y2;
        cart.lastRenderZ = z2;
        if (cart.getType() == MissileCartTypes.SMALL) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.05f, (float)0.0f);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)cart.field_70177_z, (double)0.0, (double)1.0, (double)0.0);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.SMALL_WORKSTATION_TEXTURE2);
            Assets.CART1x3.renderAll();
            if (cart.getCargoMissile() != null) {
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                RenderMissileCart.renderMissile(cart.getCargoMissile(), cart.railSide, cart.facingDirection);
            }
            GL11.glPopMatrix();
        } else if (cart.getType() == MissileCartTypes.MICRO) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.32f, (float)0.0f);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.GREY_FAKE_TEXTURE);
            Assets.CART1x1.renderAll();
            if (cart.getCargoMissile() != null) {
                GL11.glTranslated((double)0.0, (double)-0.44, (double)0.0);
                if (cart.getCargoMissile() instanceof ICustomMissileRender) {
                    GL11.glTranslatef((float)0.0f, (float)((ICustomMissileRender)((Object)cart.getCargoMissile())).getRenderHeightOffset(), (float)0.0f);
                }
                RenderMissileCart.renderMissile(cart.getCargoMissile(), ForgeDirection.EAST, ForgeDirection.UP);
            }
            GL11.glPopMatrix();
        } else if (cart.getType() == MissileCartTypes.ThreeByThree) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)-0.05f, (float)0.0f);
            GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.GREY_FAKE_TEXTURE);
            Assets.CART3x3.renderAll();
            if (cart.getCargoMissile() != null) {
                GL11.glTranslated((double)0.0, (double)-0.3, (double)0.0);
                if (cart.getCargoMissile() instanceof ICustomMissileRender) {
                    GL11.glTranslatef((float)0.0f, (float)((ICustomMissileRender)((Object)cart.getCargoMissile())).getRenderHeightOffset(), (float)0.0f);
                }
                RenderMissileCart.renderMissile(cart.getCargoMissile(), ForgeDirection.EAST, ForgeDirection.UP);
            }
            GL11.glPopMatrix();
        } else {
            float halfWidth = cart.field_70130_N / 2.0f;
            float halfLength = cart.length / 2.0f;
            float yaw = (float)Math.abs(MathUtility.clampAngleTo180((double)cart.field_70177_z));
            if (yaw >= 45.0f && yaw <= 135.0f) {
                halfWidth = cart.length / 2.0f;
                halfLength = cart.field_70130_N / 2.0f;
            }
            AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(-((double)halfWidth)), (double)0.0, (double)(-((double)halfLength)), (double)halfWidth, (double)0.3, (double)halfLength);
            GL11.glPushMatrix();
            GL11.glTranslated((double)xx, (double)yy, (double)zz);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.GREY_FAKE_TEXTURE);
            RenderUtility.renderCube((AxisAlignedBB)bounds, (Block)Blocks.field_150339_S, (IIcon)Blocks.field_150339_S.func_149691_a(0, 0));
            if (cart.getCargoMissile() != null) {
                GL11.glTranslated((double)0.0, (double)-0.1, (double)0.0);
                if (cart.getCargoMissile() instanceof ICustomMissileRender) {
                    GL11.glTranslatef((float)0.0f, (float)((ICustomMissileRender)((Object)cart.getCargoMissile())).getRenderHeightOffset(), (float)0.0f);
                }
                RenderMissileCart.renderMissile(cart.getCargoMissile(), ForgeDirection.EAST, ForgeDirection.UP);
            }
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
        if (Engine.runningAsDev) {
            this.drawBounds(cart, xx, yy, zz);
        }
    }

    protected void drawBounds(EntityMissileCart cart, double xx, double yy, double zz) {
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        float halfWidth = cart.field_70130_N / 2.0f;
        float halfLength = cart.length / 2.0f;
        float yaw = (float)Math.abs(MathUtility.clampAngleTo180((double)cart.field_70177_z));
        if (yaw >= 45.0f && yaw <= 135.0f) {
            halfWidth = cart.length / 2.0f;
            halfLength = cart.field_70130_N / 2.0f;
        }
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72330_a((double)(xx - (double)halfWidth), (double)yy, (double)(zz - (double)halfLength), (double)(xx + (double)halfWidth), (double)(yy + (double)cart.field_70131_O), (double)(zz + (double)halfLength));
        RenderGlobal.func_147590_a((AxisAlignedBB)axisalignedbb, (int)0xFFFFFF);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
    }

    public static void renderMissile(IMissile missile, ForgeDirection connectedBlockSide, ForgeDirection direction) {
        GL11.glTranslatef((float)0.0f, (float)0.4f, (float)0.0f);
        switch (connectedBlockSide) {
            case UP: 
            case DOWN: {
                TileSmallMissileWorkstationClient.handleMissileRotationUD(direction);
                break;
            }
            case EAST: 
            case WEST: {
                TileSmallMissileWorkstationClient.handleMissileRotationEW(direction);
                break;
            }
            case SOUTH: 
            case NORTH: {
                TileSmallMissileWorkstationClient.handleMissileRotationNS(direction);
            }
        }
        if (missile instanceof ICustomMissileRender) {
            ((ICustomMissileRender)((Object)missile)).renderMissileInWorld(0.0f, 0.0f, 0.0f);
        } else {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.SMALL_MISSILE_TEXTURE);
            if (missile.getWarhead() != null) {
                Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Group_005"});
                if (missile.getWarhead().getExplosive() != null) {
                    Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Group_004"});
                }
            }
            if (missile.getEngine() != null) {
                int i;
                Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Group_002", "Group_003"});
                for (i = 1; i < 9; ++i) {
                    Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Component_3_00" + i});
                }
                for (i = 1; i < 5; ++i) {
                    Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Component_2_00" + i});
                }
            }
            if (missile.getGuidance() != null) {
                // empty if block
            }
            Assets.SMALL_MISSILE_MODEL.renderOnly(new String[]{"Group_001", "Component_1_001", "Component_1_002", "Component_1_003", "Component_1_004"});
        }
    }
}

