/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.storage.small;

import com.builtbroken.icbm.api.modules.IMissile;
import com.builtbroken.icbm.content.launcher.TileMissileContainer;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.storage.IMissileMag;
import com.builtbroken.icbm.content.storage.IMissileMagOutput;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.tile.IRotatable;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.api.tile.provider.IInventoryProvider;
import com.builtbroken.mc.framework.block.imp.IDestroyedListener;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.prefab.inventory.ExternalInventory;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import io.netty.buffer.ByteBuf;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileSmallMag
extends TileMissileContainer
implements IMissileMag,
IDestroyedListener,
IRotatable {
    protected static final ForgeDirection[] rotations = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    public static final int MISSILE_MOTION_DELAY = 40;
    protected List<WeakReference<TileSmallMag>> updateList = new LinkedList<WeakReference<TileSmallMag>>();
    protected WeakReference<IMissileMagOutput> targetTile;
    private int movementDelay = 0;
    private boolean doMotion = false;
    private ForgeDirection dirCache;

    public TileSmallMag() {
        super("mag.small", "icbm");
    }

    @Override
    protected IInventory createInventory() {
        return new ExternalInventory((IInventoryProvider)this, 1);
    }

    public void update(long ticks) {
        super.update(ticks);
        if (this.isServer()) {
            if (ticks % 20L == 0L) {
                this.queueMotion();
            }
            if (this.doMotion && this.movementDelay > -2 && this.movementDelay-- < 0) {
                this.movementDelay = -2;
                this.doMovement();
            }
        }
    }

    public void onNeighborChanged(Block block) {
        this.updateList.clear();
        Location location = this.toLocation();
        for (ForgeDirection side : rotations) {
            TileEntity tile;
            Location l = (Location)location.add(side);
            if (!location.isChunkLoaded() || !((tile = l.getTileEntity()) instanceof ITileNodeHost) || !(((ITileNodeHost)tile).getTileNode() instanceof TileSmallMag)) continue;
            this.updateList.add(new WeakReference<TileSmallMag>((TileSmallMag)((ITileNodeHost)tile).getTileNode()));
        }
        this.queueMotion();
    }

    protected void doMovement() {
        this.doMotion = false;
        if (this.getMissileItem() != null) {
            if (this.targetTile == null || this.targetTile.get() == null || this.targetTile.get() instanceof TileEntity && ((TileEntity)this.targetTile.get()).func_145837_r() || this.targetTile.get() instanceof ITileNode && !((ITileNode)this.targetTile.get()).getHost().isHostValid()) {
                ITileNode node;
                Location location = (Location)this.toLocation().add(this.getDirection());
                TileEntity tile = location.getTileEntity();
                if (tile instanceof IMissileMagOutput) {
                    this.targetTile = new WeakReference<IMissileMagOutput>((IMissileMagOutput)tile);
                } else if (tile instanceof ITileNodeHost && (node = ((ITileNodeHost)tile).getTileNode()) instanceof IMissileMagOutput) {
                    this.targetTile = new WeakReference<IMissileMagOutput>((IMissileMagOutput)node);
                }
            }
            if (this.targetTile != null) {
                IMissile missile = this.getMissile();
                if (((IMissileMagOutput)this.targetTile.get()).canAcceptMissile(missile) && ((IMissileMagOutput)this.targetTile.get()).storeMissile(missile)) {
                    this.getInventory().func_70299_a(0, null);
                    Iterator<WeakReference<TileSmallMag>> it = this.updateList.iterator();
                    while (it.hasNext()) {
                        WeakReference<TileSmallMag> ref = it.next();
                        if (ref == null || ref.get() == null || ((TileSmallMag)ref.get()).isInvalid()) {
                            it.remove();
                            continue;
                        }
                        ((TileSmallMag)ref.get()).queueMotion();
                    }
                }
            }
        }
    }

    public void queueMotion() {
        this.doMotion = true;
        if (this.movementDelay <= -2) {
            this.movementDelay = 40;
        }
    }

    @Override
    public boolean canAcceptMissile(IMissile missile) {
        return super.canAcceptMissile(missile) && missile.getMissileSize() == MissileSize.SMALL.ordinal();
    }

    public boolean removedByPlayer(EntityPlayer player, boolean willHarvest) {
        if (willHarvest && this.getMissileItem() != null) {
            InventoryUtility.dropItemStack((IWorldPosition)this.toLocation(), (ItemStack)this.getMissileItem());
            this.getInventory().func_70299_a(0, null);
        }
        return false;
    }

    @Override
    public void onInventoryChanged(int slot, ItemStack prev, ItemStack item) {
        super.onInventoryChanged(slot, prev, item);
        if (slot == 0) {
            this.queueMotion();
        }
    }

    @Override
    public void readDescPacket(ByteBuf buf) {
        super.readDescPacket(buf);
        ((World)this.world().unwrap()).func_147458_c(this.xi(), this.yi(), this.zi(), this.xi(), this.yi(), this.zi());
    }

    public ForgeDirection getDirection() {
        if (this.dirCache == null) {
            this.dirCache = ForgeDirection.getOrientation((int)((World)this.world().unwrap()).func_72805_g(this.xi(), this.yi(), this.zi()));
        }
        return this.dirCache;
    }

    public void setDirection(ForgeDirection direction) {
        int meta = direction.ordinal();
        if (meta >= 2 && meta <= 5) {
            this.dirCache = null;
            ((World)this.world().unwrap()).func_72921_c(this.xi(), this.yi(), this.zi(), meta, 3);
        }
    }
}

