/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.warhead;

import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.api.warhead.IWarheadHandler;
import com.builtbroken.icbm.api.warhead.IWarheadItem;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.icbm.content.missile.parts.warhead.Warhead;
import com.builtbroken.icbm.content.missile.parts.warhead.WarheadCasings;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.items.explosives.IExplosiveItem;
import com.builtbroken.mc.client.ExplosiveRegistryClient;
import com.builtbroken.mc.framework.explosive.ExplosiveItemUtility;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemBlockWarhead
extends ItemBlock
implements IWarheadItem {
    @SideOnly(value=Side.CLIENT)
    IIcon emptyIcon;

    public ItemBlockWarhead(Block block) {
        super(block);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        super.func_94581_a(reg);
        for (WarheadCasings casing : WarheadCasings.values()) {
            casing.icon = reg.func_94245_a("icbm:warhead." + casing.name().replace("EXPLOSIVE_", "").toLowerCase());
        }
        this.emptyIcon = reg.func_94245_a("voltzengine:blank");
    }

    @SideOnly(value=Side.CLIENT)
    public int func_94901_k() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta >= 0 && meta < WarheadCasings.values().length) {
            return WarheadCasings.values()[meta].icon;
        }
        return Items.field_151034_e.func_77617_a(meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        if (pass > 0) {
            IIcon icon = ExplosiveRegistryClient.getCornerIconFor((ItemStack)stack, (int)(pass - 1));
            if (icon == null) {
                return this.emptyIcon;
            }
            return icon;
        }
        return this.func_77617_a(stack.func_77960_j());
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        if (pass > 0) {
            return ExplosiveRegistryClient.getColorForCornerIcon((ItemStack)stack, (int)(pass - 1));
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    public String func_77658_a() {
        return "tile.icbm:warhead";
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + WarheadCasings.get(stack.func_77960_j()).name().replace("EXPLOSIVE_", "").toLowerCase();
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List lines, boolean b) {
        super.func_77624_a(stack, player, lines, b);
        IWarhead warhead = this.getModule(stack);
        if (warhead != null) {
            IExplosiveHandler ex = warhead.getExplosive();
            if (ex instanceof IWarheadHandler) {
                ((IWarheadHandler)ex).addInfoToItem(player, warhead, lines);
            } else {
                ExplosiveItemUtility.addInformation((ItemStack)stack, (IExplosiveHandler)ex, (EntityPlayer)player, (List)lines, (boolean)b);
            }
        } else {
            lines.add(LanguageUtility.getLocalName((String)"warhead.error.missing_data"));
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityPlayer player) {
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int t, boolean b) {
    }

    public EnumAction func_77661_b(ItemStack p_77661_1_) {
        return EnumAction.none;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 0;
    }

    public void func_77615_a(ItemStack p_77615_1_, World p_77615_2_, EntityPlayer p_77615_3_, int p_77615_4_) {
    }

    public boolean onDroppedByPlayer(ItemStack item, EntityPlayer player) {
        return true;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77951_h();
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 6000;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return false;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return null;
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        return false;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, int armorSlot) {
        return null;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack stack, int pass) {
        return super.hasEffect(stack, pass);
    }

    @Override
    public IWarhead getModule(ItemStack stack) {
        if (stack != null) {
            ItemStack insert = stack.func_77946_l();
            insert.field_77994_a = 1;
            IWarhead warhead = MissileModuleBuilder.INSTANCE.buildWarhead(insert);
            if (warhead == null) {
                warhead = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.fromMeta(insert.func_77960_j()), (ItemStack)null);
            }
            warhead.save(insert);
            warhead.save(stack);
            return warhead;
        }
        return null;
    }

    public NBTTagCompound getAdditionalExplosiveData(ItemStack stack) {
        ItemStack explosive = this.getExplosiveStack(stack);
        if (explosive != null && explosive.func_77973_b() instanceof IExplosiveItem) {
            return ((IExplosiveItem)explosive.func_77973_b()).getAdditionalExplosiveData(explosive);
        }
        return null;
    }

    public double getExplosiveSize(ItemStack stack) {
        ItemStack explosive = this.getExplosiveStack(stack);
        if (explosive != null) {
            return ExplosiveRegistry.getExplosiveSize((ItemStack)explosive);
        }
        return 0.0;
    }

    public IExplosiveHandler getExplosive(ItemStack stack) {
        ItemStack explosive = this.getExplosiveStack(stack);
        if (explosive != null) {
            return ExplosiveRegistry.get((ItemStack)explosive);
        }
        return null;
    }

    public ItemStack getExplosiveStack(ItemStack stack) {
        return Warhead.loadExplosiveItemFromNBT(stack.func_77978_p());
    }

    public boolean setExplosiveStack(ItemStack stack, ItemStack explosive) {
        IWarhead warhead = this.getModule(stack);
        if (warhead != null && !InventoryUtility.stacksMatchExact((ItemStack)this.getExplosiveStack(stack), (ItemStack)explosive)) {
            warhead.setExplosiveStack(explosive);
            warhead.save(stack.func_77978_p());
            return true;
        }
        return false;
    }
}

