/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.icbm.content.warhead;

import com.builtbroken.icbm.ICBM;
import com.builtbroken.icbm.api.ICBM_API;
import com.builtbroken.icbm.api.modules.IWarhead;
import com.builtbroken.icbm.client.Assets;
import com.builtbroken.icbm.content.missile.data.missile.MissileSize;
import com.builtbroken.icbm.content.missile.parts.MissileModuleBuilder;
import com.builtbroken.icbm.content.missile.parts.warhead.Warhead;
import com.builtbroken.icbm.content.missile.parts.warhead.WarheadCasings;
import com.builtbroken.icbm.content.missile.parts.warhead.WarheadStandard;
import com.builtbroken.icbm.content.warhead.ItemBlockWarhead;
import com.builtbroken.icbm.content.warhead.MicroMissileRecipe;
import com.builtbroken.icbm.content.warhead.WarheadRecipe;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosive;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.api.tile.IRemovable;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.content.resources.items.ItemSheetMetal;
import com.builtbroken.mc.core.content.tool.ItemSheetMetalTools;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.registry.implement.IPostInit;
import com.builtbroken.mc.framework.explosive.ExplosiveItemUtility;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.recipe.item.sheetmetal.RecipeSheetMetal;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.data.item.ItemStackWrapper;
import com.builtbroken.mc.lib.helper.WrenchUtility;
import com.builtbroken.mc.lib.helper.recipe.UniversalRecipe;
import com.builtbroken.mc.lib.world.edit.WorldChangeHelper;
import com.builtbroken.mc.prefab.tile.Tile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;
import org.lwjgl.opengl.GL11;

public class TileWarhead
extends Tile
implements IExplosive,
IRemovable.ISneakPickup,
IPostInit {
    public boolean exploding = false;
    private IWarhead warhead;

    public TileWarhead() {
        super("warhead", Material.field_151573_f);
        this.textureName = "warhead";
        this.hardness = 100.0f;
        this.resistance = 10.0f;
        this.renderNormalBlock = false;
        this.renderType = -1;
        this.renderTileEntity = true;
        this.isOpaque = false;
        this.itemBlock = ItemBlockWarhead.class;
        this.bounds = new Cube(0.2, 0.0, 0.2, 0.8, 0.5, 0.8);
    }

    public void onPostInit() {
        RecipeSorter.register((String)"icbm:warhead", WarheadRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shaped");
        RecipeSorter.register((String)"icbm:microMissile", MicroMissileRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shaped");
        ArrayList<IRecipe> recipes = new ArrayList<IRecipe>();
        TileWarhead.getRecipes(recipes);
        for (IRecipe recipe : recipes) {
            GameRegistry.addRecipe((IRecipe)recipe);
        }
    }

    public static void getRecipes(List<IRecipe> recipes) {
        ItemStack micro_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, (ItemStack)null).toStack();
        ItemStack small_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_SMALL, (ItemStack)null).toStack();
        ItemStack medium_warhead_empty = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_STANDARD, (ItemStack)null).toStack();
        if (Engine.itemSheetMetal != null && Engine.itemSheetMetalTools != null) {
            recipes.add((IRecipe)new RecipeSheetMetal(micro_warhead_empty, new Object[]{" p ", "tch", " r ", Character.valueOf('p'), Blocks.field_150456_au, Character.valueOf('c'), ItemSheetMetal.SheetMetal.CONE_MICRO.stack(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('t'), ItemSheetMetal.SheetMetal.THIRD.stack(), Character.valueOf('h'), ItemSheetMetalTools.getHammer()}));
            recipes.add((IRecipe)new RecipeSheetMetal(small_warhead_empty, new Object[]{" p ", "tch", " r ", Character.valueOf('p'), Blocks.field_150443_bT, Character.valueOf('c'), ItemSheetMetal.SheetMetal.CONE_SMALL.stack(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('t'), ItemSheetMetal.SheetMetal.HALF.stack(), Character.valueOf('h'), ItemSheetMetalTools.getHammer()}));
            recipes.add((IRecipe)new RecipeSheetMetal(medium_warhead_empty, new Object[]{" p ", "tch", " r ", Character.valueOf('p'), Blocks.field_150443_bT, Character.valueOf('c'), ItemSheetMetal.SheetMetal.CONE_MEDIUM.stack(), Character.valueOf('r'), Items.field_151137_ax, Character.valueOf('t'), ItemSheetMetal.SheetMetal.FULL.stack(), Character.valueOf('h'), ItemSheetMetalTools.getHammer()}));
        } else {
            micro_warhead_empty.field_77994_a = 8;
            recipes.add((IRecipe)new ShapedOreRecipe(micro_warhead_empty, new Object[]{" p ", " n ", "nrn", Character.valueOf('p'), Blocks.field_150456_au, Character.valueOf('n'), "ingotIron", Character.valueOf('r'), "dustRedstone"}));
            micro_warhead_empty.field_77994_a = 1;
            recipes.add((IRecipe)new ShapedOreRecipe(small_warhead_empty, new Object[]{" p ", " n ", "ncn", Character.valueOf('p'), Blocks.field_150443_bT, Character.valueOf('n'), "ingotIron", Character.valueOf('r'), "dustRedstone", Character.valueOf('c'), UniversalRecipe.CIRCUIT_T1.get()}));
        }
        for (IExplosiveHandler handler : ExplosiveRegistry.getExplosives()) {
            TileWarhead.getRecipes(handler, recipes);
        }
    }

    public static void getRecipes(IExplosiveHandler handler, List<IRecipe> recipes) {
        List items = ExplosiveRegistry.getItems((IExplosiveHandler)handler);
        if (items != null) {
            for (ItemStackWrapper wrapper : items) {
                if (wrapper != null && wrapper.itemStack != null) {
                    ItemStack stack = wrapper.itemStack.func_77946_l();
                    stack.field_77994_a = 1;
                    Warhead micro_warhead = MissileModuleBuilder.INSTANCE.buildWarhead(WarheadCasings.EXPLOSIVE_MICRO, stack);
                    recipes.add((IRecipe)new MicroMissileRecipe(new ItemStack(ICBM_API.itemMissile, 1, MissileSize.MICRO.ordinal()), micro_warhead.toStack()));
                    continue;
                }
                Engine.error((String)("Wrapper stack for explosive " + handler + " is invalid " + wrapper));
            }
        }
    }

    public void onCollide(Entity entity) {
        if (entity != null && entity.func_70027_ad()) {
            this.explode((TriggerCause)new TriggerCause.TriggerCauseEntity(entity));
        }
    }

    public Tile newTile() {
        return new TileWarhead();
    }

    public boolean onPlayerActivated(EntityPlayer entityPlayer, int side, Pos hit) {
        if (entityPlayer.func_71045_bC() != null) {
            if (entityPlayer.func_71045_bC().func_77973_b() == Items.field_151033_d) {
                this.explode((TriggerCause)new TriggerCause.TriggerCauseFire(ForgeDirection.getOrientation((int)side)));
                return true;
            }
            if (WrenchUtility.isUsableWrench((EntityPlayer)entityPlayer, (ItemStack)entityPlayer.func_71045_bC(), (int)this.xi(), (int)this.yi(), (int)this.zi())) {
                int change = 3;
                switch (this.func_145832_p()) {
                    case 0: {
                        change = 2;
                        break;
                    }
                    case 2: {
                        change = 5;
                        break;
                    }
                    case 5: {
                        change = 3;
                        break;
                    }
                    case 3: {
                        change = 4;
                        break;
                    }
                    case 4: {
                        change = 1;
                        break;
                    }
                    case 1: {
                        change = 0;
                    }
                }
                this.setMeta(ForgeDirection.getOrientation((int)change).ordinal());
                this.oldWorld().func_147444_c(this.xi(), this.yi(), this.zi(), this.func_145838_q());
                return true;
            }
        }
        return false;
    }

    public void onPlaced(EntityLivingBase entityLiving, ItemStack itemStack) {
        super.onPlaced(entityLiving, itemStack);
        if (!this.oldWorld().field_72995_K && ExplosiveItemUtility.getExplosive((ItemStack)itemStack) != null) {
            this.setWarhead(MissileModuleBuilder.INSTANCE.buildWarhead(itemStack));
            this.setMeta(this.determineOrientation(entityLiving));
            int power_side = -1;
            int powerMax = 0;
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                Location position = this.toLocation();
                position.add(ForgeDirection.getOrientation((int)i));
                Block b = position.getBlock();
                if (this.oldWorld().func_72878_l(this.xi(), this.yi(), this.zi(), i) > powerMax) {
                    powerMax = this.oldWorld().func_72878_l(this.xi(), this.yi(), this.zi(), i);
                    power_side = i;
                }
                if (b != Blocks.field_150480_ab && b != Blocks.field_150353_l && b != Blocks.field_150356_k) continue;
                this.explode((TriggerCause)new TriggerCause.TriggerCauseFire(ForgeDirection.getOrientation((int)i)));
                return;
            }
            if (power_side != -1) {
                this.explode((TriggerCause)new TriggerCause.TriggerCauseRedstone(ForgeDirection.UNKNOWN, powerMax));
            }
        }
    }

    public void onWorldJoin() {
        super.onWorldJoin();
        this.oldWorld().func_147471_g(this.xi(), this.yi(), this.zi());
    }

    public void onNeighborChanged(Block block) {
        super.onNeighborChanged(block);
        int power_side = -1;
        int powerMax = 0;
        for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
            Location position = this.toLocation();
            position.add(ForgeDirection.getOrientation((int)i));
            Block b = position.getBlock();
            if (this.oldWorld().func_72878_l(this.xi(), this.yi(), this.zi(), i) > powerMax) {
                powerMax = this.oldWorld().func_72878_l(this.xi(), this.yi(), this.zi(), i);
                power_side = i;
            }
            if (b != Blocks.field_150480_ab && b != Blocks.field_150353_l && b != Blocks.field_150356_k) continue;
            this.explode((TriggerCause)new TriggerCause.TriggerCauseFire(ForgeDirection.getOrientation((int)i)));
            return;
        }
        if (power_side != -1) {
            this.explode((TriggerCause)new TriggerCause.TriggerCauseRedstone(ForgeDirection.UNKNOWN, powerMax));
        }
    }

    public void explode(TriggerCause triggerCause) {
        if (!this.exploding) {
            this.exploding = true;
            if (this.getWarhead().trigger(triggerCause, this.oldWorld(), this.x(), this.y(), this.z()) == WorldChangeHelper.ChangeResult.COMPLETED) {
                this.oldWorld().func_147468_f(this.xi(), this.yi(), this.zi());
            } else {
                this.exploding = false;
            }
        }
    }

    public void onDestroyedByExplosion(Explosion explosion) {
        this.explode((TriggerCause)new TriggerCause.TriggerCauseExplosion(explosion));
    }

    public boolean canUpdate() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.setWarhead(null);
        if (nbt.func_74764_b("itemWarhead")) {
            this.setWarhead(MissileModuleBuilder.INSTANCE.buildWarhead(ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemWarhead"))));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.getWarhead() != null && this.getWarhead().toStack() != null) {
            nbt.func_74782_a("itemWarhead", (NBTBase)this.getWarhead().toStack().func_77955_b(new NBTTagCompound()));
        }
    }

    public PacketTile getDescPacket() {
        return new PacketTile((TileEntity)this, new Object[]{this.getSaveData()});
    }

    public IExplosiveHandler getExplosive() {
        return this.getWarhead().getExplosive();
    }

    public NBTTagCompound getAdditionalExplosiveData() {
        return this.getWarhead().getAdditionalExplosiveData();
    }

    public double getExplosiveSize() {
        return this.getWarhead().getExplosiveSize();
    }

    public void getSubBlocks(Item item, CreativeTabs tabs, List list) {
        for (WarheadCasings size : WarheadCasings.values()) {
            if (!size.enabled) continue;
            list.add(MissileModuleBuilder.INSTANCE.buildWarhead(size, (ItemStack)null).toStack());
        }
        for (IExplosiveHandler handler : ExplosiveRegistry.getExplosives()) {
            List items = ExplosiveRegistry.getItems((IExplosiveHandler)handler);
            if (items == null) continue;
            for (ItemStackWrapper wrapper : items) {
                for (WarheadCasings size : WarheadCasings.values()) {
                    if (!size.enabled) continue;
                    Warhead warhead = MissileModuleBuilder.INSTANCE.buildWarhead(size, wrapper.itemStack);
                    warhead.explosive.field_77994_a = warhead.getMaxExplosives();
                    list.add(warhead.toStack());
                }
            }
        }
    }

    public ItemStack toItemStack() {
        ItemStack stack = new ItemStack(this.func_145838_q());
        stack.func_77982_d(new NBTTagCompound());
        if (this.getWarhead() != null) {
            this.getWarhead().save(stack.func_77978_p());
        } else {
            stack.func_77964_b(1);
        }
        return stack;
    }

    public List<ItemStack> getRemovedItems(EntityPlayer entity) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.toItemStack());
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Pos position, float frame, int pass) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(position.xf() + 0.5f), (float)(position.yf() - 2.5f), (float)(position.zf() + 0.5f));
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(Assets.CLASSIC_MISSILE_TEXTURE);
        Assets.CLASSIC_MISSILE_MODEL.renderOnly(new String[]{"WARHEAD 1", "WARHEAD 2", "WARHEAD 3", "WARHEAD 4"});
        GL11.glPopMatrix();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return Blocks.field_150339_S.func_149691_a(0, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister reg) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return WarheadCasings.get((int)meta).icon;
    }

    public IWarhead getWarhead() {
        if (this.warhead == null) {
            this.warhead = this.getNewWarhead();
            if (this.warhead == null) {
                this.warhead = new WarheadStandard(this.toItemStack());
            }
        }
        return this.warhead;
    }

    public IWarhead getNewWarhead() {
        Warhead warhead;
        block8: {
            warhead = null;
            try {
                warhead = WarheadCasings.get((int)this.getMetadata()).warhead_clazz.getConstructor(ItemStack.class).newInstance(new ItemStack((Block)this.getTileBlock(), 1, this.getMetadata()));
            }
            catch (InvocationTargetException e) {
                ICBM.INSTANCE.logger().error("[TileWarhead]Failed invoke warhead constructor for class " + WarheadCasings.get((int)this.getMetadata()).warhead_clazz);
                if (Engine.runningAsDev) {
                    e.printStackTrace();
                }
            }
            catch (NoSuchMethodException e) {
                ICBM.INSTANCE.logger().error("[TileWarhead]Failed to find ItemStack constructor for warhead class " + WarheadCasings.get((int)this.getMetadata()).warhead_clazz);
                if (Engine.runningAsDev) {
                    e.printStackTrace();
                }
            }
            catch (InstantiationException e) {
                ICBM.INSTANCE.logger().error("[TileWarhead]Failed to create new warhead instance for warhead class " + WarheadCasings.get((int)this.getMetadata()).warhead_clazz);
                if (Engine.runningAsDev) {
                    e.printStackTrace();
                }
            }
            catch (IllegalAccessException e) {
                ICBM.INSTANCE.logger().error("[TileWarhead]Something prevented us from making a new instance of class " + WarheadCasings.get((int)this.getMetadata()).warhead_clazz);
                if (!Engine.runningAsDev) break block8;
                e.printStackTrace();
            }
        }
        return warhead;
    }

    public void setWarhead(IWarhead warhead) {
        this.warhead = warhead;
    }
}

