/*
 * Decompiled with CFR 0.152.
 */
package com.mia.craftstudio.minecraft;

import com.mia.craftstudio.libgdx.Matrix4;
import com.mia.craftstudio.libgdx.Vector3;
import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class ProjectionHelper {
    public static Matrix4 getOrthoMatrix() {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution rez = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        float left = 0.0f;
        float right = rez.func_78326_a();
        float bottom = rez.func_78328_b();
        float top = 0.0f;
        float near = 1000.0f;
        float far = 3000.0f;
        float tx = -(right + left) / (right - left);
        float ty = -(top + bottom) / (top - bottom);
        float tz = -(far + near) / (far - near);
        Matrix4 ortho = new Matrix4();
        ortho.val[0] = 2.0f / (right - left);
        ortho.val[5] = 2.0f / (top - bottom);
        ortho.val[10] = -2.0f / (far - near);
        ortho.val[15] = 1.0f;
        ortho.val[12] = tx;
        ortho.val[13] = ty;
        ortho.val[14] = tz;
        return ortho;
    }

    public static Vector3[] getExtend(Vector3[] vertices) {
        float xMin = Float.MAX_VALUE;
        float yMin = Float.MAX_VALUE;
        float zMin = Float.MAX_VALUE;
        float xMax = -3.4028235E38f;
        float yMax = -3.4028235E38f;
        float zMax = -3.4028235E38f;
        for (int i = 0; i < 8; ++i) {
            xMin = Math.min(xMin, vertices[i].x);
            yMin = Math.min(yMin, vertices[i].y);
            zMin = Math.min(zMin, vertices[i].z);
            xMax = Math.max(xMax, vertices[i].x);
            yMax = Math.max(yMax, vertices[i].y);
            zMax = Math.max(zMax, vertices[i].z);
        }
        Vector3[] extend = new Vector3[]{new Vector3(xMin, yMin, zMin), new Vector3(xMax, yMax, zMax)};
        return extend;
    }

    public static void printMatrix(int glMatrix) {
        FloatBuffer projmat = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)glMatrix, (FloatBuffer)projmat);
        for (int i = 0; i < 4; ++i) {
            System.out.printf("%16.10f ", Float.valueOf(projmat.get(i)));
            System.out.printf("%16.10f ", Float.valueOf(projmat.get(i + 4)));
            System.out.printf("%16.10f ", Float.valueOf(projmat.get(i + 8)));
            System.out.printf("%16.10f ", Float.valueOf(projmat.get(i + 12)));
            System.out.printf("\n", new Object[0]);
        }
        System.out.printf("======\n", new Object[0]);
    }

    public static Matrix4 getMatrix(int glMatrix) {
        FloatBuffer projmat = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)glMatrix, (FloatBuffer)projmat);
        Matrix4 retmat = new Matrix4();
        for (int i = 0; i < 16; ++i) {
            retmat.val[i] = projmat.get();
        }
        return retmat;
    }
}

