/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.core.render.IconRegistry;
import cofh.lib.util.helpers.StringHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.TileAugmentable;
import cofh.thermalexpansion.block.TileTEBase;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.core.TEProps;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public abstract class TileDeviceBase
extends TileAugmentable {
    protected static final TileTEBase.SideConfig[] defaultSideConfig = new TileTEBase.SideConfig[BlockDevice.Types.values().length];
    public static final boolean[] enableSecurity = new boolean[BlockDevice.Types.values().length];
    protected final byte type;

    public static void configure() {
        for (int i = 0; i < BlockDevice.Types.values().length; ++i) {
            String string = StringHelper.titleCase((String)BlockDevice.NAMES[i]);
            String string2 = "Enable this to allow for " + string + "s to be securable.";
            TileDeviceBase.enableSecurity[i] = ThermalExpansion.config.get("Security", "Device." + string + ".Securable", true, string2);
        }
        ThermalExpansion.config.removeProperty("Security", "Device." + StringHelper.titleCase((String)BlockDevice.NAMES[BlockDevice.Types.WORKBENCH_FALSE.ordinal()]) + ".Securable");
        ThermalExpansion.config.removeProperty("Security", "Device." + StringHelper.titleCase((String)BlockDevice.NAMES[BlockDevice.Types.PUMP.ordinal()]) + ".Securable");
        ThermalExpansion.config.removeProperty("Security", "Device." + StringHelper.titleCase((String)BlockDevice.NAMES[BlockDevice.Types.EXTENDER.ordinal()]) + ".Securable");
    }

    public TileDeviceBase() {
        this(BlockDevice.Types.BREAKER);
        if (((Object)((Object)this)).getClass() != TileDeviceBase.class) {
            throw new IllegalArgumentException();
        }
    }

    public TileDeviceBase(BlockDevice.Types types) {
        this.type = (byte)types.ordinal();
        this.sideConfig = defaultSideConfig[this.type];
        this.setDefaultSides();
        this.augmentStatus = new boolean[4];
        this.augments = new ItemStack[4];
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return "tile.thermalexpansion.device." + BlockDevice.NAMES[this.getType()] + ".name";
    }

    @Override
    public boolean enableSecurity() {
        return enableSecurity[this.getType()];
    }

    @Override
    public boolean sendRedstoneUpdates() {
        return true;
    }

    public void onEntityCollidedWithBlock(Entity entity) {
    }

    @Override
    public boolean allowYAxisFacing() {
        return true;
    }

    @Override
    public boolean setFacing(int n) {
        if (n < 0 || n > 5) {
            return false;
        }
        this.facing = (byte)n;
        this.sideCache[this.facing] = 0;
        this.sideCache[this.facing ^ 1] = 1;
        this.func_70296_d();
        this.sendUpdatePacket(Side.CLIENT);
        return true;
    }

    @Override
    public IIcon getTexture(int n, int n2) {
        if (n2 == 0) {
            return n != this.facing ? BlockDevice.deviceSide : (this.redstoneControlOrDisable() ? BlockDevice.deviceActive[this.type] : BlockDevice.deviceFace[this.type]);
        }
        if (n < 6) {
            return IconRegistry.getIcon((String)TEProps.textureSelection, (int)this.sideConfig.sideTex[this.sideCache[n]]);
        }
        return BlockDevice.deviceSide;
    }
}

