/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity;

import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftProtective;
import net.ilexiconn.jurassicraft.common.entity.ai.animation.AnimationAICharge;
import net.ilexiconn.jurassicraft.common.handler.AnimationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class EntityJurassiCraftCharges
extends EntityJurassiCraftProtective {
    public boolean charging = false;
    public float distanceFromTarget;
    public int timeSinceCharge = 0;
    public int stepCount = 0;

    public EntityJurassiCraftCharges(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AnimationAICharge(this));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70638_az() != null) {
            this.distanceFromTarget = this.func_70638_az() != null ? (float)Math.sqrt(Math.pow(this.field_70165_t - this.func_70638_az().field_70165_t, 2.0) + Math.pow(this.field_70161_v - this.func_70638_az().field_70161_v, 2.0)) : -1.0f;
            if (this.func_70638_az() != null && this.field_70122_E && this.timeSinceCharge == 0 && !this.isFleeing() && this.getCreatureAgeInDays() >= 17) {
                AnimationHandler.sendAnimationPacket(this, JurassiCraftAnimationIDs.CHARGE.animID());
            }
        } else {
            this.distanceFromTarget = -1.0f;
        }
        if (this.timeSinceCharge != 0) {
            --this.timeSinceCharge;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.stepCount <= 0 && this.charging) {
            this.func_85030_a("jurassicraft:gallop", 3.0f, this.func_70647_i() - 0.5f);
            this.stepCount = 10;
        }
        --this.stepCount;
    }

    public void func_82167_n(Entity victim) {
        super.func_82167_n(victim);
        if (this.charging && (this.isTamed() || !this.getClass().equals(victim.getClass()))) {
            victim.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 20.0f);
            double deltaX = victim.field_70165_t - this.field_70165_t;
            double deltaZ = victim.field_70161_v - this.field_70161_v;
            double angleYaw = (float)Math.atan2(deltaZ, deltaX);
            victim.field_70159_w += Math.cos(angleYaw);
            victim.field_70179_y += Math.sin(angleYaw);
            victim.field_70181_x += 0.3;
        }
    }

    @Override
    public void ridingPlayerRightClick() {
        if (this.field_70122_E && this.timeSinceCharge < 75 && this.getCreatureAgeInDays() >= 17 && ((EntityPlayer)this.field_70153_n).func_70694_bm() != null && this.getCreature().isRidingItem(((EntityPlayer)this.field_70153_n).func_70694_bm().func_77973_b())) {
            this.decreaseHeldItemDurability(40);
            AnimationHandler.sendAnimationPacket(this, JurassiCraftAnimationIDs.CHARGE.animID());
        }
    }
}

