/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.ai;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class JurassiCraftAIGoNearWater
extends EntityAIBase {
    private double speed;
    private EntityJurassiCraftCreature creature;
    private World world;
    private boolean foundPool;
    private float poolX;
    private float poolY;
    private float poolZ;
    private int maxDist;
    private long lastTimeExecuted;
    private float maxTime;

    public JurassiCraftAIGoNearWater(EntityJurassiCraftCreature creature, double creatureSpeed) {
        this(creature, creatureSpeed, 19.75f);
    }

    public JurassiCraftAIGoNearWater(EntityJurassiCraftCreature creature, double creatureSpeed, float maxTime) {
        this(creature, creatureSpeed, 25, maxTime);
    }

    public JurassiCraftAIGoNearWater(EntityJurassiCraftCreature creature, double creatureSpeed, int maxSearchDistance, float maxTime) {
        this.creature = creature;
        this.world = creature.field_70170_p;
        this.speed = creatureSpeed;
        this.maxDist = maxSearchDistance;
        this.poolY = -64.0f;
        this.maxTime = maxTime;
    }

    public boolean func_75253_b() {
        return !this.foundPool && this.creature.func_70011_f(this.poolX, this.poolY, this.poolZ) > 5.0;
    }

    public void func_75249_e() {
        ArrayList waterBlocks = Lists.newArrayList();
        int startX = (int)Math.floor(this.creature.field_70165_t);
        int startY = (int)Math.floor(this.creature.field_70163_u);
        int startZ = (int)Math.floor(this.creature.field_70161_v);
        for (int x = -this.maxDist / 2 + startX; x < this.maxDist / 2 + startX; ++x) {
            for (int y = -this.maxDist / 2 + startY; y < this.maxDist / 2 + startY; ++y) {
                for (int z = -this.maxDist / 2 + startZ; z < this.maxDist / 2 + startZ; ++z) {
                    if (this.world.func_147439_a(x, y, z) != Blocks.field_150355_j) continue;
                    waterBlocks.add(Vec3.func_72443_a((double)x, (double)y, (double)z));
                }
            }
        }
        ArrayList blobsList = Lists.newArrayList();
        block3: for (Vec3 waterPos : waterBlocks) {
            for (Object list : blobsList) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Vec3 pos = (Vec3)iterator.next();
                    if (!this.isNextTo(pos, waterPos)) continue;
                    list.add(waterPos);
                    continue block3;
                }
            }
            List blob = Lists.newArrayList();
            blob.add(waterPos);
            blobsList.add(blob);
        }
        ArrayList finalList = Lists.newArrayList();
        finalList.addAll(blobsList);
        block6: for (List blob : blobsList) {
            for (Vec3 pos : blob) {
                for (List otherBlob : blobsList) {
                    for (Vec3 otherPos : otherBlob) {
                        if (!this.isNextTo(pos, otherPos) || !finalList.contains(blob) || !finalList.contains(otherBlob)) continue;
                        ArrayList mergedBlob = Lists.newArrayList();
                        mergedBlob.addAll(blob);
                        mergedBlob.addAll(otherBlob);
                        finalList.add(mergedBlob);
                        finalList.remove(blob);
                        finalList.remove(otherBlob);
                        continue block6;
                    }
                }
            }
        }
        for (List blob : finalList) {
            double centerX = 0.0;
            double centerY = 0.0;
            double centerZ = 0.0;
            for (Vec3 pos : blob) {
                centerX += pos.field_72450_a;
                centerY += pos.field_72448_b;
                centerZ += pos.field_72449_c;
            }
            if (!(this.creature.func_70011_f(centerX /= (double)blob.size(), centerY /= (double)blob.size(), centerZ /= (double)blob.size()) <= this.creature.func_70011_f(this.poolX, this.poolY, this.poolZ)) && !(this.poolY <= 0.0f)) continue;
            this.poolX = (float)Math.floor(centerX);
            this.poolY = (float)Math.floor(centerY);
            this.poolZ = (float)Math.floor(centerZ);
            this.lastTimeExecuted = this.world.func_72820_D();
            this.foundPool = true;
        }
    }

    public void func_75246_d() {
        if (this.foundPool) {
            PathNavigate navigator = this.creature.func_70661_as();
            PathEntity path = navigator.func_75488_a((double)this.poolX, (double)this.poolY, (double)this.poolZ);
            if (path != null) {
                navigator.func_75484_a(path, this.speed);
            }
            this.lastTimeExecuted = this.world.func_72820_D();
        }
    }

    public boolean func_75252_g() {
        return true;
    }

    private boolean isNextTo(Vec3 a, Vec3 b) {
        double dx = a.field_72450_a - b.field_72450_a;
        double dy = a.field_72448_b - b.field_72448_b;
        double dz = a.field_72449_c - b.field_72449_c;
        return dx + dy + dz == 1.0;
    }

    public void func_75251_c() {
        super.func_75251_c();
        this.foundPool = false;
        this.poolX = 0.0f;
        this.poolY = -64.0f;
        this.poolZ = 0.0f;
        this.lastTimeExecuted = this.world.func_72820_D();
    }

    public boolean func_75250_a() {
        return (float)(this.world.func_72820_D() - this.lastTimeExecuted) >= this.maxTime && Math.random() < 0.1;
    }
}

