/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.dinosaurs;

import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.ChainBuffer;
import net.ilexiconn.jurassicraft.common.entity.ControlledAnimation;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftGroupAggressive;
import net.ilexiconn.jurassicraft.common.entity.IntermittentAnimation;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEatDroppedFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEating;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIFollowFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerHurtsTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerIsHurtByTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAISitNatural;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAITargetIfHasAgeAndNonTamed;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIWander;
import net.ilexiconn.jurassicraft.common.entity.ai.herds.HerdAIFollowHerd;
import net.ilexiconn.jurassicraft.common.entity.ai.herds.HerdAIGroupAttack;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityBrachiosaurus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityGallimimus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityHypsilophodon;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityLeaellynasaura;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityOviraptor;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityStegosaurus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityTriceratops;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityCarnotaurus
extends EntityJurassiCraftGroupAggressive {
    public IntermittentAnimation restingHeadProgress = new IntermittentAnimation(30, 200, 100, 100);
    public ControlledAnimation sittingProgress = new ControlledAnimation(40);
    public ChainBuffer tailBuffer = new ChainBuffer(5);

    public EntityCarnotaurus(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new JurassiCraftAIWander(this, 40, 0.8 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0 * this.getCreatureSpeed(), false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new JurassiCraftAISitNatural(this, 800, 125, 400));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIEating(this, 20, true, JurassiCraftAnimationIDs.BITE.animID()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new JurassiCraftAIFollowFood(this, 100, 1.2 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new JurassiCraftAIEatDroppedFood(this, 16.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new HerdAIFollowHerd(this, true, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new HerdAIGroupAttack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new JurassiCraftAIOwnerIsHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new JurassiCraftAIOwnerHurtsTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityBrachiosaurus.class, 120, 0.7f, 0.4f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityStegosaurus.class, 80, 0.6f, 0.7f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityTriceratops.class, 70, 0.6f, 0.7f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityGallimimus.class, 0, 0.6f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityHypsilophodon.class, 40, 0.55f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityLeaellynasaura.class, 40, 0.55f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityOviraptor.class, 0, 0.5f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityChicken.class, 0, 0.9f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityCow.class, 0, 0.9f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityPig.class, 0, 0.9f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntitySheep.class, 0, 0.9f));
        this.setCreatureExperiencePoints(4000);
    }

    public double func_70042_X() {
        return 0.95 * (double)(this.getYBouningBox() + 0.175f * (this.field_70721_aZ - this.field_70721_aZ * MathHelper.func_76126_a((float)(0.55f * this.field_70754_ba))));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.isSitting()) {
                this.sittingProgress.increaseTimer();
                this.restingHeadProgress.runAnimation();
            } else {
                this.sittingProgress.decreaseTimer();
                this.restingHeadProgress.stopAnimation();
            }
        }
        this.tailBuffer.calculateChainSwingBuffer(65.0f, 5, 4.0f, (EntityLivingBase)this);
    }

    @Override
    protected void func_70628_a(boolean recentlyBeenHit, int enchantBonus) {
        float developmentFraction = (float)this.getGrowthStage() / 120.0f;
        int countMeat = Math.round(1.0f + 3.5f * developmentFraction + (float)this.field_70146_Z.nextInt(1 + (int)(3.5f * developmentFraction)) + (float)this.field_70146_Z.nextInt(1 + enchantBonus));
        if (!this.func_70027_ad()) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getMeat(), countMeat));
        } else {
            this.func_145779_a((Item)this.getCreature().getSteak(), countMeat);
        }
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getSkull()));
        }
    }
}

