/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.dinosaurs;

import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftAnimationIDs;
import net.ilexiconn.jurassicraft.common.entity.ChainBuffer;
import net.ilexiconn.jurassicraft.common.entity.ControlledAnimation;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftGroupAggressive;
import net.ilexiconn.jurassicraft.common.entity.EntitySpit;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEatDroppedFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEating;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIFollowFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerHurtsTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerIsHurtByTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAISit;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAITargetIfHasAgeAndNonTamed;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIWander;
import net.ilexiconn.jurassicraft.common.entity.ai.animation.AnimationAISpit;
import net.ilexiconn.jurassicraft.common.entity.ai.herds.HerdAIFollowHerd;
import net.ilexiconn.jurassicraft.common.entity.ai.herds.HerdAIGroupAttack;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityBrachiosaurus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityGallimimus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityHypsilophodon;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityLeaellynasaura;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityOviraptor;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityStegosaurus;
import net.ilexiconn.jurassicraft.common.entity.dinosaurs.EntityTriceratops;
import net.ilexiconn.jurassicraft.common.entity.mammals.EntityLeptictidium;
import net.ilexiconn.jurassicraft.common.entity.mammals.EntityMoeritherium;
import net.ilexiconn.jurassicraft.common.handler.AnimationHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityDilophosaurus
extends EntityJurassiCraftGroupAggressive
implements IRangedAttackMob {
    public ChainBuffer tailBuffer = new ChainBuffer(5);
    public ControlledAnimation sittingProgress = new ControlledAnimation(35);
    int timeUntilSpit = 0;
    float spitLocationRadius = 2.2f;

    public EntityDilophosaurus(World world) {
        super(world);
        this.func_70661_as().func_75491_a(true);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AnimationAISpit(this, 20, 10));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0 * this.getCreatureSpeed(), false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new JurassiCraftAIWander(this, 40, 0.8 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new JurassiCraftAISit(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIFollowFood(this, 100, 1.2 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIEatDroppedFood(this, 16.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIEating(this, 20));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new HerdAIFollowHerd(this, true, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new HerdAIGroupAttack(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new JurassiCraftAIOwnerIsHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new JurassiCraftAIOwnerHurtsTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityBrachiosaurus.class, 120, 0.7f, 0.1f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityStegosaurus.class, 80, 0.6f, 0.2f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityTriceratops.class, 70, 0.6f, 0.2f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityGallimimus.class, 60, 0.6f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityOviraptor.class, 50, 0.5f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityHypsilophodon.class, 50, 0.5f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityMoeritherium.class, 50, 0.5f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityLeptictidium.class, 50, 0.4f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityLeaellynasaura.class, 50, 0.4f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityHorse.class, 50, 0.6f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityCow.class, 50, 0.6f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityPig.class, 30, 0.6f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntitySheep.class, 30, 0.6f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityChicken.class, 10, 0.2f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityPlayer.class, 50, 0.5f));
        this.setCreatureExperiencePoints(1800);
    }

    public void func_82196_d(EntityLivingBase entity, float p_82196_2_) {
        if (this.timeUntilSpit != 0 || this.func_70638_az() == null) {
            return;
        }
        EntitySpit spit = new EntitySpit(this.field_70170_p, (EntityLivingBase)this);
        spit.func_70107_b(this.field_70165_t + (double)(this.spitLocationRadius * this.getCreatureScale()) * Math.cos((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0), this.field_70163_u + (double)(1.0f * this.getCreatureScale()), this.field_70161_v + (double)(this.spitLocationRadius * this.getCreatureScale()) * Math.sin((double)(this.field_70761_aq + 90.0f) * Math.PI / 180.0));
        double d0 = entity.field_70165_t - spit.field_70165_t;
        double d1 = entity.field_70163_u + (double)entity.func_70047_e() - (double)1.1f - spit.field_70163_u;
        double d2 = entity.field_70161_v - spit.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        spit.func_70186_c(d0, d1 + (double)f1, d2, 1.5f, 0.0f);
        this.func_85030_a("random.bow", 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)spit);
        this.timeUntilSpit = 20;
    }

    @Override
    public int func_70627_aG() {
        return 350;
    }

    @Override
    protected void func_70628_a(boolean recentlyBeenHit, int enchantBonus) {
        float developmentFraction = (float)this.getGrowthStage() / 120.0f;
        int count = Math.round(1.0f + 2.5f * developmentFraction + (float)this.field_70146_Z.nextInt(1 + (int)(2.5f * developmentFraction)) + (float)this.field_70146_Z.nextInt(1 + enchantBonus));
        if (!this.func_70027_ad()) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getMeat(), count));
        } else {
            this.func_145779_a((Item)this.getCreature().getSteak(), count);
        }
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getSkull()));
        }
        if (this.isMale() && this.field_70146_Z.nextFloat() < 0.25f) {
            this.dropItemStackWithGenetics(new ItemStack((Item)this.getCreature().getSkin()));
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.isSitting()) {
                this.sittingProgress.increaseTimer();
            } else {
                this.sittingProgress.decreaseTimer();
            }
        }
        this.tailBuffer.calculateChainSwingBuffer(40.0f, 3, 4.0f, (EntityLivingBase)this);
        if (this.func_70638_az() != null && this.timeUntilSpit == 0 && this.func_70032_d((Entity)this.func_70638_az()) <= 15.0f && this.func_70032_d((Entity)this.func_70638_az()) >= 4.0f && (this.func_70638_az().func_70660_b(Potion.field_76440_q) == null || this.func_70638_az().func_70660_b(Potion.field_76436_u) == null)) {
            AnimationHandler.sendAnimationPacket(this, JurassiCraftAnimationIDs.SPITTING.animID());
        }
        if (this.timeUntilSpit > 0) {
            --this.timeUntilSpit;
        }
    }
}

