/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.entity.reptiles;

import net.ilexiconn.jurassicraft.common.entity.ChainBuffer;
import net.ilexiconn.jurassicraft.common.entity.Creature;
import net.ilexiconn.jurassicraft.common.entity.EntityJurassiCraftSwimmingBase;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEatDroppedFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIEating;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIFollowFood;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerHurtsTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAIOwnerIsHurtByTarget;
import net.ilexiconn.jurassicraft.common.entity.ai.JurassiCraftAITargetIfHasAgeAndNonTamed;
import net.ilexiconn.jurassicraft.common.item.ItemMeat;
import net.ilexiconn.jurassicraft.common.item.ItemSkin;
import net.ilexiconn.jurassicraft.common.item.ItemSkull;
import net.ilexiconn.jurassicraft.common.item.ItemSteak;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EntityTylosaurus
extends EntityJurassiCraftSwimmingBase {
    public ChainBuffer tailBuffer = new ChainBuffer(12);

    public EntityTylosaurus(World world) {
        super(world);
        this.swimSpeed = 2.2f;
        this.huntingInterval = 600;
        this.setHungry(this.huntingInterval);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackOnCollide((EntityCreature)this, 1.0 * this.getCreatureSpeed(), false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIFollowFood(this, 100, 1.2 * this.getCreatureSpeed()));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIEatDroppedFood(this, 16.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new JurassiCraftAIEating(this, 20));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new JurassiCraftAIOwnerIsHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new JurassiCraftAIOwnerHurtsTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntitySquid.class, 100, 0.15f, 1.0f));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new JurassiCraftAITargetIfHasAgeAndNonTamed(this, EntityPlayer.class, 100, 0.25f, 1.0f));
        this.setCreatureExperiencePoints(5000);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.tailBuffer.calculateChainSwingBuffer(120.0f, 5, 8.0f, (EntityLivingBase)this);
    }

    @Override
    public EntityLivingBase getTargetPriority(EntityLivingBase target, EntityLivingBase entity) {
        if (target != null) {
            if (target instanceof EntityPlayer) {
                return target;
            }
            if (target instanceof EntityTylosaurus) {
                return entity;
            }
            return target;
        }
        return entity;
    }

    @Override
    protected void func_70628_a(boolean recentlyBeenHit, int enchantBonus) {
        float developmentFraction = (float)this.getGrowthStage() / 120.0f;
        int count = Math.round(1.0f + 5.0f * developmentFraction + (float)this.field_70146_Z.nextInt(1 + (int)(5.5f * developmentFraction)) + (float)this.field_70146_Z.nextInt(1 + enchantBonus));
        Creature creature = this.getCreature();
        if (!this.func_70027_ad()) {
            ItemMeat meat = creature.getMeat();
            if (meat != null) {
                this.dropItemStackWithGenetics(new ItemStack((Item)meat, count));
            } else {
                System.err.println("Meat was null for Tylosaurus!");
            }
        } else {
            ItemSteak steak = creature.getSteak();
            if (steak != null) {
                this.func_145779_a((Item)steak, count);
            } else {
                System.err.println("Steak was null for Tylosaurus!");
            }
        }
        if (this.field_70146_Z.nextFloat() < 0.1f) {
            ItemSkull skull = creature.getSkull();
            if (skull != null) {
                this.dropItemStackWithGenetics(new ItemStack((Item)skull));
            } else {
                System.err.println("Skull was null for Tylosaurus!");
            }
        }
        if (this.isMale() && this.field_70146_Z.nextFloat() < 0.25f) {
            ItemSkin skin = creature.getSkin();
            if (skin != null) {
                this.dropItemStackWithGenetics(new ItemStack((Item)skin));
            } else {
                System.err.println("Skin was null for Tylosaurus!");
            }
        }
    }
}

