/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.handler;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import net.ilexiconn.jurassicraft.common.data.CreatureContainer;
import net.ilexiconn.jurassicraft.common.handler.CreatureHandler;

public class JsonEntityHandler {
    public Collection<CreatureContainer> dinos;
    public Collection<CreatureContainer> mammals;
    public Collection<CreatureContainer> cephalopods;
    public Collection<CreatureContainer> arthropods;
    public Collection<CreatureContainer> fish;
    public Collection<CreatureContainer> reptiles;
    public Collection<CreatureContainer> birds;

    public void parseServerEntities() {
        this.loadJsons();
        for (CreatureContainer dino : this.dinos) {
            CreatureHandler.addCreature(dino, "dinosaurs");
        }
        for (CreatureContainer creature : this.reptiles) {
            CreatureHandler.addCreature(creature, "reptiles");
        }
        for (CreatureContainer creature : this.mammals) {
            CreatureHandler.addCreature(creature, "mammals");
        }
        for (CreatureContainer creature : this.birds) {
            CreatureHandler.addCreature(creature, "birds");
        }
        for (CreatureContainer creature : this.fish) {
            CreatureHandler.addCreature(creature, "fish");
        }
        for (CreatureContainer creature : this.cephalopods) {
            CreatureHandler.addCreature(creature, "cephalopods");
        }
        for (CreatureContainer creature : this.arthropods) {
            CreatureHandler.addCreature(creature, "arthropods");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void parseClientEntities() throws Exception {
        this.loadJsons();
        for (CreatureContainer creature : this.dinos) {
            CreatureHandler.addCreatureRenderer(creature, "dinosaurs");
        }
        for (CreatureContainer creature : this.reptiles) {
            CreatureHandler.addCreatureRenderer(creature, "reptiles");
        }
        for (CreatureContainer creature : this.mammals) {
            CreatureHandler.addCreatureRenderer(creature, "mammals");
        }
        for (CreatureContainer creature : this.birds) {
            CreatureHandler.addCreatureRenderer(creature, "birds");
        }
        for (CreatureContainer creature : this.fish) {
            CreatureHandler.addCreatureRenderer(creature, "fish");
        }
        for (CreatureContainer creature : this.cephalopods) {
            CreatureHandler.addCreatureRenderer(creature, "cephalopods");
        }
        for (CreatureContainer creature : this.arthropods) {
            CreatureHandler.addCreatureRenderer(creature, "arthropods");
        }
    }

    public void loadJsons() {
        this.dinos = (Collection)new Gson().fromJson((Reader)new InputStreamReader(JsonEntityHandler.class.getResourceAsStream("/assets/jurassicraft/json/dinos.json")), new TypeToken<Collection<CreatureContainer>>(){}.getType());
        this.reptiles = (Collection)new Gson().fromJson((Reader)new InputStreamReader(JsonEntityHandler.class.getResourceAsStream("/assets/jurassicraft/json/reptiles.json")), new TypeToken<Collection<CreatureContainer>>(){}.getType());
        this.mammals = (Collection)new Gson().fromJson((Reader)new InputStreamReader(JsonEntityHandler.class.getResourceAsStream("/assets/jurassicraft/json/mammals.json")), new TypeToken<Collection<CreatureContainer>>(){}.getType());
        this.birds = (Collection)new Gson().fromJson((Reader)new InputStreamReader(JsonEntityHandler.class.getResourceAsStream("/assets/jurassicraft/json/birds.json")), new TypeToken<Collection<CreatureContainer>>(){}.getType());
        this.fish = (Collection)new Gson().fromJson((Reader)new InputStreamReader(JsonEntityHandler.class.getResourceAsStream("/assets/jurassicraft/json/fish.json")), new TypeToken<Collection<CreatureContainer>>(){}.getType());
        this.cephalopods = (Collection)new Gson().fromJson((Reader)new InputStreamReader(JsonEntityHandler.class.getResourceAsStream("/assets/jurassicraft/json/cephalopods.json")), new TypeToken<Collection<CreatureContainer>>(){}.getType());
        this.arthropods = (Collection)new Gson().fromJson((Reader)new InputStreamReader(JsonEntityHandler.class.getResourceAsStream("/assets/jurassicraft/json/arthropods.json")), new TypeToken<Collection<CreatureContainer>>(){}.getType());
    }
}

