/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.item;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.ilexiconn.jurassicraft.JurassiCraft;
import net.ilexiconn.jurassicraft.common.creativetab.JCCreativeTabRegistry;
import net.ilexiconn.jurassicraft.common.entity.mammals.EntityPregnantCow;
import net.ilexiconn.jurassicraft.common.entity.mammals.EntityPregnantHorse;
import net.ilexiconn.jurassicraft.common.entity.mammals.EntityPregnantPig;
import net.ilexiconn.jurassicraft.common.entity.mammals.EntityPregnantSheep;
import net.ilexiconn.jurassicraft.common.handler.CreatureHandler;
import net.ilexiconn.jurassicraft.common.handler.JurassiCraftDNAHandler;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemMammalSyringe
extends Item {
    public static final HashSet<String> creaturesFromCow = new HashSet<String>(Arrays.asList("mammoth", "arsinoitherium", "basilosaurus", "uintatherium", "paraceratherium", "deinotherium", "leptictidium"));
    public static final HashSet<String> creaturesFromPig = new HashSet<String>(Arrays.asList("mammoth", "arsinoitherium", "basilosaurus", "uintatherium", "paraceratherium", "deinotherium", "leptictidium"));
    public static final HashSet<String> creaturesFromHorse = new HashSet<String>(Arrays.asList("mammoth", "arsinoitherium", "basilosaurus", "uintatherium", "paraceratherium", "deinotherium", "leptictidium"));
    public static final HashSet<String> creaturesFromSheep = new HashSet<String>(Arrays.asList("mammoth", "arsinoitherium", "basilosaurus", "uintatherium", "paraceratherium", "deinotherium", "leptictidium"));
    public String mammalName;

    public ItemMammalSyringe(String mammal) {
        this.func_77655_b(mammal + "_Syringe");
        String cat = CreatureHandler.getCategoryFromCreatureName(mammal);
        this.func_111206_d(JurassiCraft.getModId() + "creatures/" + cat + "/" + mammal.toLowerCase() + "/" + mammal.toLowerCase() + "_Syringe");
        this.func_77637_a(JCCreativeTabRegistry.syringesEggs);
        this.mammalName = mammal;
    }

    public String func_77653_i(ItemStack itemStack) {
        return StatCollector.func_74838_a((String)("entity." + this.mammalName + ".name")) + " " + StatCollector.func_74838_a((String)"item.dino_syringe.name");
    }

    public String getSyringeDNASequence(ItemStack syringe) {
        if (syringe.func_77942_o() && syringe.func_77978_p().func_74764_b("DNA")) {
            return syringe.func_77978_p().func_74779_i("DNA");
        }
        return JurassiCraftDNAHandler.createDefaultDNA();
    }

    public int getSyringeQuality(ItemStack syringe) {
        if (syringe.func_77942_o() && syringe.func_77978_p().func_74764_b("Quality")) {
            return syringe.func_77978_p().func_74762_e("Quality");
        }
        return 75;
    }

    public void func_77624_a(ItemStack syringe, EntityPlayer player, List list, boolean flag) {
        if (!syringe.func_77942_o()) {
            syringe.field_77990_d = new NBTTagCompound();
        }
        if (!syringe.func_77978_p().func_74764_b("DNA")) {
            syringe.func_77978_p().func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
        }
        if (!syringe.func_77978_p().func_74764_b("Quality")) {
            syringe.func_77978_p().func_74768_a("Quality", player.field_71075_bZ.field_75098_d ? 100 : 0);
        }
        list.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"item.dna.info.dna") + ": " + syringe.func_77978_p().func_74779_i("DNA"));
        list.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"item.dna.info.quality") + ": " + syringe.func_77978_p().func_74762_e("Quality") + "%");
    }

    public ItemStack func_77659_a(ItemStack syringe, World world, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && player.func_70093_af()) {
            NBTTagCompound compound = syringe.func_77978_p();
            if (compound == null) {
                compound = new NBTTagCompound();
            }
            int quality = 0;
            if (compound.func_74764_b("Quality")) {
                quality = compound.func_74762_e("Quality");
            }
            if ((quality += 25) > 100) {
                quality = 0;
            }
            compound.func_74768_a("Quality", quality);
            compound.func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
            syringe.func_77982_d(compound);
            if (world.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.dna.info.qualityChanged") + " " + compound.func_74762_e("Quality") + "%"));
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.dna.info.geneticCodeIs") + ": " + compound.func_74779_i("DNA")));
            }
        }
        return syringe;
    }

    public boolean func_111207_a(ItemStack syringe, EntityPlayer player, EntityLivingBase creature) {
        if (!syringe.func_77942_o() && player.field_71075_bZ.field_75098_d) {
            syringe.field_77990_d = new NBTTagCompound();
        }
        if (!syringe.func_77978_p().func_74764_b("DNA") && player.field_71075_bZ.field_75098_d) {
            syringe.func_77978_p().func_74778_a("DNA", JurassiCraftDNAHandler.createDefaultDNA());
        }
        if (!syringe.func_77978_p().func_74764_b("Quality") && player.field_71075_bZ.field_75098_d) {
            syringe.func_77978_p().func_74768_a("Quality", 0);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            if (creature instanceof EntityAnimal && ((EntityAnimal)creature).func_70874_b() >= 0) {
                if (!this.setBaby(player.field_70170_p, player, creature, syringe)) {
                    return false;
                }
                --syringe.field_77994_a;
                if (syringe.field_77994_a <= 0) {
                    syringe = null;
                }
                return true;
            }
        } else if (player.field_71075_bZ.field_75098_d && !player.func_70093_af() && creature instanceof EntityAnimal && ((EntityAnimal)creature).func_70874_b() >= 0) {
            if (!this.setBaby(player.field_70170_p, player, creature, syringe)) {
                return false;
            }
            --syringe.field_77994_a;
            if (syringe.field_77994_a <= 0) {
                syringe = null;
            }
            return true;
        }
        return false;
    }

    private boolean setBaby(World world, EntityPlayer player, EntityLivingBase creature, ItemStack syringe) {
        if (syringe.func_77942_o() && syringe.func_77978_p().func_74764_b("SyringeQuality") && syringe.func_77978_p().func_74762_e("SyringeQuality") >= 50) {
            if (creature instanceof EntityCow) {
                if (!creaturesFromCow.contains(this.mammalName.toLowerCase())) {
                    return false;
                }
                EntityPregnantCow cow = EntityPregnantCow.get((EntityCow)creature);
                if (cow != null && cow.getMammalName().equals("noEmbryo")) {
                    cow.setMammalName(this.mammalName);
                    cow.setDNAQuality(this.getSyringeQuality(syringe));
                    cow.setDNASequence(this.getSyringeDNASequence(syringe));
                    cow.setPregnancySpeed(2048);
                    if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.syringe.info.embryoInseminated")));
                    }
                    return true;
                }
            } else if (creature instanceof EntityPig) {
                if (!creaturesFromPig.contains(this.mammalName.toLowerCase())) {
                    return false;
                }
                EntityPregnantPig pig = EntityPregnantPig.get((EntityPig)creature);
                if (pig != null && pig.getMammalName().equals("noEmbryo")) {
                    pig.setMammalName(this.mammalName);
                    pig.setDNAQuality(this.getSyringeQuality(syringe));
                    pig.setDNASequence(this.getSyringeDNASequence(syringe));
                    pig.setPregnancySpeed(2048);
                    if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.syringe.info.embryoInseminated")));
                    }
                    return true;
                }
            } else if (creature instanceof EntityHorse) {
                if (!creaturesFromHorse.contains(this.mammalName.toLowerCase())) {
                    return false;
                }
                EntityPregnantHorse horse = EntityPregnantHorse.get((EntityHorse)creature);
                if (horse != null && horse.getMammalName().equals("noEmbryo")) {
                    horse.setMammalName(this.mammalName);
                    horse.setDNAQuality(this.getSyringeQuality(syringe));
                    horse.setDNASequence(this.getSyringeDNASequence(syringe));
                    horse.setPregnancySpeed(2048);
                    if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.syringe.info.embryoInseminated")));
                    }
                    return true;
                }
            } else if (creature instanceof EntitySheep) {
                if (!creaturesFromSheep.contains(this.mammalName.toLowerCase())) {
                    return false;
                }
                EntityPregnantSheep sheep = EntityPregnantSheep.get((EntitySheep)creature);
                if (sheep != null && sheep.getMammalName().equals("noEmbryo")) {
                    sheep.setMammalName(this.mammalName);
                    sheep.setDNAQuality(this.getSyringeQuality(syringe));
                    sheep.setDNASequence(this.getSyringeDNASequence(syringe));
                    sheep.setPregnancySpeed(2048);
                    if (!world.field_72995_K) {
                        player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.syringe.info.embryoInseminated")));
                    }
                    return true;
                }
            }
        } else if (!world.field_72995_K) {
            player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"item.dna.info.errorQuality")));
        }
        return false;
    }
}

