/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.jurassicraft.common.tileentity;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.ilexiconn.jurassicraft.common.data.enums.JurassiCraftFoodNutrients;
import net.ilexiconn.jurassicraft.common.entity.Creature;
import net.ilexiconn.jurassicraft.common.handler.CreatureHandler;
import net.ilexiconn.jurassicraft.common.item.ItemDNA;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;

public class TileCultivate
extends TileEntity
implements ISidedInventory {
    public final Map<Short, Byte> growthRateList = new HashMap<Short, Byte>();
    private final short maxValue = (short)3000;
    public int animationTick;
    public int rotation;
    private Random random;
    private ItemStack[] slots = new ItemStack[4];
    private short cultivateTime = 0;
    private int cultivateSpeed = 100;
    private byte waterStored = 0;
    private short proximateValue = 0;
    private short mineralValue = 0;
    private short vitaminValue = 0;
    private short lipidValue = 0;
    private float creatureSize = 0.0f;
    private boolean shouldUpdate;
    private Creature creature = null;

    public TileCultivate() {
        this.random = new Random();
    }

    public Creature getCreature() {
        return this.creature;
    }

    public int getCultivateTime() {
        return this.cultivateTime;
    }

    public void setCultivateTime(short time) {
        this.cultivateTime = time;
    }

    public int getMaximumValueOfNutrients() {
        return this.maxValue;
    }

    public float getCreatureSize() {
        return this.creatureSize;
    }

    public void setCreatureSize(float time, float speed) {
        this.creatureSize = speed > 0.0f ? time / speed : 0.0f;
    }

    public byte getWaterStored() {
        return this.waterStored;
    }

    public void setWaterStored(byte water) {
        this.waterStored = water;
    }

    public boolean hasWater() {
        return this.waterStored > 0;
    }

    public int getProximateValue() {
        return this.proximateValue;
    }

    public void setProximateValue(short proximate) {
        this.proximateValue = proximate;
    }

    public boolean hasProximate() {
        return this.proximateValue > 0;
    }

    public int getMineralValue() {
        return this.mineralValue;
    }

    public void setMineralValue(short mineral) {
        this.mineralValue = mineral;
    }

    public boolean hasMineral() {
        return this.mineralValue > 0;
    }

    public int getVitaminValue() {
        return this.vitaminValue;
    }

    public void setVitaminValue(short vitamin) {
        this.vitaminValue = vitamin;
    }

    public boolean hasVitamin() {
        return this.vitaminValue > 0;
    }

    public int getLipidValue() {
        return this.lipidValue;
    }

    public void setLipidValue(short lipids) {
        this.lipidValue = lipids;
    }

    public boolean hasLipid() {
        return this.lipidValue > 0;
    }

    public int getWaterStoredProgressScaled(int i) {
        return this.waterStored * i / 3;
    }

    public int setCultivateSpeed(int speed) {
        this.cultivateSpeed = speed;
        return this.cultivateSpeed;
    }

    public int getCultivateSpeed() {
        return this.cultivateSpeed;
    }

    public int getCultivateTimeProgressScaled(int i) {
        if (this.getCultivateSpeed() <= 0) {
            this.setCultivateSpeed(100);
        }
        return this.getCultivateTime() * i / this.getCultivateSpeed();
    }

    public int getProximateBarScaled(int i) {
        return this.getProximateValue() * i / this.getMaximumValueOfNutrients();
    }

    public int getMineralBarScaled(int i) {
        return this.getMineralValue() * i / this.getMaximumValueOfNutrients();
    }

    public int getVitaminBarScaled(int i) {
        return this.getVitaminValue() * i / this.getMaximumValueOfNutrients();
    }

    public int getLipidBarScaled(int i) {
        return this.getLipidValue() * i / this.getMaximumValueOfNutrients();
    }

    public boolean isHatching() {
        return this.cultivateTime > 0;
    }

    private boolean canCansumeWaterBucket() {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == Items.field_151131_as) {
            if (this.slots[1] == null) {
                return true;
            }
            if (this.slots[1].func_77973_b() == Items.field_151133_ar) {
                return true;
            }
        }
        return false;
    }

    private void consumeWaterBucket() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getWaterStored() + 1 > 3) {
                return;
            }
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            this.setWaterStored((byte)(this.getWaterStored() + 1));
            if (this.slots[1] == null) {
                ItemStack waterBucket;
                this.slots[1] = waterBucket = new ItemStack(Items.field_151133_ar);
            } else {
                ++this.slots[1].field_77994_a;
            }
        }
    }

    private boolean canCansumeFood() {
        if (this.slots[3] == null) {
            return false;
        }
        return (this.proximateValue < this.getMaximumValueOfNutrients() || this.mineralValue < this.getMaximumValueOfNutrients() || this.vitaminValue < this.getMaximumValueOfNutrients() || this.lipidValue < this.getMaximumValueOfNutrients()) && JurassiCraftFoodNutrients.FOODLIST.containsKey(this.slots[3].func_77973_b());
    }

    private void consumeFood() {
        if (!this.field_145850_b.field_72995_K) {
            int id = JurassiCraftFoodNutrients.FOODLIST.get(this.slots[3].func_77973_b());
            if (this.slots[3].func_77973_b() instanceof ItemBucketMilk) {
                this.slots[3] = null;
                this.slots[3] = new ItemStack(Items.field_151133_ar);
            } else {
                --this.slots[3].field_77994_a;
                if (this.slots[3].field_77994_a <= 0) {
                    this.slots[3] = null;
                }
            }
            if (this.proximateValue < this.getMaximumValueOfNutrients()) {
                this.proximateValue = (short)((double)this.proximateValue + (double)(800 + this.random.nextInt(201)) * JurassiCraftFoodNutrients.values()[id].getProximate());
                if (this.proximateValue > this.getMaximumValueOfNutrients()) {
                    this.proximateValue = (short)this.getMaximumValueOfNutrients();
                }
            }
            if (this.mineralValue < this.getMaximumValueOfNutrients()) {
                this.mineralValue = (short)((double)this.mineralValue + (double)(900 + this.random.nextInt(101)) * JurassiCraftFoodNutrients.values()[id].getMinerals());
                if (this.mineralValue > this.getMaximumValueOfNutrients()) {
                    this.mineralValue = (short)this.getMaximumValueOfNutrients();
                }
            }
            if (this.vitaminValue < this.getMaximumValueOfNutrients()) {
                this.vitaminValue = (short)((double)this.vitaminValue + (double)(900 + this.random.nextInt(101)) * JurassiCraftFoodNutrients.values()[id].getVitamins());
                if (this.vitaminValue > this.getMaximumValueOfNutrients()) {
                    this.vitaminValue = (short)this.getMaximumValueOfNutrients();
                }
            }
            if (this.lipidValue < this.getMaximumValueOfNutrients()) {
                this.lipidValue = (short)((double)this.lipidValue + (double)(980 + this.random.nextInt(101)) * JurassiCraftFoodNutrients.values()[id].getLipids());
                if (this.lipidValue > this.getMaximumValueOfNutrients()) {
                    this.lipidValue = (short)this.getMaximumValueOfNutrients();
                }
            }
        }
    }

    private boolean canCultivate() {
        ItemStack dnaSlot = this.getDNASlot();
        if (dnaSlot != null && dnaSlot.func_77942_o() && dnaSlot.func_77978_p().func_74764_b("Quality") && dnaSlot.func_77978_p().func_74764_b("DNA") && dnaSlot.func_77978_p().func_74762_e("Quality") >= 50) {
            this.creature = CreatureHandler.getCreatureFromDNA((ItemDNA)dnaSlot.func_77973_b());
            return !((double)this.getProximateValue() < this.creature.getMinProximate() || (double)this.getMineralValue() < this.creature.getMinMinerals() || (double)this.getVitaminValue() < this.creature.getMinVitamins() || (double)this.getLipidValue() < this.creature.getMinLipids());
        }
        return false;
    }

    private void cultivateCreature() {
        if (!this.canCultivate()) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        ItemStack cultivateResult = new ItemStack(((ItemDNA)this.getDNASlot().func_77973_b()).getCorrespondingEggOrSyringe(), 1, 0);
        if (this.creature.getEgg() != null) {
            compound.func_74768_a("EggQuality", this.getDNASlot().func_77978_p().func_74762_e("Quality"));
        }
        compound.func_74778_a("EggDNA", this.getDNASlot().func_77978_p().func_74779_i("DNA"));
        if (this.creature.getMammalSyringe() != null) {
            compound.func_74768_a("SyringeQuality", this.getDNASlot().func_77978_p().func_74762_e("Quality"));
        }
        compound.func_74778_a("SyringeDNA", this.getDNASlot().func_77978_p().func_74779_i("DNA"));
        cultivateResult.func_77982_d(compound);
        this.slots[2] = null;
        this.slots[2] = cultivateResult;
        this.setCultivateTime((short)0);
        this.setWaterStored((byte)0);
        this.proximateValue = (short)((double)this.proximateValue - this.creature.getMinProximate());
        this.mineralValue = (short)((double)this.mineralValue - this.creature.getMinMinerals());
        this.vitaminValue = (short)((double)this.vitaminValue - this.creature.getMinVitamins());
        this.lipidValue = (short)((double)this.lipidValue - this.creature.getMinLipids());
    }

    private ItemStack getDNASlot() {
        return this.slots[2];
    }

    private void recalculateGrowthRate() {
        if (this.creature != null) {
            int speed = this.creature.getCultivateSpeed();
            for (byte i = 0; i <= 9; i = (byte)(i + 1)) {
                if (i > 0) {
                    this.growthRateList.put((short)(i * speed / 10), i);
                    continue;
                }
                this.growthRateList.put((short)2, (byte)0);
            }
        }
    }

    private void resetBaseValues() {
        this.cultivateTime = 0;
        this.cultivateSpeed = 100;
        this.creature = null;
        this.growthRateList.clear();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean hasItems() {
        return this.slots[0] != null || this.slots[1] != null || this.getDNASlot() != null || this.slots[3] != null;
    }

    private boolean hasEmptyDNASlot() {
        return this.getDNASlot() == null;
    }

    public void func_145845_h() {
        ++this.animationTick;
        if (this.animationTick == Integer.MAX_VALUE) {
            this.animationTick = 0;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isHatching()) {
                if (this.canCansumeWaterBucket()) {
                    this.consumeWaterBucket();
                }
                if (this.canCansumeFood()) {
                    this.consumeFood();
                }
                if (this.getWaterStored() >= 3 && this.getProximateValue() > 0 && this.getMineralValue() > 0 && this.getVitaminValue() > 0 && this.getLipidValue() > 0 && this.canCultivate()) {
                    this.cultivateSpeed = this.creature.getCultivateSpeed();
                    this.recalculateGrowthRate();
                    this.setCultivateTime((short)1);
                    this.creatureSize = 0.0f;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            } else {
                this.cultivateTime = (short)(this.cultivateTime + 1);
                if (this.growthRateList.containsKey(this.cultivateTime)) {
                    this.setCreatureSize(this.cultivateTime, this.cultivateSpeed);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                } else if (this.shouldUpdate) {
                    this.setCreatureSize(this.cultivateTime, this.cultivateSpeed);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.shouldUpdate = false;
                }
                if (this.cultivateTime >= this.cultivateSpeed) {
                    this.cultivateCreature();
                    this.resetBaseValues();
                } else if (this.hasEmptyDNASlot()) {
                    this.resetBaseValues();
                }
            }
        }
    }

    public void cancelHatching(float progress) {
        if (this.isHatching()) {
            this.setProximateValue((short)(this.getProximateValue() - (int)((double)progress * this.creature.getMinProximate())));
            this.setMineralValue((short)(this.getMineralValue() - (int)((double)progress * this.creature.getMinMinerals())));
            this.setVitaminValue((short)(this.getVitaminValue() - (int)((double)progress * this.creature.getMinVitamins())));
            this.setLipidValue((short)(this.getLipidValue() - (int)((double)progress * this.creature.getMinLipids())));
            if (progress >= 0.75f) {
                this.setWaterStored((byte)0);
            } else if (progress >= 0.5f) {
                this.setWaterStored((byte)1);
            } else {
                this.setWaterStored((byte)2);
            }
            this.cultivateTime = 0;
            this.cultivateSpeed = 100;
            this.creature = null;
            this.growthRateList.clear();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70298_a(int i, int stackSize) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= stackSize) {
                ItemStack splitedStack = this.slots[i];
                this.slots[i] = null;
                return splitedStack;
            }
            ItemStack splitedStack = this.slots[i].func_77979_a(stackSize);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return splitedStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "Hatchery";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return false;
    }

    public int[] func_94128_d(int i) {
        return new int[]{0};
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        byte creatureID = -1;
        if (this.creature != null) {
            creatureID = this.creature.getCreatureID();
        }
        nbt.func_74774_a("CreatureID", creatureID);
        nbt.func_74774_a("Water", this.waterStored);
        nbt.func_74777_a("Proximate", this.proximateValue);
        nbt.func_74777_a("Mineral", this.mineralValue);
        nbt.func_74777_a("Vitamin", this.vitaminValue);
        nbt.func_74777_a("Lipid", this.lipidValue);
        nbt.func_74777_a("cultivateTime", this.cultivateTime);
        nbt.func_74776_a("CreatureSize", this.creatureSize);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.slots[i].func_77955_b(compound);
            list.func_74742_a((NBTBase)compound);
        }
        nbt.func_74768_a("rotation", this.rotation);
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.shouldUpdate = true;
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int slotId = 0; slotId < list.func_74745_c(); ++slotId) {
            NBTTagCompound compound = list.func_150305_b(slotId);
            byte slot = compound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.slots.length) continue;
            this.slots[slot] = ItemStack.func_77949_a((NBTTagCompound)compound);
        }
        this.creature = CreatureHandler.getCreatureFromId(nbt.func_74771_c("CreatureID"));
        this.creatureSize = nbt.func_74765_d("CreatureSize");
        this.waterStored = nbt.func_74771_c("Water");
        this.cultivateTime = nbt.func_74765_d("cultivateTime");
        this.proximateValue = nbt.func_74765_d("Proximate");
        this.mineralValue = nbt.func_74765_d("Mineral");
        this.vitaminValue = nbt.func_74765_d("Vitamin");
        this.lipidValue = nbt.func_74765_d("Lipid");
        this.rotation = nbt.func_74762_e("rotation");
        if (this.creature != null) {
            this.setCultivateSpeed(this.creature.getCultivateSpeed());
            this.recalculateGrowthRate();
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_145841_b(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        this.func_145839_a(compound);
    }
}

