/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.tuples.Triplet;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ModuleElectricBuffer
extends LogisticsModule {
    private int currentTickCount = 0;
    private int ticksToAction = 80;
    private SinkReply _sinkReply;

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
    }

    @Override
    public final int getX() {
        return this._service.getX();
    }

    @Override
    public final int getY() {
        return this._service.getY();
    }

    @Override
    public final int getZ() {
        return this._service.getZ();
    }

    @Override
    public void registerPosition(LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ElectricBuffer, 0, true, false, 1, 0, new PipeLogisticsChassi.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier stack, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        if (bestPriority >= SinkReply.FixedPriority.ElectricBuffer.ordinal()) {
            return null;
        }
        if (SimpleServiceLocator.IC2Proxy.isElectricItem(stack.makeNormalStack(1)) && this._service.canUseEnergy(1)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        if (++this.currentTickCount < this.ticksToAction) {
            return;
        }
        this.currentTickCount = 0;
        IInventoryUtil inv = this._service.getPointedInventory(true);
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.getSizeInventory(); ++i) {
            Triplet<Integer, SinkReply, List<IFilter>> reply;
            ItemStack stack = inv.getStackInSlot(i);
            if (stack == null || !SimpleServiceLocator.IC2Proxy.isElectricItem(stack) || (reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._service.getSourceID(), true, SinkReply.FixedPriority.ElectricManager)) == null) continue;
            this._service.spawnParticle(Particles.OrangeParticle, 2);
            this._service.sendStack(inv.decrStackSize(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
            return;
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return true;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTexture(IIconRegister register) {
        return register.func_94245_a("logisticspipes:itemModule/ModuleElectricBuffer");
    }
}

