/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.gui;

import java.io.IOException;
import logisticspipes.asm.ClientSideOnlyMethodContent;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import net.minecraft.entity.player.EntityPlayer;

public class GUIPacket
extends ModernPacket {
    private int guiID;
    private int windowID;
    private byte[] guiData;

    public GUIPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.guiID = data.readInt();
        this.windowID = data.readInt();
        this.guiData = new byte[data.readInt()];
        data.read(this.guiData);
    }

    @Override
    @ClientSideOnlyMethodContent
    public void processPacket(EntityPlayer player) {
        NewGuiHandler.openGui(this, player);
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        data.writeInt(this.guiID);
        data.writeInt(this.windowID);
        data.writeInt(this.guiData.length);
        data.write(this.guiData);
    }

    @Override
    public ModernPacket template() {
        return new GUIPacket(this.getId());
    }

    public int getGuiID() {
        return this.guiID;
    }

    public GUIPacket setGuiID(int guiID) {
        this.guiID = guiID;
        return this;
    }

    public int getWindowID() {
        return this.windowID;
    }

    public GUIPacket setWindowID(int windowID) {
        this.windowID = windowID;
        return this;
    }

    public byte[] getGuiData() {
        return this.guiData;
    }

    public GUIPacket setGuiData(byte[] guiData) {
        this.guiData = guiData;
        return this;
    }
}

