/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.HashMap;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequireReliableFluidTransport;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.FluidSupplierAmount;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.WorldUtil;
import logisticspipes.utils.item.ItemIdentifierInventory;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PipeFluidSupplierMk2
extends FluidRoutedPipe
implements IRequestFluid,
IRequireReliableFluidTransport {
    private boolean _lastRequestFailed = false;
    private ItemIdentifierInventory dummyInventory = new ItemIdentifierInventory(1, "Fluid to keep stocked", 127, true);
    private int amount = 0;
    private final Map<FluidIdentifier, Integer> _requestedItems = new HashMap<FluidIdentifier, Integer>();
    private boolean _requestPartials = false;
    private MinMode _bucketMinimum = MinMode.ONEBUCKET;

    public PipeFluidSupplierMk2(Item item) {
        super(item);
        this.throttleTime = 100;
    }

    @Override
    public void sendFailed(FluidIdentifier value1, Integer value2) {
        this.liquidLost(value1, value2);
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUIDSUPPLIER_MK2_TEXTURE;
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void throttledUpdateEntity() {
        if (!this.isEnabled()) {
            return;
        }
        if (MainProxy.isClient(this.container.getWorld())) {
            return;
        }
        super.throttledUpdateEntity();
        if (this.dummyInventory.func_70301_a(0) == null) {
            return;
        }
        WorldUtil worldUtil = new WorldUtil(this.getWorld(), this.getX(), this.getY(), this.getZ());
        block0: for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            FluidTank centerTank;
            void var11_15;
            FluidTankInfo[] result;
            IFluidHandler container;
            if (!(tile.tile instanceof IFluidHandler) || SimpleServiceLocator.pipeInformationManager.isItemPipe(tile.tile) || (container = (IFluidHandler)tile.tile).getTankInfo(ForgeDirection.UNKNOWN) == null || container.getTankInfo(ForgeDirection.UNKNOWN).length == 0) continue;
            HashMap<FluidIdentifier, Integer> wantFluids = new HashMap<FluidIdentifier, Integer>();
            FluidIdentifier fIdent = FluidIdentifier.get(this.dummyInventory.getIDStackInSlot(0).getItem());
            wantFluids.put(fIdent, this.amount);
            HashMap<FluidIdentifier, Integer> haveFluids = new HashMap<FluidIdentifier, Integer>();
            FluidTankInfo[] arr$ = result = container.getTankInfo(ForgeDirection.UNKNOWN);
            int len$ = arr$.length;
            boolean bl = false;
            while (var11_15 < len$) {
                FluidTankInfo slot = arr$[var11_15];
                if (slot != null && slot.fluid != null && slot.fluid.getFluidID() != 0 && wantFluids.containsKey(FluidIdentifier.get(slot.fluid))) {
                    Integer liquidWant = (Integer)haveFluids.get(FluidIdentifier.get(slot.fluid));
                    if (liquidWant == null) {
                        haveFluids.put(FluidIdentifier.get(slot.fluid), slot.fluid.amount);
                    } else {
                        haveFluids.put(FluidIdentifier.get(slot.fluid), liquidWant + slot.fluid.amount);
                    }
                }
                ++var11_15;
            }
            if (tile.orientation.ordinal() < ((PipeFluidTransportLogistics)this.transport).sideTanks.length && (centerTank = ((PipeFluidTransportLogistics)this.transport).sideTanks[tile.orientation.ordinal()]) != null && centerTank.getFluid() != null && wantFluids.containsKey(FluidIdentifier.get(centerTank.getFluid()))) {
                Integer liquidWant = (Integer)haveFluids.get(FluidIdentifier.get(centerTank.getFluid()));
                if (liquidWant == null) {
                    haveFluids.put(FluidIdentifier.get(centerTank.getFluid()), centerTank.getFluid().amount);
                } else {
                    haveFluids.put(FluidIdentifier.get(centerTank.getFluid()), liquidWant + centerTank.getFluid().amount);
                }
            }
            if ((centerTank = ((PipeFluidTransportLogistics)this.transport).internalTank) != null && centerTank.getFluid() != null && wantFluids.containsKey(FluidIdentifier.get(centerTank.getFluid()))) {
                Integer liquidWant = (Integer)haveFluids.get(FluidIdentifier.get(centerTank.getFluid()));
                if (liquidWant == null) {
                    haveFluids.put(FluidIdentifier.get(centerTank.getFluid()), centerTank.getFluid().amount);
                } else {
                    haveFluids.put(FluidIdentifier.get(centerTank.getFluid()), liquidWant + centerTank.getFluid().amount);
                }
            }
            for (Map.Entry entry : wantFluids.entrySet()) {
                Integer haveCount = (Integer)haveFluids.get(entry.getKey());
                if (haveCount != null) {
                    entry.setValue((Integer)entry.getValue() - haveCount);
                }
                for (Map.Entry<FluidIdentifier, Integer> requestedItem : this._requestedItems.entrySet()) {
                    if (!requestedItem.getKey().equals(entry.getKey())) continue;
                    entry.setValue((Integer)entry.getValue() - requestedItem.getValue());
                }
            }
            this.setRequestFailed(false);
            for (FluidIdentifier fluidIdentifier : wantFluids.keySet()) {
                int countToRequest = (Integer)wantFluids.get(fluidIdentifier);
                if (countToRequest < 1 || this._bucketMinimum.getAmount() != 0 && countToRequest < this._bucketMinimum.getAmount()) continue;
                if (!this.useEnergy(11)) continue block0;
                boolean success = false;
                if (this._requestPartials) {
                    if ((countToRequest = RequestTree.requestFluidPartial(fluidIdentifier, countToRequest, this, null)) > 0) {
                        success = true;
                    }
                } else {
                    success = RequestTree.requestFluid(fluidIdentifier, countToRequest, this, null);
                }
                if (success) {
                    Integer currentRequest = this._requestedItems.get(fluidIdentifier);
                    if (currentRequest == null) {
                        this._requestedItems.put(fluidIdentifier, countToRequest);
                        continue;
                    }
                    this._requestedItems.put(fluidIdentifier, currentRequest + countToRequest);
                    continue;
                }
                this.setRequestFailed(true);
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.dummyInventory.readFromNBT(nbttagcompound, "");
        this._requestPartials = nbttagcompound.func_74767_n("requestpartials");
        this.amount = nbttagcompound.func_74762_e("amount");
        this._bucketMinimum = MinMode.values()[nbttagcompound.func_74771_c("_bucketMinimum")];
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.dummyInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.func_74757_a("requestpartials", this._requestPartials);
        nbttagcompound.func_74768_a("amount", this.amount);
        nbttagcompound.func_74774_a("_bucketMinimum", (byte)this._bucketMinimum.ordinal());
    }

    private void decreaseRequested(FluidIdentifier liquid, int remaining) {
        Integer count = this._requestedItems.get(liquid);
        if (count != null) {
            this._requestedItems.put(liquid, Math.max(0, count - remaining));
            remaining -= count.intValue();
        }
        if (remaining <= 0) {
            return;
        }
        for (Map.Entry<FluidIdentifier, Integer> e : this._requestedItems.entrySet()) {
            if (e.getKey().equals(liquid)) {
                int expected = e.getValue();
                e.setValue(Math.max(0, expected - remaining));
                remaining -= expected;
            }
            if (remaining > 0) continue;
            return;
        }
        this.debug.log("liquid supplier got unexpected item " + liquid.toString());
    }

    @Override
    public void liquidLost(FluidIdentifier item, int amount) {
        this.decreaseRequested(item, amount);
    }

    @Override
    public void liquidArrived(FluidIdentifier item, int amount) {
        this.decreaseRequested(item, amount);
        this.delayThrottle();
    }

    @Override
    public void liquidNotInserted(FluidIdentifier item, int amount) {
    }

    public boolean isRequestingPartials() {
        return this._requestPartials;
    }

    public void setRequestingPartials(boolean value) {
        this._requestPartials = value;
    }

    public MinMode getMinMode() {
        return this._bucketMinimum;
    }

    public void setMinMode(MinMode value) {
        this._bucketMinimum = value;
    }

    @Override
    public void onWrenchClicked(EntityPlayer entityplayer) {
        entityplayer.openGui((Object)LogisticsPipes.instance, 18, this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    public IInventory getDummyInventory() {
        return this.dummyInventory;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        if (MainProxy.isClient(this.container.getWorld())) {
            this.amount = amount;
        }
    }

    public void changeFluidAmount(int change, EntityPlayer player) {
        this.amount += change;
        if (this.amount <= 0) {
            this.amount = 0;
        }
        MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidSupplierAmount.class).setInteger(this.amount).setPosX(this.getX()).setPosY(this.getY()).setPosZ(this.getZ()), player);
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }

    public static enum MinMode {
        NONE(0),
        ONEBUCKET(1000),
        TWOBUCKET(2000),
        FIVEBUCKET(5000);

        private final int amount;

        private MinMode(int amount) {
            this.amount = amount;
        }

        public int getAmount() {
            return this.amount;
        }
    }
}

