/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.upgrades;

import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.upgrades.AdvancedSatelliteUpgrade;
import logisticspipes.pipes.upgrades.CraftingByproductUpgrade;
import logisticspipes.pipes.upgrades.CraftingCleanupUpgrade;
import logisticspipes.pipes.upgrades.FluidCraftingUpgrade;
import logisticspipes.pipes.upgrades.FuzzyUpgrade;
import logisticspipes.pipes.upgrades.IPipeUpgrade;
import logisticspipes.pipes.upgrades.PatternUpgrade;
import logisticspipes.pipes.upgrades.SneakyUpgrade;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.item.SimpleStackInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class ModuleUpgradeManager
implements ISimpleInventoryEventHandler,
ISlotUpgradeManager {
    private SimpleStackInventory inv = new SimpleStackInventory(2, "UpgradeInventory", 16);
    private IPipeUpgrade[] upgrades = new IPipeUpgrade[2];
    private PipeLogisticsChassi pipe;
    private final UpgradeManager parent;
    private ForgeDirection sneakyOrientation = ForgeDirection.UNKNOWN;
    private boolean isAdvancedCrafter = false;
    private boolean isFuzzyUpgrade = false;
    private int liquidCrafter = 0;
    private boolean hasByproductExtractor = false;
    private boolean hasPatternUpgrade = false;
    private int craftingCleanup = 0;

    public ModuleUpgradeManager(PipeLogisticsChassi pipe, UpgradeManager parent) {
        this.pipe = pipe;
        this.parent = parent;
        this.inv.addListener(this);
    }

    @Override
    public boolean hasPatternUpgrade() {
        return this.hasPatternUpgrade ? true : this.parent.hasPatternUpgrade();
    }

    @Override
    public boolean isAdvancedSatelliteCrafter() {
        return this.isAdvancedCrafter ? true : this.parent.isAdvancedSatelliteCrafter();
    }

    @Override
    public boolean hasByproductExtractor() {
        return this.hasByproductExtractor ? true : this.parent.hasByproductExtractor();
    }

    @Override
    public int getFluidCrafter() {
        return Math.min(this.liquidCrafter + this.parent.getFluidCrafter(), 3);
    }

    @Override
    public boolean isFuzzyUpgrade() {
        return this.isFuzzyUpgrade ? true : this.parent.isFuzzyUpgrade();
    }

    @Override
    public int getCrafterCleanup() {
        return Math.min(this.craftingCleanup + this.parent.getCrafterCleanup(), 4);
    }

    @Override
    public boolean hasSneakyUpgrade() {
        if (this.sneakyOrientation != ForgeDirection.UNKNOWN) {
            return true;
        }
        return this.parent.hasSneakyUpgrade();
    }

    @Override
    public ForgeDirection getSneakyOrientation() {
        if (this.sneakyOrientation != ForgeDirection.UNKNOWN) {
            return this.sneakyOrientation;
        }
        return this.parent.getSneakyOrientation();
    }

    @Override
    public boolean hasOwnSneakyUpgrade() {
        return this.sneakyOrientation != ForgeDirection.UNKNOWN;
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        int i;
        boolean needUpdate = false;
        for (i = 0; i < this.inv.func_70302_i_(); ++i) {
            ItemStack item = this.inv.func_70301_a(i);
            if (item != null) {
                needUpdate |= this.updateModule(i, this.upgrades, this.inv);
                continue;
            }
            if (item != null || this.upgrades[i] == null) continue;
            needUpdate |= this.removeUpgrade(i, this.upgrades);
        }
        this.sneakyOrientation = ForgeDirection.UNKNOWN;
        this.isAdvancedCrafter = false;
        this.isFuzzyUpgrade = false;
        this.liquidCrafter = 0;
        this.hasByproductExtractor = false;
        this.hasPatternUpgrade = false;
        this.craftingCleanup = 0;
        for (i = 0; i < this.upgrades.length; ++i) {
            IPipeUpgrade upgrade = this.upgrades[i];
            if (upgrade instanceof SneakyUpgrade && this.sneakyOrientation == ForgeDirection.UNKNOWN) {
                this.sneakyOrientation = ((SneakyUpgrade)upgrade).getSneakyOrientation();
                continue;
            }
            if (upgrade instanceof AdvancedSatelliteUpgrade) {
                this.isAdvancedCrafter = true;
                continue;
            }
            if (upgrade instanceof FuzzyUpgrade) {
                this.isFuzzyUpgrade = true;
                continue;
            }
            if (upgrade instanceof FluidCraftingUpgrade) {
                this.liquidCrafter += this.inv.func_70301_a((int)i).field_77994_a;
                continue;
            }
            if (upgrade instanceof CraftingByproductUpgrade) {
                this.hasByproductExtractor = true;
                continue;
            }
            if (upgrade instanceof PatternUpgrade) {
                this.hasPatternUpgrade = true;
                continue;
            }
            if (!(upgrade instanceof CraftingCleanupUpgrade)) continue;
            this.craftingCleanup += this.inv.func_70301_a((int)i).field_77994_a;
        }
        this.liquidCrafter = Math.min(this.liquidCrafter, 3);
        this.craftingCleanup = Math.min(this.craftingCleanup, 4);
        if (needUpdate) {
            this.pipe.connectionUpdate();
            if (this.pipe.container != null) {
                this.pipe.container.sendUpdateToClient();
            }
        }
    }

    public void readFromNBT(NBTTagCompound nbttagcompound, String prefix) {
        this.inv.readFromNBT(nbttagcompound, "ModuleUpgradeInventory_" + prefix);
        this.InventoryChanged(this.inv);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound, String prefix) {
        this.inv.writeToNBT(nbttagcompound, "ModuleUpgradeInventory_" + prefix);
        this.InventoryChanged(this.inv);
    }

    private boolean updateModule(int slot, IPipeUpgrade[] upgrades, IInventory inv) {
        upgrades[slot] = LogisticsPipes.UpgradeItem.getUpgradeForItem(inv.func_70301_a(slot), upgrades[slot]);
        if (upgrades[slot] == null) {
            inv.func_70299_a(slot, null);
            return false;
        }
        return upgrades[slot].needsUpdate();
    }

    private boolean removeUpgrade(int slot, IPipeUpgrade[] upgrades) {
        boolean needUpdate = upgrades[slot].needsUpdate();
        upgrades[slot] = null;
        return needUpdate;
    }

    public SimpleStackInventory getInv() {
        return this.inv;
    }
}

