/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.debug.ExitRouteDebug;
import net.minecraftforge.common.util.ForgeDirection;

public class ExitRoute
implements Comparable<ExitRoute> {
    public ForgeDirection exitOrientation;
    public ForgeDirection insertOrientation;
    public double distanceToDestination;
    public final double destinationDistanceToRoot;
    public final int blockDistance;
    public final EnumSet<PipeRoutingConnectionType> connectionDetails;
    public final IRouter destination;
    public IRouter root;
    public List<IFilter> filters = Collections.unmodifiableList(new ArrayList(0));
    public ExitRouteDebug debug = new ExitRouteDebug();

    public ExitRoute(IRouter source, IRouter destination, ForgeDirection exitOrientation, ForgeDirection insertOrientation, double metric, EnumSet<PipeRoutingConnectionType> connectionDetails, int blockDistance) {
        this.destination = destination;
        this.root = source;
        this.exitOrientation = exitOrientation;
        this.insertOrientation = insertOrientation;
        this.connectionDetails = connectionDetails;
        this.distanceToDestination = connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo) ? metric : 2.147483647E9;
        this.destinationDistanceToRoot = connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom) ? metric : 2.147483647E9;
        this.blockDistance = blockDistance;
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof ExitRoute)) {
            return false;
        }
        ExitRoute that = (ExitRoute)aThat;
        return this.exitOrientation.equals((Object)that.exitOrientation) && this.insertOrientation.equals((Object)that.insertOrientation) && this.connectionDetails.equals(that.connectionDetails) && this.distanceToDestination == that.distanceToDestination && this.destinationDistanceToRoot == that.destinationDistanceToRoot && this.destination == that.destination && this.filters.equals(that.filters);
    }

    public boolean isSameWay(ExitRoute that) {
        if (this.equals(that)) {
            return true;
        }
        return this.connectionDetails.equals(that.connectionDetails) && this.destination == that.destination && this.filters.equals(that.filters);
    }

    public String toString() {
        return "{" + this.exitOrientation.name() + "," + this.insertOrientation.name() + "," + this.distanceToDestination + "," + this.destinationDistanceToRoot + ", ConnectionDetails: " + this.connectionDetails + ", " + this.filters + "}";
    }

    public void removeFlags(EnumSet<PipeRoutingConnectionType> flags) {
        this.connectionDetails.removeAll(flags);
    }

    public boolean containsFlag(PipeRoutingConnectionType flag) {
        return this.connectionDetails.contains((Object)flag);
    }

    public boolean hasActivePipe() {
        return this.destination != null && this.destination.getCachedPipe() != null;
    }

    public EnumSet<PipeRoutingConnectionType> getFlags() {
        return EnumSet.copyOf(this.connectionDetails);
    }

    public Set<PipeRoutingConnectionType> getFlagsNoCopy() {
        return Collections.unmodifiableSet(this.connectionDetails);
    }

    @Override
    public int compareTo(ExitRoute o) {
        int c = (int)Math.floor(this.distanceToDestination - o.distanceToDestination);
        if (c == 0) {
            return this.destination.getSimpleID() - o.destination.getSimpleID();
        }
        return c;
    }

    public ExitRoute(IRouter source, IRouter destination, double distance, EnumSet<PipeRoutingConnectionType> enumSet, List<IFilter> filterA, List<IFilter> filterB, int blockDistance) {
        this(source, destination, ForgeDirection.UNKNOWN, ForgeDirection.UNKNOWN, distance, enumSet, blockDistance);
        ArrayList<IFilter> filter = new ArrayList<IFilter>(filterA.size() + filterB.size());
        filter.addAll(filterA);
        filter.addAll(filterB);
        this.filters = Collections.unmodifiableList(filter);
    }
}

