/*
 * Decompiled with CFR 0.152.
 */
package trailmix.common.potion;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import trailmix.client.entity.EntityTrailMixFX;
import trailmix.common.TrailMix;
import trailmix.common.core.EntityHelper;

public class PotionTrailMix
extends Potion {
    public Random rand = new Random();
    private static final ResourceLocation pots = new ResourceLocation("trailmix", "textures/potion/potion.png");
    public static final String nyanPiano = "12-114-10909-105080705-105-107-108-1080705070912140912070905070509-112-114091207090508090807050708-1050709120709070507-105-107-112-114-10909-105080705-105-107-108-1080705070912140912070905070509-112-114091207090508090807050708-1050709120709070507-105-107-105-1000205-10002050709051009101205-105-100020500100907050009100005-1000205-10002050507090500020005-10504050002051009101205-104-105-1000205-10002050709051009101205-105-100020500100907050009100005-1000205-10002050507090500020005-10504050002051009101205-107-1";
    public static final String nyanBassA = "10-122-112-124-109-121-114-114-107-119-112-124-105-117-105-117-110-122-107-119-109-121-114-114-107-119-112-124-105-117-105-117-110-122-112-124-109-121-114-114-107-119-112-124-105-117-105-117-110-122-107-119-109-121-114-114-107-119-112-124-105-117-105-117-110-114-117-122-109-112-117-121-107-110-114-117-105-109-112-117-110-114-117-122-109-112-117-121-107-110-114-117-105-109-112-117-110-114-117-122-109-112-117-121-107-110-114-117-105-109-112-117-110-114-117-122-109-112-117-121-107-110-114-117-105-109-112-117-1";

    public PotionTrailMix(int i, boolean bad, int j) {
        super(i, bad, j);
    }

    public void func_76394_a(EntityLivingBase living, int par2) {
        double speed = Math.sqrt(living.field_70159_w * living.field_70159_w + living.field_70179_y * living.field_70179_y);
        if (speed < (double)((float)TrailMix.config.getInt("potSpeed") / 100.0f) + 0.5) {
            if (living.field_70170_p.field_72995_K && TrailMix.proxy.tickHandlerClient.fireballCooldown > 0 && living == Minecraft.func_71410_x().field_71439_g) {
                if (TrailMix.proxy.tickHandlerClient.fireballCooldown >= 9 || TrailMix.proxy.tickHandlerClient.fireballCooldown <= 2) {
                    living.func_70659_e(0.06f);
                } else {
                    living.field_70159_w = 0.0;
                    living.field_70179_y = 0.0;
                }
            } else if (living.field_70122_E || living instanceof EntityHorse) {
                if (speed > 0.1 && !living.func_70093_af()) {
                    PotionEffect effect = living.func_70660_b(TrailMix.potionEffect);
                    int duration = effect.func_76459_b();
                    double speedMulti = 1.5;
                    if ((speedMulti += (double)duration / 300.0 * 0.5) > 1.65) {
                        speedMulti = 1.65;
                    }
                    living.field_70159_w *= speedMulti;
                    living.field_70179_y *= speedMulti;
                }
                if (living instanceof EntityHorse && speed > 0.6) {
                    int i = (int)Math.floor(living.field_70165_t - living.field_70159_w * 3.0);
                    int j = (int)Math.floor(living.field_70163_u - living.field_70181_x * 3.0);
                    int k = (int)Math.floor(living.field_70161_v - living.field_70179_y * 3.0);
                    if (TrailMix.config.getInt("horseFireTrail") == 1 && living.field_70170_p.func_147437_c(i, j, k)) {
                        living.field_70170_p.func_147449_b(i, j, k, (Block)Blocks.field_150480_ab);
                    }
                    if (TrailMix.config.getInt("horseClearZone") != 0 && (TrailMix.config.getInt("horseClearZone") == 1 || living.field_70170_p.func_82736_K().func_82766_b("mobGriefing"))) {
                        EntityHorse horse = new EntityHorse(living.field_70170_p);
                        horse.field_70145_X = true;
                        for (int clr = 1; clr <= 3; ++clr) {
                            horse.func_70012_b(living.field_70165_t, living.field_70163_u, living.field_70161_v, living.field_70177_z, living.field_70125_A);
                            horse.func_70091_d(living.field_70159_w * (double)(clr > 2 ? 2 : clr), living.field_70181_x * (double)(clr > 2 ? 2 : clr), living.field_70179_y * (double)(clr > 2 ? 2 : clr));
                            EntityHelper.destroyBlocksInAABB((Entity)living, (AxisAlignedBB)horse.field_70121_D.func_72314_b(Math.sqrt(living.field_70159_w * living.field_70159_w), -0.5, Math.sqrt(living.field_70179_y * living.field_70179_y)).func_72321_a(0.0, 1.5, 0.0));
                        }
                    }
                    if (living.field_70170_p.field_72995_K) {
                        for (int x = 0; x < 5; ++x) {
                            double d0 = this.rand.nextGaussian() * 0.02;
                            double d1 = this.rand.nextGaussian() * 0.02;
                            double d2 = this.rand.nextGaussian() * 0.02;
                            double d3 = 10.0;
                            this.spawnParticle(living.field_70165_t + (double)(this.rand.nextFloat() * living.field_70130_N * 2.0f) - (double)living.field_70130_N - d0 * d3, living.field_70163_u + (double)(this.rand.nextFloat() * living.field_70131_O) - d1 * d3, living.field_70161_v + (double)(this.rand.nextFloat() * living.field_70130_N * 2.0f) - (double)living.field_70130_N - d2 * d3, (EntityLiving)((EntityHorse)living));
                        }
                    }
                }
            }
        }
        if (living instanceof EntityPig && !living.func_70631_g_()) {
            if (living.field_70170_p.field_72995_K && living.func_70089_S()) {
                this.handleClient(living);
            } else {
                TrailMix.proxy.tickHandlerServer.addPig((EntityPig)living);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleClient(EntityLivingBase living) {
        double posX = living.field_70165_t;
        double posY = living.field_70163_u + (double)living.func_70047_e();
        double posZ = living.field_70161_v;
        double dist = 0.5;
        double var4 = living.field_70159_w;
        double var8 = living.field_70179_y;
        double var6 = living.field_70181_x;
        double var14 = MathHelper.func_76133_a((double)(var4 * var4 + var8 * var8));
        float var12 = (float)(Math.atan2(var8, var4) * 180.0 / Math.PI) - 90.0f;
        float var13 = (float)(-(Math.atan2(var6, var14) * 180.0 / Math.PI));
        posX += (double)MathHelper.func_76126_a((float)(living.field_70761_aq / 180.0f * (float)Math.PI)) * dist;
        posZ -= (double)MathHelper.func_76134_b((float)(living.field_70761_aq / 180.0f * (float)Math.PI)) * dist;
        posY -= 0.1;
        living.field_70125_A = -EntityHelper.updateRotation((float)living.field_70125_A, (float)var13, (float)15.0f);
        living.field_70761_aq = living == Minecraft.func_71410_x().field_71439_g.field_70154_o ? (living.field_70177_z = (float)TrailMix.proxy.tickHandlerClient.pigInfo[0]) : (living.field_70177_z = EntityHelper.updateRotation((float)living.field_70761_aq, (float)var12, (float)15.0f));
        living.field_70155_l = 5.0;
        if (living.field_70153_n != null && living.field_70153_n instanceof EntityLivingBase) {
            ((EntityLivingBase)living.field_70153_n).field_70761_aq = living.field_70761_aq;
        }
        if (!TrailMix.proxy.tickHandlerClient.nyanList.contains(living.func_145782_y())) {
            this.spawnParticle(posX, posY, posZ, (EntityLiving)((EntityPig)living));
            this.spawnParticle(posX, posY, posZ, (EntityLiving)((EntityPig)living));
        } else {
            double mag = Math.sqrt(living.field_70159_w * living.field_70159_w + living.field_70181_x * living.field_70181_x + living.field_70179_y * living.field_70179_y);
            for (int i = 0; i < 4; ++i) {
                double mX = (double)i * living.field_70159_w / 4.2;
                double mY = (double)i * living.field_70181_x / 4.2;
                double mZ = (double)i * living.field_70179_y / 4.2;
                this.spawnParticle(posX - mX, posY - (mY -= living.field_70153_n instanceof EntityZombie ? 0.4 : 0.0) + 0.2, posZ - mZ, (EntityLiving)((EntityPig)living), 0xFD0000);
                this.spawnParticle(posX - mX, posY - mY + 0.125, posZ - mZ, (EntityLiving)((EntityPig)living), 0xFD0000);
                this.spawnParticle(posX - mX, posY - mY + 0.05, posZ - mZ, (EntityLiving)((EntityPig)living), 16685056);
                this.spawnParticle(posX - mX, posY - mY - 0.025, posZ - mZ, (EntityLiving)((EntityPig)living), 16685056);
                this.spawnParticle(posX - mX, posY - mY - 0.1, posZ - mZ, (EntityLiving)((EntityPig)living), 0xFEFE00);
                this.spawnParticle(posX - mX, posY - mY - 0.175, posZ - mZ, (EntityLiving)((EntityPig)living), 0xFEFE00);
                this.spawnParticle(posX - mX, posY - mY - 0.25, posZ - mZ, (EntityLiving)((EntityPig)living), 3407104);
                this.spawnParticle(posX - mX, posY - mY - 0.325, posZ - mZ, (EntityLiving)((EntityPig)living), 3407104);
                this.spawnParticle(posX - mX, posY - mY - 0.4, posZ - mZ, (EntityLiving)((EntityPig)living), 39166);
                this.spawnParticle(posX - mX, posY - mY - 0.475, posZ - mZ, (EntityLiving)((EntityPig)living), 39166);
                this.spawnParticle(posX - mX, posY - mY - 0.55, posZ - mZ, (EntityLiving)((EntityPig)living), 6697981);
                this.spawnParticle(posX - mX, posY - mY - 0.625, posZ - mZ, (EntityLiving)((EntityPig)living), 6697981);
            }
            if (TrailMix.proxy.tickHandlerClient.soundPlayed <= 10 && this.getRenderViewEntity() != null && (double)living.func_70032_d((Entity)this.getRenderViewEntity()) <= 20.0) {
                int pos = (int)living.field_70170_p.func_72820_D() % 512;
                if (pos % 2 == 0) {
                    int note = Integer.parseInt(nyanPiano.substring(pos, pos + 2));
                    int note1 = Integer.parseInt(nyanBassA.substring(pos, pos + 2));
                    if (note >= 0) {
                        float var7 = (float)Math.pow(2.0, (double)(note - 12) / 12.0);
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation("note.harp"), 1.0f, var7, (float)living.field_70165_t, (float)(living.field_70163_u - (double)living.field_70129_M), (float)living.field_70161_v));
                    }
                    if (note1 >= 0) {
                        float var7 = (float)Math.pow(2.0, (double)(note1 - 12) / 12.0);
                        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation("note.bassattack"), 1.0f, var7, (float)living.field_70165_t, (float)(living.field_70163_u - (double)living.field_70129_M), (float)living.field_70161_v));
                    }
                }
                ++TrailMix.proxy.tickHandlerClient.soundPlayed;
            }
        }
    }

    public boolean func_76397_a(int par1, int par2) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(double posX, double posY, double posZ, EntityLiving pig) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityTrailMixFX((World)Minecraft.func_71410_x().field_71441_e, posX, posY, posZ, this.func_76401_j(), pig));
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(double posX, double posY, double posZ, EntityLiving pig, int clr) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)new EntityTrailMixFX((World)Minecraft.func_71410_x().field_71441_e, posX, posY, posZ, clr, pig, true));
    }

    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getRenderViewEntity() {
        return Minecraft.func_71410_x().field_71451_h;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76400_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(pots);
        return 0;
    }

    public int func_76401_j() {
        return PotionTrailMix.getRandEffectColour(this.rand);
    }

    public static int getRandEffectColour(Random rand) {
        int chance = rand.nextInt(5);
        switch (chance) {
            case 0: {
                return 13138688;
            }
            case 1: {
                return 0xFFFF00;
            }
            case 2: {
                return 0x720000;
            }
            case 3: {
                return 0xFFFFFF;
            }
        }
        return 9237730;
    }
}

