/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockInventoryScanner
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon furnaceIconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon furnaceIconFront;

    public BlockInventoryScanner(Material par1Material) {
        super(par1Material);
    }

    public void func_149726_b(World par1World, int par2, int par3, int par4) {
        super.func_149726_b(par1World, par2, par3, par4);
        this.setDefaultDirection(par1World, par2, par3, par4);
    }

    private void setDefaultDirection(World par1World, int par2, int par3, int par4) {
        if (!par1World.field_72995_K) {
            Block block = par1World.func_147439_a(par2, par3, par4 - 1);
            Block block1 = par1World.func_147439_a(par2, par3, par4 + 1);
            Block block2 = par1World.func_147439_a(par2 - 1, par3, par4);
            Block block3 = par1World.func_147439_a(par2 + 1, par3, par4);
            int b0 = 3;
            if (block.func_149730_j() && !block1.func_149730_j()) {
                b0 = 3;
            }
            if (block1.func_149730_j() && !block.func_149730_j()) {
                b0 = 2;
            }
            if (block2.func_149730_j() && !block3.func_149730_j()) {
                b0 = 5;
            }
            if (block3.func_149730_j() && !block2.func_149730_j()) {
                b0 = 4;
            }
            par1World.func_72921_c(par2, par3, par4, b0, 2);
        }
    }

    public boolean func_149727_a(World par1World, int par2, int par3, int par4, EntityPlayer par5EntityPlayer, int par6, float par7, float par8, float par9) {
        if (par1World.field_72995_K) {
            return true;
        }
        if (this.isFacingAnotherScanner(par1World, par2, par3, par4)) {
            par5EntityPlayer.openGui((Object)SecurityCraft.instance, 6, par1World, par2, par3, par4);
        } else {
            PlayerUtils.sendMessageToPlayer(par5EntityPlayer, StatCollector.func_74838_a((String)"tile.inventoryScanner.name"), StatCollector.func_74838_a((String)"messages.invScan.notConnected"), EnumChatFormatting.RED);
        }
        return true;
    }

    public void func_149689_a(World par1World, int par2, int par3, int par4, EntityLivingBase par5EntityLivingBase, ItemStack par6ItemStack) {
        if (par1World.field_72995_K) {
            return;
        }
        int l = MathHelper.func_76128_c((double)((double)(par5EntityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            par1World.func_72921_c(par2, par3, par4, 2, 2);
        }
        if (l == 1) {
            par1World.func_72921_c(par2, par3, par4, 5, 2);
        }
        if (l == 2) {
            par1World.func_72921_c(par2, par3, par4, 3, 2);
        }
        if (l == 3) {
            par1World.func_72921_c(par2, par3, par4, 4, 2);
        }
        this.checkAndPlaceAppropriately(par1World, par2, par3, par4);
    }

    private void checkAndPlaceAppropriately(World par1World, int par2, int par3, int par4) {
        TileEntityInventoryScanner connectedScanner = BlockInventoryScanner.getConnectedInventoryScanner(par1World, par2, par3, par4);
        if (connectedScanner == null) {
            return;
        }
        if (par1World.func_72805_g(par2, par3, par4) == 4) {
            for (int j = 1; j < Math.abs(par2 - connectedScanner.field_145851_c); ++j) {
                par1World.func_147465_d(par2 - j, par3, par4, SCContent.inventoryScannerField, 1, 3);
            }
        } else if (par1World.func_72805_g(par2, par3, par4) == 5) {
            for (int j = 1; j < Math.abs(par2 - connectedScanner.field_145851_c); ++j) {
                par1World.func_147465_d(par2 + j, par3, par4, SCContent.inventoryScannerField, 1, 3);
            }
        } else if (par1World.func_72805_g(par2, par3, par4) == 2) {
            for (int j = 1; j < Math.abs(par4 - connectedScanner.field_145849_e); ++j) {
                par1World.func_147465_d(par2, par3, par4 - j, SCContent.inventoryScannerField, 2, 3);
            }
        } else if (par1World.func_72805_g(par2, par3, par4) == 3) {
            for (int j = 1; j < Math.abs(par4 - connectedScanner.field_145849_e); ++j) {
                par1World.func_147465_d(par2, par3, par4 + j, SCContent.inventoryScannerField, 2, 3);
            }
        }
        CustomizableSCTE.link((CustomizableSCTE)par1World.func_147438_o(par2, par3, par4), connectedScanner);
    }

    public void func_149749_a(World par1World, int par2, int par3, int par4, Block par5Block, int par6) {
        int j;
        int i;
        if (par1World.field_72995_K) {
            return;
        }
        TileEntityInventoryScanner connectedScanner = null;
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (par1World.func_147439_a(par2 - i, par3, par4) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (par1World.func_147439_a(par2 - j, par3, par4) != SCContent.inventoryScannerField) continue;
                par1World.func_147480_a(par2 - j, par3, par4, false);
            }
            connectedScanner = (TileEntityInventoryScanner)par1World.func_147438_o(par2 - i, par3, par4);
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (par1World.func_147439_a(par2 + i, par3, par4) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (par1World.func_147439_a(par2 + j, par3, par4) != SCContent.inventoryScannerField) continue;
                par1World.func_147480_a(par2 + j, par3, par4, false);
            }
            connectedScanner = (TileEntityInventoryScanner)par1World.func_147438_o(par2 + i, par3, par4);
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (par1World.func_147439_a(par2, par3, par4 - i) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (par1World.func_147439_a(par2, par3, par4 - j) != SCContent.inventoryScannerField) continue;
                par1World.func_147480_a(par2, par3, par4 - j, false);
            }
            connectedScanner = (TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4 - i);
            break;
        }
        for (i = 1; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
            if (par1World.func_147439_a(par2, par3, par4 + i) != SCContent.inventoryScanner) continue;
            for (j = 1; j < i; ++j) {
                if (par1World.func_147439_a(par2, par3, par4 + j) != SCContent.inventoryScannerField) continue;
                par1World.func_147480_a(par2, par3, par4 + j, false);
            }
            connectedScanner = (TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4 + i);
            break;
        }
        for (i = 0; i < ((TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4)).getContents().length; ++i) {
            if (((TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4)).getContents()[i] == null) continue;
            par1World.func_72838_d((Entity)new EntityItem(par1World, (double)par2, (double)par3, (double)par4, ((TileEntityInventoryScanner)par1World.func_147438_o(par2, par3, par4)).getContents()[i]));
        }
        if (connectedScanner != null) {
            for (i = 0; i < connectedScanner.getContents().length; ++i) {
                connectedScanner.getContents()[i] = null;
            }
        }
        super.func_149749_a(par1World, par2, par3, par4, par5Block, par6);
    }

    private boolean isFacingAnotherScanner(World world, int x, int y, int z) {
        return BlockInventoryScanner.getConnectedInventoryScanner(world, x, y, z) != null;
    }

    public static TileEntityInventoryScanner getConnectedInventoryScanner(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 4: {
                if (world.func_147439_a(x, y, z) == SCContent.inventoryScanner) {
                    for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                        if (world.func_147439_a(x - i, y, z) != Blocks.field_150350_a && world.func_147439_a(x - i, y, z) != SCContent.inventoryScannerField && world.func_147439_a(x - i, y, z) != SCContent.inventoryScanner) {
                            return null;
                        }
                        if (world.func_147439_a(x - i, y, z) != SCContent.inventoryScanner || world.func_72805_g(x - i, y, z) != 5) continue;
                        return (TileEntityInventoryScanner)world.func_147438_o(x - i, y, z);
                    }
                }
                return null;
            }
            case 5: {
                if (world.func_147439_a(x, y, z) == SCContent.inventoryScanner) {
                    for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                        if (world.func_147439_a(x + i, y, z) != Blocks.field_150350_a && world.func_147439_a(x + i, y, z) != SCContent.inventoryScannerField && world.func_147439_a(x + i, y, z) != SCContent.inventoryScanner) {
                            return null;
                        }
                        if (world.func_147439_a(x + i, y, z) != SCContent.inventoryScanner || world.func_72805_g(x + i, y, z) != 4) continue;
                        return (TileEntityInventoryScanner)world.func_147438_o(x + i, y, z);
                    }
                }
                return null;
            }
            case 2: {
                if (world.func_147439_a(x, y, z) == SCContent.inventoryScanner) {
                    for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                        if (world.func_147439_a(x, y, z - i) != Blocks.field_150350_a && world.func_147439_a(x, y, z - i) != SCContent.inventoryScannerField && world.func_147439_a(x, y, z - i) != SCContent.inventoryScanner) {
                            return null;
                        }
                        if (world.func_147439_a(x, y, z - i) != SCContent.inventoryScanner || world.func_72805_g(x, y, z - i) != 3) continue;
                        return (TileEntityInventoryScanner)world.func_147438_o(x, y, z - i);
                    }
                    return null;
                }
                if (world.func_147439_a(x, y, z) != SCContent.inventoryScannerField) break;
                for (int i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                    if (world.func_147439_a(x, y, z - i) != SCContent.inventoryScanner) continue;
                    return (TileEntityInventoryScanner)world.func_147438_o(x, y, z - i);
                }
                break;
            }
            case 3: {
                if (world.func_147439_a(x, y, z) == SCContent.inventoryScanner) {
                    for (int i = 0; i <= SecurityCraft.config.inventoryScannerRange; ++i) {
                        if (world.func_147439_a(x, y, z + i) != Blocks.field_150350_a && world.func_147439_a(x, y, z + i) != SCContent.inventoryScannerField && world.func_147439_a(x, y, z + i) != SCContent.inventoryScanner) {
                            return null;
                        }
                        if (world.func_147439_a(x, y, z + i) != SCContent.inventoryScanner || world.func_72805_g(x, y, z + i) != 2) continue;
                        return (TileEntityInventoryScanner)world.func_147438_o(x, y, z + i);
                    }
                }
                return null;
            }
            case 1: {
                if (world.func_147439_a(x, y, z) != SCContent.inventoryScannerField) break;
                for (int i = 0; i < SecurityCraft.config.inventoryScannerRange; ++i) {
                    if (world.func_147439_a(x - i, y, z) != SCContent.inventoryScanner) continue;
                    return (TileEntityInventoryScanner)world.func_147438_o(x - i, y, z);
                }
                break;
            }
        }
        return null;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (!(par1IBlockAccess.func_147438_o(par2, par3, par4) instanceof TileEntityInventoryScanner) || ((TileEntityInventoryScanner)par1IBlockAccess.func_147438_o(par2, par3, par4)).getType() == null) {
            return 0;
        }
        return ((TileEntityInventoryScanner)par1IBlockAccess.func_147438_o(par2, par3, par4)).getType().matches("redstone") && ((TileEntityInventoryScanner)par1IBlockAccess.func_147438_o(par2, par3, par4)).shouldProvidePower() ? 15 : 0;
    }

    public int func_149748_c(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        if (((TileEntityInventoryScanner)par1IBlockAccess.func_147438_o(par2, par3, par4)).getType() == null) {
            return 0;
        }
        return ((TileEntityInventoryScanner)par1IBlockAccess.func_147438_o(par2, par3, par4)).getType().matches("redstone") && ((TileEntityInventoryScanner)par1IBlockAccess.func_147438_o(par2, par3, par4)).shouldProvidePower() ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int par1, int par2) {
        if (par1 == 3 && par2 == 0) {
            return this.furnaceIconFront;
        }
        return par1 == 1 ? this.furnaceIconTop : (par1 == 0 ? this.furnaceIconTop : (par1 != par2 ? this.field_149761_L : this.furnaceIconFront));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("furnace_side");
        this.furnaceIconFront = par1IconRegister.func_94245_a("securitycraft:inventoryScanner");
        this.furnaceIconTop = par1IconRegister.func_94245_a("furnace_top");
    }

    public TileEntity func_149915_a(World world, int par2) {
        return new TileEntityInventoryScanner();
    }
}

