/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.items.ItemCameraMonitor;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.packets.PacketCSetPlayerPositionAndRotation;
import net.geforcemods.securitycraft.network.packets.PacketGivePotionEffect;
import net.geforcemods.securitycraft.network.packets.PacketSAddModules;
import net.geforcemods.securitycraft.network.packets.PacketSSetCameraRotation;
import net.geforcemods.securitycraft.network.packets.PacketSSetOwner;
import net.geforcemods.securitycraft.network.packets.PacketSetBlockAndMetadata;
import net.geforcemods.securitycraft.network.packets.PacketSetBlockMetadata;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Mouse;

public class EntitySecurityCamera
extends Entity {
    private final float CAMERA_SPEED;
    public int blockPosX;
    public int blockPosY;
    public int blockPosZ;
    private double cameraUseX;
    private double cameraUseY;
    private double cameraUseZ;
    private float cameraUseYaw;
    private float cameraUsePitch;
    private int id;
    private int screenshotCooldown;
    private int redstoneCooldown;
    private int toggleNightVisionCooldown;
    private int toggleLightCooldown;
    private boolean shouldProvideNightVision;
    private float zoomAmount;
    private String playerViewingName;

    public EntitySecurityCamera(World world) {
        super(world);
        this.CAMERA_SPEED = SecurityCraft.config.cameraSpeed;
        this.screenshotCooldown = 0;
        this.redstoneCooldown = 0;
        this.toggleNightVisionCooldown = 0;
        this.toggleLightCooldown = 0;
        this.shouldProvideNightVision = false;
        this.zoomAmount = 1.0f;
        this.playerViewingName = null;
        this.field_70145_X = true;
        this.field_70131_O = 1.0E-4f;
        this.field_70130_N = 1.0E-4f;
    }

    public EntitySecurityCamera(World world, double x, double y, double z, int id, EntityPlayer player) {
        this(world);
        this.blockPosX = (int)x;
        this.blockPosY = (int)y;
        this.blockPosZ = (int)z;
        this.cameraUseX = player.field_70165_t;
        this.cameraUseY = player.field_70163_u;
        this.cameraUseZ = player.field_70161_v;
        this.cameraUseYaw = player.field_70177_z;
        this.cameraUsePitch = player.field_70125_A;
        this.id = id;
        this.playerViewingName = player.func_70005_c_();
        this.func_70107_b(x + 0.5, y + 1.0, z + 0.5);
        this.field_70125_A = 30.0f;
        int meta = this.field_70170_p.func_72805_g((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v));
        if (meta == 4 || meta == 8) {
            this.field_70177_z = 180.0f;
        } else if (meta == 2 || meta == 6) {
            this.field_70177_z = 90.0f;
        } else if (meta == 3 || meta == 7) {
            this.field_70177_z = 0.0f;
        } else if (meta == 1 || meta == 5) {
            this.field_70177_z = 270.0f;
        }
    }

    public EntitySecurityCamera(World world, double x, double y, double z, int id, EntitySecurityCamera camera) {
        this(world);
        this.blockPosX = (int)x;
        this.blockPosY = (int)y;
        this.blockPosZ = (int)z;
        this.cameraUseX = camera.cameraUseX;
        this.cameraUseY = camera.cameraUseY;
        this.cameraUseZ = camera.cameraUseZ;
        this.cameraUseYaw = camera.cameraUseYaw;
        this.cameraUsePitch = camera.cameraUsePitch;
        this.id = id;
        this.playerViewingName = camera.playerViewingName;
        this.func_70107_b(x + 0.5, y + 1.0, z + 0.5);
        this.field_70125_A = 30.0f;
        int meta = this.field_70170_p.func_72805_g((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v));
        if (meta == 4 || meta == 8) {
            this.field_70177_z = 180.0f;
        } else if (meta == 2 || meta == 6) {
            this.field_70177_z = 90.0f;
        } else if (meta == 3 || meta == 7) {
            this.field_70177_z = 0.0f;
        } else if (meta == 1 || meta == 5) {
            this.field_70177_z = 270.0f;
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * -7500.0;
    }

    protected boolean func_142008_O() {
        return false;
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70153_n != null) {
            if (this.screenshotCooldown > 0) {
                --this.screenshotCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
            if (this.toggleLightCooldown > 0) {
                --this.toggleLightCooldown;
            }
            if (this.id == 0 && ((EntityPlayer)this.field_70153_n).func_71045_bC() != null && ((EntityPlayer)this.field_70153_n).func_71045_bC().func_77973_b() == SCContent.cameraMonitor) {
                this.id = ((ItemCameraMonitor)((EntityPlayer)this.field_70153_n).func_71045_bC().func_77973_b()).getSlotFromPosition(((EntityPlayer)this.field_70153_n).func_71045_bC().field_77990_d, new CameraView((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v), this.field_70153_n.field_71093_bK));
            }
            if (((EntityPlayer)this.field_70153_n).field_70177_z != this.field_70177_z) {
                ((EntityPlayer)this.field_70153_n).field_70177_z = this.field_70177_z;
            }
            if (((EntityPlayer)this.field_70153_n).field_70125_A != this.field_70125_A) {
                ((EntityPlayer)this.field_70153_n).field_70125_A = this.field_70125_A;
            }
            this.checkKeysPressed();
            if (Mouse.hasWheel() && Mouse.isButtonDown((int)2) && this.screenshotCooldown == 0) {
                this.screenshotCooldown = 30;
                ClientUtils.takeScreenshot();
                Minecraft.func_71410_x().field_71441_e.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, SCSounds.CAMERASNAP.path, 1.0f, 1.0f, true);
            }
            if (this.field_70153_n != null && this.shouldProvideNightVision) {
                SecurityCraft.network.sendToServer((IMessage)new PacketGivePotionEffect(Potion.field_76439_r.field_76415_H, 3, -1));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.field_70153_n == null | this.field_70170_p.func_147439_a(this.blockPosX, this.blockPosY, this.blockPosZ) != SCContent.securityCamera) {
            this.func_70106_y();
            return;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void checkKeysPressed() {
        if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
            this.moveViewUp();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
            this.moveViewDown();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
            this.moveViewLeft();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
            this.moveViewRight();
        }
        if (this.field_70170_p.func_147438_o((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v)) instanceof CustomizableSCTE && KeyBindings.cameraEmitRedstone.func_151470_d() && this.field_70170_p.func_147438_o((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v)) != null && ((CustomizableSCTE)this.field_70170_p.func_147438_o((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v))).hasModule(EnumCustomModules.REDSTONE) && this.redstoneCooldown == 0) {
            int meta = this.field_70170_p.func_72805_g((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v));
            this.setRedstonePower(meta);
            this.redstoneCooldown = 30;
        }
        if (KeyBindings.cameraActivateNightVision.func_151470_d() && this.toggleNightVisionCooldown == 0) {
            this.enableNightVision();
        }
        if (KeyBindings.cameraZoomIn.func_151468_f()) {
            this.zoomCameraView(-1);
        }
        if (KeyBindings.cameraZoomOut.func_151468_f()) {
            this.zoomCameraView(1);
        }
    }

    public void moveViewUp() {
        if (this.field_70125_A > -25.0f) {
            this.func_70101_b(this.field_70177_z, this.field_70125_A -= this.CAMERA_SPEED);
        }
        this.updateServerRotation();
    }

    public void moveViewDown() {
        if (this.field_70125_A < 60.0f) {
            this.func_70101_b(this.field_70177_z, this.field_70125_A += this.CAMERA_SPEED);
        }
        this.updateServerRotation();
    }

    public void moveViewLeft() {
        int meta = this.field_70170_p.func_72805_g((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v));
        if (meta == 4 || meta == 8) {
            if (this.field_70177_z < 0.0f) {
                if (this.field_70177_z - this.CAMERA_SPEED < 180.0f) {
                    this.func_70101_b(this.field_70177_z -= this.CAMERA_SPEED, this.field_70125_A);
                }
            } else if (this.field_70177_z - this.CAMERA_SPEED > 90.0f) {
                this.func_70101_b(this.field_70177_z -= this.CAMERA_SPEED, this.field_70125_A);
            }
        } else if (meta == 2 || meta == 6) {
            if (this.field_70177_z - this.CAMERA_SPEED > 0.0f) {
                this.func_70101_b(this.field_70177_z -= this.CAMERA_SPEED, this.field_70125_A);
            }
        } else if (meta == 3 || meta == 7) {
            if (this.field_70177_z - this.CAMERA_SPEED > -90.0f) {
                this.func_70101_b(this.field_70177_z -= this.CAMERA_SPEED, this.field_70125_A);
            }
        } else if ((meta == 1 || meta == 5) && this.field_70177_z - this.CAMERA_SPEED > -180.0f) {
            this.func_70101_b(this.field_70177_z -= this.CAMERA_SPEED, this.field_70125_A);
        }
        this.updateServerRotation();
    }

    public void moveViewRight() {
        int meta = this.field_70170_p.func_72805_g((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v));
        if (meta == 4 || meta == 8) {
            if (this.field_70177_z < 0.0f) {
                if (Math.abs(this.field_70177_z) + this.CAMERA_SPEED > 90.0f) {
                    this.func_70101_b(this.field_70177_z += this.CAMERA_SPEED, this.field_70125_A);
                }
            } else if (this.field_70177_z + this.CAMERA_SPEED < 185.0f) {
                this.func_70101_b(this.field_70177_z += this.CAMERA_SPEED, this.field_70125_A);
            }
        } else if (meta == 2 || meta == 6) {
            if (this.field_70177_z + this.CAMERA_SPEED < 180.0f) {
                this.func_70101_b(this.field_70177_z += this.CAMERA_SPEED, this.field_70125_A);
            }
        } else if (meta == 3 || meta == 7) {
            if (this.field_70177_z + this.CAMERA_SPEED < 90.0f) {
                this.func_70101_b(this.field_70177_z += this.CAMERA_SPEED, this.field_70125_A);
            }
        } else if ((meta == 1 || meta == 5) && this.field_70177_z + this.CAMERA_SPEED < 0.0f) {
            this.func_70101_b(this.field_70177_z += this.CAMERA_SPEED, this.field_70125_A);
        }
        this.updateServerRotation();
    }

    public void zoomCameraView(int zoom) {
        if (zoom > 0) {
            if (this.zoomAmount == -0.5f) {
                this.zoomAmount = 1.0f;
                Minecraft.func_71410_x().field_71441_e.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, SCSounds.CAMERAZOOMIN.path, 1.0f, 1.0f, true);
            } else if (this.zoomAmount == 1.0f) {
                this.zoomAmount = 2.0f;
                Minecraft.func_71410_x().field_71441_e.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, SCSounds.CAMERAZOOMIN.path, 1.0f, 1.0f, true);
            }
        } else if (zoom < 0) {
            if (this.zoomAmount == 2.0f) {
                this.zoomAmount = 1.0f;
                Minecraft.func_71410_x().field_71441_e.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, SCSounds.CAMERAZOOMIN.path, 1.0f, 1.0f, true);
            } else if (this.zoomAmount == 1.0f) {
                this.zoomAmount = -0.5f;
                Minecraft.func_71410_x().field_71441_e.func_72980_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, SCSounds.CAMERAZOOMIN.path, 1.0f, 1.0f, true);
            }
        }
    }

    public void setRedstonePower(int meta) {
        if (meta == 5 || meta == 6 || meta == 7 || meta == 8) {
            SecurityCraft.network.sendToServer((IMessage)new PacketSetBlockMetadata((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v), this.field_70170_p.func_72805_g((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v)) - 4, true, 1, "", ""));
        } else if (meta == 1 || meta == 2 || meta == 3 || meta == 4) {
            SecurityCraft.network.sendToServer((IMessage)new PacketSetBlockMetadata((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v), this.field_70170_p.func_72805_g((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v)) + 4, true, 1, "", ""));
        }
    }

    public void enableNightVision() {
        this.toggleNightVisionCooldown = 30;
        this.shouldProvideNightVision = !this.shouldProvideNightVision;
    }

    public void emitLight() {
        Block block = this.field_70170_p.func_147439_a((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v));
        if (block instanceof BlockSecurityCamera) {
            this.toggleLightCooldown = 30;
            int meta = this.field_70170_p.func_72805_g((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v));
            ItemStack[] modules = null;
            if (!((CustomizableSCTE)this.field_70170_p.func_147438_o((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v))).getModules().isEmpty()) {
                modules = ((CustomizableSCTE)this.field_70170_p.func_147438_o((int)((int)Math.floor((double)this.field_70165_t)), (int)((int)(this.field_70163_u - 1.0)), (int)((int)Math.floor((double)this.field_70161_v)))).itemStacks;
            }
            if (block == SCContent.securityCamera) {
                SecurityCraft.network.sendToServer((IMessage)new PacketSetBlockAndMetadata((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v), "securitycraft:securityCameraLit", meta));
                SecurityCraft.network.sendToServer((IMessage)new PacketSSetOwner((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v), ((IOwnable)this.field_70170_p.func_147438_o((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v))).getOwner().getUUID(), ((IOwnable)this.field_70170_p.func_147438_o((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v))).getOwner().getName()));
                if (modules != null) {
                    SecurityCraft.network.sendToServer((IMessage)new PacketSAddModules((int)Math.floor(this.field_70165_t), (int)(this.field_70163_u - 1.0), (int)Math.floor(this.field_70161_v), modules));
                }
            }
        }
    }

    public String getCameraInfo() {
        String nowViewing = EnumChatFormatting.UNDERLINE + "Now viewing camera #" + this.id + "\n\n";
        String pos = EnumChatFormatting.YELLOW + "Pos: " + EnumChatFormatting.RESET + "X: " + (int)Math.floor(this.field_70165_t) + " Y: " + (int)(this.field_70163_u - 1.0) + " Z: " + (int)Math.floor(this.field_70161_v) + "\n";
        String viewingFrom = this.field_70153_n != null ? EnumChatFormatting.YELLOW + "Viewing from: " + EnumChatFormatting.RESET + " X: " + (int)Math.floor(this.cameraUseX) + " Y: " + (int)Math.floor(this.cameraUseY) + " Z: " + (int)Math.floor(this.cameraUseZ) : "";
        return nowViewing + pos + viewingFrom;
    }

    @SideOnly(value=Side.CLIENT)
    private void updateServerRotation() {
        SecurityCraft.network.sendToServer((IMessage)new PacketSSetCameraRotation(this.field_70177_z, this.field_70125_A));
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.playerViewingName != null && PlayerUtils.isPlayerOnline(this.playerViewingName)) {
            EntityPlayer player = PlayerUtils.getPlayerFromName(this.playerViewingName);
            player.func_70634_a(this.cameraUseX, this.cameraUseY, this.cameraUseZ);
            SecurityCraft.network.sendTo((IMessage)new PacketCSetPlayerPositionAndRotation(this.cameraUseX, this.cameraUseY, this.cameraUseZ, this.cameraUseYaw, this.cameraUsePitch), (EntityPlayerMP)player);
        }
    }

    protected void func_70088_a() {
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("CameraID", this.id);
        if (this.playerViewingName != null) {
            tagCompound.func_74778_a("playerName", this.playerViewingName);
        }
        if (this.cameraUseX != 0.0) {
            tagCompound.func_74780_a("cameraUseX", this.cameraUseX);
        }
        if (this.cameraUseY != 0.0) {
            tagCompound.func_74780_a("cameraUseY", this.cameraUseY);
        }
        if (this.cameraUseZ != 0.0) {
            tagCompound.func_74780_a("cameraUseZ", this.cameraUseZ);
        }
        if ((double)this.cameraUseYaw != 0.0) {
            tagCompound.func_74780_a("cameraUseYaw", (double)this.cameraUseYaw);
        }
        if ((double)this.cameraUsePitch != 0.0) {
            tagCompound.func_74780_a("cameraUsePitch", (double)this.cameraUsePitch);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.id = tagCompound.func_74762_e("CameraID");
        if (tagCompound.func_74764_b("playerName")) {
            this.playerViewingName = tagCompound.func_74779_i("playerName");
        }
        if (tagCompound.func_74764_b("cameraUseX")) {
            this.cameraUseX = tagCompound.func_74769_h("cameraUseX");
        }
        if (tagCompound.func_74764_b("cameraUseY")) {
            this.cameraUseY = tagCompound.func_74769_h("cameraUseY");
        }
        if (tagCompound.func_74764_b("cameraUseZ")) {
            this.cameraUseZ = tagCompound.func_74769_h("cameraUseZ");
        }
        if (tagCompound.func_74764_b("cameraUseYaw")) {
            this.cameraUseYaw = tagCompound.func_74760_g("cameraUseYaw");
        }
        if (tagCompound.func_74764_b("cameraUsePitch")) {
            this.cameraUsePitch = tagCompound.func_74760_g("cameraUsePitch");
        }
    }
}

