/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.imc.waila;

import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.imc.waila.ICustomWailaDisplay;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class WailaDataProvider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar registrar) {
        SecurityCraft.log("Adding Waila support!");
        registrar.addConfig("SecurityCraft", "securitycraft.showowner", StatCollector.func_74838_a((String)"waila.displayOwner"));
        registrar.addConfig("SecurityCraft", "securitycraft.showmodules", StatCollector.func_74838_a((String)"waila.showModules"));
        registrar.addConfig("SecurityCraft", "securitycraft.showpasswords", StatCollector.func_74838_a((String)"waila.showPasswords"));
        registrar.addConfig("SecurityCraft", "securitycraft.showcustomname", StatCollector.func_74838_a((String)"waila.showCustomName"));
        registrar.registerBodyProvider((IWailaDataProvider)new WailaDataProvider(), IOwnable.class);
        registrar.registerStackProvider((IWailaDataProvider)new WailaDataProvider(), ICustomWailaDisplay.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor data, IWailaConfigHandler config) {
        if (data.getBlock() instanceof ICustomWailaDisplay) {
            return ((ICustomWailaDisplay)data.getBlock()).getDisplayStack(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d);
        }
        return null;
    }

    public List<String> getWailaHead(ItemStack itemstack, List<String> head, IWailaDataAccessor data, IWailaConfigHandler config) {
        return head;
    }

    public List<String> getWailaBody(ItemStack itemstack, List<String> body, IWailaDataAccessor data, IWailaConfigHandler config) {
        if (data.getBlock() instanceof ICustomWailaDisplay && !((ICustomWailaDisplay)data.getBlock()).shouldShowSCInfo(data.getWorld(), data.getPosition().field_72311_b, data.getPosition().field_72312_c, data.getPosition().field_72309_d)) {
            return body;
        }
        if (config.getConfig("securitycraft.showowner") && data.getTileEntity() instanceof IOwnable) {
            body.add(StatCollector.func_74838_a((String)"waila.owner") + " " + ((IOwnable)data.getTileEntity()).getOwner().getName());
        }
        if (config.getConfig("securitycraft.showmodules") && data.getTileEntity() instanceof CustomizableSCTE && ((CustomizableSCTE)data.getTileEntity()).getOwner().isOwner(data.getPlayer())) {
            if (!((CustomizableSCTE)data.getTileEntity()).getModules().isEmpty()) {
                body.add(StatCollector.func_74838_a((String)"waila.equipped"));
            }
            for (EnumCustomModules module : ((CustomizableSCTE)data.getTileEntity()).getModules()) {
                body.add("- " + module.getName());
            }
        }
        if (config.getConfig("securitycraft.showpasswords") && data.getTileEntity() instanceof IPasswordProtected && !(data.getTileEntity() instanceof TileEntityKeycardReader) && ((IOwnable)data.getTileEntity()).getOwner().isOwner(data.getPlayer())) {
            String password = ((IPasswordProtected)data.getTileEntity()).getPassword();
            body.add(StatCollector.func_74838_a((String)"waila.password") + " " + (password != null && !password.isEmpty() ? password : StatCollector.func_74838_a((String)"waila.password.notSet")));
        }
        if (config.getConfig("securitycraft.showcustomname") && data.getTileEntity() instanceof INameable && ((INameable)data.getTileEntity()).canBeNamed()) {
            String name = ((INameable)data.getTileEntity()).getCustomName();
            body.add(StatCollector.func_74838_a((String)"waila.customName") + " " + (((INameable)data.getTileEntity()).hasCustomName() ? name : StatCollector.func_74838_a((String)"waila.customName.notSet")));
        }
        return body;
    }

    public List<String> getWailaTail(ItemStack itemstack, List<String> tail, IWailaDataAccessor data, IWailaConfigHandler config) {
        return tail;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tileEntity, NBTTagCompound tagCompound, World world, int arg4, int arg5, int arg6) {
        return tagCompound;
    }
}

