/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.cartography;

import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.ColorPalette;
import journeymap.client.forge.helper.ForgeHelper;
import journeymap.client.forge.helper.IColorHelper;
import journeymap.client.forge.helper.IForgeHelper;
import journeymap.client.log.LogFormatter;
import journeymap.client.model.BlockMD;
import journeymap.client.task.multi.MapPlayerTask;
import journeymap.common.Journeymap;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;

public class ColorManager {
    private final IForgeHelper forgeHelper = ForgeHelper.INSTANCE;
    private volatile IColorHelper colorHelper = this.forgeHelper.getColorHelper();
    private volatile ColorPalette currentPalette;
    private String lastResourcePackNames;
    private String lastModNames;

    public static ColorManager instance() {
        return Holder.INSTANCE;
    }

    public void ensureCurrent() {
        try {
            if (!Display.isCurrent()) {
                Journeymap.getLogger().error("ColorManager.ensureCurrent() must be called on main thread!");
            }
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            return;
        }
        String currentResourcePackNames = Constants.getResourcePackNames();
        String currentModNames = Constants.getModNames();
        boolean resourcePackSame = false;
        boolean modPackSame = false;
        boolean blocksTextureChanged = false;
        if (currentResourcePackNames.equals(this.lastResourcePackNames) && this.colorHelper != null) {
            Journeymap.getLogger().debug("Resource Pack(s) unchanged: " + currentResourcePackNames);
            resourcePackSame = true;
        }
        if (currentModNames.equals(this.lastModNames)) {
            Journeymap.getLogger().debug("Mod Pack(s) unchanged: " + currentModNames);
            modPackSame = true;
        }
        if (!resourcePackSame || !modPackSame) {
            this.lastResourcePackNames = currentResourcePackNames;
            this.lastModNames = currentModNames;
            blocksTextureChanged = this.colorHelper.clearBlocksTexture();
        }
        if (!this.colorHelper.hasBlocksTexture()) {
            Journeymap.getLogger().info("Loading blocks and textures...");
            boolean isMapping = JourneymapClient.getInstance().isMapping();
            if (isMapping) {
                JourneymapClient.getInstance().stopMapping();
            }
            BlockMD.reset();
            this.colorHelper.initBlocksTexture();
            this.initBlockColors(blocksTextureChanged);
            if (isMapping) {
                JourneymapClient.getInstance().startMapping();
            }
        } else {
            Journeymap.getLogger().info("Blocks and textures are current");
        }
    }

    public ColorPalette getCurrentPalette() {
        return this.currentPalette;
    }

    private void initBlockColors(boolean currentPaletteInvalid) {
        try {
            long start;
            ColorPalette palette = ColorPalette.getActiveColorPalette();
            boolean standard = true;
            boolean permanent = false;
            if (palette != null) {
                standard = palette.isStandard();
                permanent = palette.isPermanent();
                if (currentPaletteInvalid && !permanent) {
                    Journeymap.getLogger().info("New color palette will be created");
                    palette = null;
                } else {
                    try {
                        start = System.currentTimeMillis();
                        for (Map.Entry<BlockMD, Integer> entry : palette.getBasicColorMap().entrySet()) {
                            entry.getKey().setColor(entry.getValue());
                        }
                        long elapsed = System.currentTimeMillis() - start;
                        Journeymap.getLogger().info(String.format("Loaded %d block colors from color palette file in %dms: %s", palette.size(), elapsed, palette.getOrigin()));
                    }
                    catch (Exception e) {
                        Journeymap.getLogger().warn("Could not load existing color palette, new one will be created: " + e);
                        palette = null;
                    }
                }
            }
            start = System.currentTimeMillis();
            int count = 0;
            for (BlockMD blockMD : BlockMD.getAll()) {
                if (!blockMD.ensureColor()) continue;
                ++count;
            }
            long l = System.currentTimeMillis() - start;
            if (count > 0 || palette == null) {
                Journeymap.getLogger().info(String.format("Initialized %s block colors from mods and resource packs in %sms", count, l));
                this.currentPalette = ColorPalette.create(standard, permanent);
                Journeymap.getLogger().info(String.format("Updated color palette file: %s", this.currentPalette.getOrigin()));
            } else {
                this.currentPalette = palette;
                Journeymap.getLogger().info(String.format("Color palette was sufficient: %s", this.currentPalette.getOrigin()));
            }
            MapPlayerTask.forceNearbyRemap();
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("ColorManager.initBlockColors() encountered an unexpected error: " + LogFormatter.toPartialString(t));
        }
    }

    private static class Holder {
        private static final ColorManager INSTANCE = new ColorManager();

        private Holder() {
        }
    }
}

