/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mantle.blocks.abstracts.InventoryBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.tools.TinkerTools;
import tconstruct.tools.logic.PartBuilderLogic;
import tconstruct.tools.logic.PatternChestLogic;
import tconstruct.tools.logic.StencilTableLogic;
import tconstruct.tools.logic.ToolStationLogic;
import tconstruct.tools.model.TableRender;
import tconstruct.util.config.PHConstruct;

public class ToolStationBlock
extends InventoryBlock {
    public ToolStationBlock(Material material) {
        super(material);
        this.func_149647_a(TConstructRegistry.blockTab);
        this.func_149711_c(2.0f);
        this.func_149672_a(Block.field_149766_f);
    }

    public String[] getTextureNames() {
        String[] textureNames = new String[]{"toolstation_top", "toolstation_side", "toolstation_bottom", "partbuilder_oak_top", "partbuilder_oak_side", "partbuilder_oak_bottom", "partbuilder_spruce_top", "partbuilder_spruce_side", "partbuilder_spruce_bottom", "partbuilder_birch_top", "partbuilder_birch_side", "partbuilder_birch_bottom", "partbuilder_jungle_top", "partbuilder_jungle_side", "partbuilder_jungle_bottom", "patternchest_top", "patternchest_side", "patternchest_bottom", "stenciltable_oak_top", "stenciltable_oak_side", "stenciltable_oak_bottom", "stenciltable_spruce_top", "stenciltable_spruce_side", "stenciltable_spruce_bottom", "stenciltable_birch_top", "stenciltable_birch_side", "stenciltable_birch_bottom", "stenciltable_jungle_top", "stenciltable_jungle_side", "stenciltable_jungle_bottom"};
        return textureNames;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta <= 4) {
            return this.icons[meta * 3 + this.getTextureIndex(side)];
        }
        if (meta <= 9) {
            return this.icons[15 + this.getTextureIndex(side)];
        }
        return this.icons[meta * 3 + this.getTextureIndex(side) - 12];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return side == ForgeDirection.UP;
    }

    public int func_149645_b() {
        return TableRender.model;
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return true;
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 5) {
            return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F - 0.125), (double)((double)z + this.field_149757_G));
        }
        return AxisAlignedBB.func_72330_a((double)((double)x + this.field_149759_B), (double)((double)y + this.field_149760_C), (double)((double)z + this.field_149754_D), (double)((double)x + this.field_149755_E), (double)((double)y + this.field_149756_F), (double)((double)z + this.field_149757_G));
    }

    public TileEntity func_149915_a(World world, int metadata) {
        switch (metadata) {
            case 0: {
                return new ToolStationLogic();
            }
            case 1: {
                return new PartBuilderLogic();
            }
            case 2: {
                return new PartBuilderLogic();
            }
            case 3: {
                return new PartBuilderLogic();
            }
            case 4: {
                return new PartBuilderLogic();
            }
            case 5: {
                return new PatternChestLogic();
            }
            case 6: {
                return new PatternChestLogic();
            }
            case 7: {
                return new PatternChestLogic();
            }
            case 8: {
                return new PatternChestLogic();
            }
            case 9: {
                return new PatternChestLogic();
            }
            case 10: {
                return new StencilTableLogic();
            }
            case 11: {
                return new StencilTableLogic();
            }
            case 12: {
                return new StencilTableLogic();
            }
            case 13: {
                return new StencilTableLogic();
            }
        }
        return null;
    }

    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int md = world.func_72805_g(x, y, z);
        if (md == 0) {
            return 0;
        }
        if (md < 5) {
            return 1;
        }
        if (md < 10) {
            return 2;
        }
        return 3;
    }

    public Object getModInstance() {
        return TConstruct.instance;
    }

    public void func_149666_a(Item id, CreativeTabs tab, List list) {
        int iter;
        for (iter = 0; iter < 6; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
        for (iter = 10; iter < 14; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    public String getTextureDomain(int textureNameIndex) {
        return "tinker";
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        int meta;
        player.func_71020_j(0.025f);
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && (meta = world.func_72805_g(x, y, z)) >= 5 && meta <= 9) {
            ItemStack chest = new ItemStack((Block)this, 1, 5);
            NBTTagCompound inventory = new NBTTagCompound();
            PatternChestLogic logic = (PatternChestLogic)world.func_147438_o(x, y, z);
            logic.writeInventoryToNBT(inventory);
            NBTTagCompound baseTag = new NBTTagCompound();
            baseTag.func_74782_a("Inventory", (NBTBase)inventory);
            chest.func_77982_d(baseTag);
            for (int i = 0; i < logic.func_70302_i_(); ++i) {
                logic.func_70299_a(i, null);
            }
            if (!player.field_71075_bZ.field_75098_d || player.func_70093_af()) {
                float f = 0.7f;
                double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, chest);
                entityitem.field_145804_b = 10;
                world.func_72838_d((Entity)entityitem);
            }
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        if (meta < 5 || meta > 9) {
            super.func_149636_a(world, player, x, y, z, meta);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase living, ItemStack stack) {
        int meta;
        boolean keptInventory = false;
        if (stack.func_77942_o()) {
            NBTTagCompound inventory = stack.func_77978_p().func_74775_l("Inventory");
            TileEntity te = world.func_147438_o(x, y, z);
            if (inventory != null && te instanceof PatternChestLogic) {
                PatternChestLogic logic = (PatternChestLogic)te;
                logic.readInventoryFromNBT(inventory);
                logic.field_145851_c = x;
                logic.field_145848_d = y;
                logic.field_145849_e = z;
                keptInventory = true;
            }
        }
        if (!keptInventory && PHConstruct.freePatterns && (meta = world.func_72805_g(x, y, z)) == 5) {
            PatternChestLogic logic = (PatternChestLogic)world.func_147438_o(x, y, z);
            for (int i = 1; i <= 13; ++i) {
                logic.func_70299_a(i - 1, new ItemStack(TinkerTools.woodPattern, 1, i));
            }
            logic.func_70299_a(13, new ItemStack(TinkerTools.woodPattern, 1, 22));
        }
        super.func_149689_a(world, x, y, z, living, stack);
    }
}

