/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.client.gui.GuiMetallurgicInfuser;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.nei.BaseRecipeHandler;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class MetallurgicInfuserRecipeHandler
extends BaseRecipeHandler {
    private int ticksPassed;

    @Override
    public void addGuiElements() {
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.EXTRA, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 16, 34));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.INPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 50, 42));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 108, 42));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public double getLevel() {
                return MetallurgicInfuserRecipeHandler.this.ticksPassed <= 20 ? (double)((float)MetallurgicInfuserRecipeHandler.this.ticksPassed / 20.0f) : 1.0;
            }
        }, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 164, 15));
        this.guiElements.add(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return MetallurgicInfuserRecipeHandler.this.ticksPassed >= 40 ? (double)((float)((MetallurgicInfuserRecipeHandler.this.ticksPassed - 40) % 20) / 20.0f) : 0.0;
            }
        }, GuiProgress.ProgressBar.MEDIUM, this, MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.stripTexture()), 70, 46));
    }

    public String getRecipeName() {
        return LangUtils.localize("tile.MachineBlock.MetallurgicInfuser.name");
    }

    public String getOverlayIdentifier() {
        return "infuser";
    }

    public String getGuiTexture() {
        return "mekanism:gui/GuiMetallurgicInfuser.png";
    }

    public Class getGuiClass() {
        return GuiMetallurgicInfuser.class;
    }

    public String getRecipeId() {
        return "mekanism.infuser";
    }

    public List<ItemStack> getInfuseStacks(InfuseType type) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, InfuseObject> obj : InfuseRegistry.getObjectMap().entrySet()) {
            if (obj.getValue().type != type) continue;
            ret.add(obj.getKey());
        }
        return ret;
    }

    public Collection<MetallurgicInfuserRecipe> getRecipes() {
        return RecipeHandler.Recipe.METALLURGIC_INFUSER.get().values();
    }

    public void drawBackground(int i) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)15, (int)166, (int)56);
        for (GuiElement e : this.guiElements) {
            e.renderBackground(0, 0, -5, -15);
        }
    }

    public void drawExtras(int i) {
        float f;
        InfuseType type = ((CachedIORecipe)((Object)this.arecipes.get((int)i))).infusionType;
        float f2 = f = this.ticksPassed >= 20 && this.ticksPassed < 40 ? (float)((this.ticksPassed - 20) % 20) / 20.0f : 1.0f;
        if (this.ticksPassed < 20) {
            f = 0.0f;
        }
        int display = (int)(52.0f * f);
        GuiDraw.changeTexture((ResourceLocation)MekanismRenderer.getBlocksTexture());
        this.drawTexturedRectFromIcon(2, 54 - display, type.icon, 4, display);
    }

    public void onUpdate() {
        super.onUpdate();
        ++this.ticksPassed;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(67, 32, 32, 8), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (MetallurgicInfuserRecipe irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStacks(((InfusionInput)irecipe.getInput()).infuse.type), ((InfusionInput)irecipe.getInput()).infuse.type));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public int recipiesPerPage() {
        return 2;
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (MetallurgicInfuserRecipe irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((ItemStackOutput)irecipe.getOutput()).output, (ItemStack)result)) continue;
            this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStacks(((InfusionInput)irecipe.getInput()).infuse.type), ((InfusionInput)irecipe.getInput()).infuse.type));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (MetallurgicInfuserRecipe irecipe : this.getRecipes()) {
            if (NEIServerUtils.areStacksSameTypeCrafting((ItemStack)((InfusionInput)irecipe.getInput()).inputStack, (ItemStack)ingredient)) {
                this.arecipes.add(new CachedIORecipe(irecipe, this.getInfuseStacks(((InfusionInput)irecipe.getInput()).infuse.type), ((InfusionInput)irecipe.getInput()).infuse.type));
            }
            for (ItemStack stack : this.getInfuseStacks(((InfusionInput)irecipe.getInput()).infuse.type)) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)stack, (ItemStack)ingredient)) continue;
                ArrayList<ItemStack> infuses = new ArrayList<ItemStack>();
                infuses.add(stack);
                this.arecipes.add(new CachedIORecipe(irecipe, infuses, ((InfusionInput)irecipe.getInput()).infuse.type));
            }
        }
    }

    public class CachedIORecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<ItemStack> infuseStacks;
        public PositionedStack inputStack;
        public PositionedStack outputStack;
        public InfuseType infusionType;

        public PositionedStack getIngredient() {
            return this.inputStack;
        }

        public PositionedStack getResult() {
            return this.outputStack;
        }

        public PositionedStack getOtherStack() {
            return new PositionedStack((Object)this.infuseStacks.get(MetallurgicInfuserRecipeHandler.this.cycleticks / 40 % this.infuseStacks.size()), 12, 20);
        }

        public CachedIORecipe(ItemStack input, ItemStack output, List<ItemStack> infuses, InfuseType type) {
            super((TemplateRecipeHandler)MetallurgicInfuserRecipeHandler.this);
            this.inputStack = new PositionedStack((Object)input, 46, 28);
            this.outputStack = new PositionedStack((Object)output, 104, 28);
            this.infuseStacks = infuses;
            this.infusionType = type;
        }

        public CachedIORecipe(MetallurgicInfuserRecipe recipe, List<ItemStack> infuses, InfuseType type) {
            this(((InfusionInput)recipe.getInput()).inputStack, ((ItemStackOutput)recipe.getOutput()).output, infuses, type);
        }
    }
}

