/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.ShapedRecipeHandler;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.util.LangUtils;
import mekanism.common.util.RecipeUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;

public class ShapedMekanismRecipeHandler
extends ShapedRecipeHandler {
    public String getRecipeName() {
        return "Mekanism " + LangUtils.localize("recipe.mekanismShaped");
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("crafting") && ((Object)((Object)this)).getClass() == ShapedMekanismRecipeHandler.class) {
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                if (!(irecipe instanceof ShapedMekanismRecipe)) continue;
                ShapedMekanismRecipe mekanismRecipe = (ShapedMekanismRecipe)irecipe;
                CachedShapedMekanismRecipe recipe = new CachedShapedMekanismRecipe(mekanismRecipe);
                recipe.computeVisuals();
                this.arecipes.add(recipe);
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!(irecipe instanceof ShapedMekanismRecipe) || !RecipeUtils.areItemsEqualForCrafting(irecipe.func_77571_b(), result)) continue;
            ShapedMekanismRecipe mekanismRecipe = (ShapedMekanismRecipe)irecipe;
            CachedShapedMekanismRecipe recipe = new CachedShapedMekanismRecipe(mekanismRecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List allrecipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe irecipe : allrecipes) {
            if (!(irecipe instanceof ShapedMekanismRecipe)) continue;
            ShapedMekanismRecipe mekanismRecipe = (ShapedMekanismRecipe)irecipe;
            CachedShapedMekanismRecipe recipe = new CachedShapedMekanismRecipe(mekanismRecipe);
            recipe.computeVisuals();
            if (!recipe.contains(recipe.ingredients, ingredient)) continue;
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
        }
    }

    public class CachedShapedMekanismRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> ingredients;
        public PositionedStack result;

        public CachedShapedMekanismRecipe(ShapedMekanismRecipe recipe) {
            super((TemplateRecipeHandler)ShapedMekanismRecipeHandler.this);
            this.result = new PositionedStack((Object)recipe.func_77571_b(), 119, 24);
            this.ingredients = new ArrayList();
            this.setIngredients(recipe.width, recipe.height, recipe.getInput());
        }

        public void setIngredients(int width, int height, Object[] items) {
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    if (items[y * width + x] == null) continue;
                    PositionedStack stack = new PositionedStack(items[y * width + x], 25 + x * 18, 6 + y * 18);
                    stack.setMaxSize(1);
                    this.ingredients.add(stack);
                }
            }
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(ShapedMekanismRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            for (PositionedStack stack : ingredients) {
                for (ItemStack item : stack.items) {
                    if (!RecipeUtils.areItemsEqualForCrafting(item, ingredient)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

