/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.IEnergyCube;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2")})
public class ItemBlockEnergyCube
extends ItemBlock
implements IEnergizedItem,
IEnergyCube,
ISpecialElectricItem,
ISustainedInventory,
IEnergyContainerItem,
ISecurityItem {
    public Block metaBlock;

    public ItemBlockEnergyCube(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77637_a(Mekanism.tabMekanism);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
        list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("tooltip.capacity") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergyCubeTier((ItemStack)itemstack).maxEnergy));
        if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
        } else {
            if (this.hasSecurity(itemstack)) {
                list.add(SecurityUtils.getOwnerDisplay(entityplayer.func_70005_c_(), this.getOwner(itemstack)));
                list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                    list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                }
            }
            list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
        }
    }

    public ItemStack getUnchargedItem(Tier.EnergyCubeTier tier) {
        ItemStack stack = new ItemStack((Item)this);
        this.setEnergyCubeTier(stack, tier);
        return stack;
    }

    public String func_77653_i(ItemStack itemstack) {
        return LangUtils.localize("tile.EnergyCube" + this.getEnergyCubeTier(itemstack).getBaseTier().getName() + ".name");
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (place) {
            TileEntityEnergyCube tileEntity = (TileEntityEnergyCube)world.func_147438_o(x, y, z);
            tileEntity.tier = ((IEnergyCube)stack.func_77973_b()).getEnergyCubeTier(stack);
            tileEntity.electricityStored = this.getEnergy(stack);
            if (tileEntity instanceof ISecurityTile) {
                TileEntityEnergyCube security = tileEntity;
                security.getSecurity().setOwner(this.getOwner(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwner(stack) == null) {
                    security.getSecurity().setOwner(player.func_70005_c_());
                }
            }
            tileEntity.setInventory(this.getInventory(stack), new Object[0]);
            if (!world.field_72995_K) {
                Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(tileEntity), tileEntity.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(tileEntity)));
            }
        }
        return place;
    }

    @Override
    public Tier.EnergyCubeTier getEnergyCubeTier(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return Tier.EnergyCubeTier.BASIC;
        }
        if (itemstack.field_77990_d.func_74779_i("tier") == null) {
            return Tier.EnergyCubeTier.BASIC;
        }
        return Tier.EnergyCubeTier.getFromName(itemstack.field_77990_d.func_74779_i("tier"));
    }

    @Override
    public void setEnergyCubeTier(ItemStack itemstack, Tier.EnergyCubeTier tier) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        itemstack.field_77990_d.func_74778_a("tier", tier.getBaseTier().getName());
    }

    @Optional.Method(modid="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    @Optional.Method(modid="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_150295_c("Items", 10);
        }
        return null;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (this.getEnergyCubeTier(itemStack) == Tier.EnergyCubeTier.CREATIVE && amount != Double.MAX_VALUE) {
            return;
        }
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.getEnergyCubeTier((ItemStack)itemStack).maxEnergy;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return true;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return true;
    }

    @Override
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * MekanismConfig.general.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * MekanismConfig.general.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * MekanismConfig.general.TO_TE);
    }

    @Override
    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * MekanismConfig.general.TO_TE);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - this.getEnergy(stack) / this.getMaxEnergy(stack);
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Optional.Method(modid="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Override
    public String getOwner(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("owner")) {
            return stack.field_77990_d.func_74779_i("owner");
        }
        return null;
    }

    @Override
    public void setOwner(ItemStack stack, String owner) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (owner == null || owner.isEmpty()) {
            stack.field_77990_d.func_82580_o("owner");
            return;
        }
        stack.field_77990_d.func_74778_a("owner", owner);
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (stack.field_77990_d == null || !MekanismConfig.general.allowProtection) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[stack.field_77990_d.func_74762_e("security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("security", mode.ordinal());
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        return true;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }
}

