/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.MekanismItems;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.ChanceMachineRecipe;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.outputs.ChanceOutput;
import mekanism.common.tile.TileEntityBasicMachine;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public abstract class TileEntityChanceMachine<RECIPE extends ChanceMachineRecipe<RECIPE>>
extends TileEntityBasicMachine<ItemStackInput, ChanceOutput, RECIPE> {
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded"};

    public TileEntityChanceMachine(String soundPath, String name, ResourceLocation location, double perTick, int ticksRequired, double maxEnergy) {
        super(soundPath, name, location, perTick, ticksRequired, maxEnergy);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2, 4}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{2, 1, 0, 0, 0, 3});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = new ItemStack[5];
        this.upgradeComponent = new TileComponentUpgrade(this, 3);
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(3));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.discharge(1, this);
            MachineRecipe recipe = this.getRecipe();
            if (this.canOperate((RECIPE)recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= this.energyPerTick) {
                this.setActive(true);
                this.electricityStored -= this.energyPerTick;
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate((RECIPE)recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (!this.canOperate((RECIPE)recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 3) {
            return itemstack.func_77973_b() == MekanismItems.SpeedUpgrade || itemstack.func_77973_b() == MekanismItems.EnergyUpgrade;
        }
        if (slotID == 0) {
            return RecipeHandler.isInRecipe(itemstack, this.getRecipes());
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public ItemStackInput getInput() {
        return new ItemStackInput(this.inventory[0]);
    }

    @Override
    public void operate(RECIPE recipe) {
        ((ChanceMachineRecipe)recipe).operate(this.inventory);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public boolean canOperate(RECIPE recipe) {
        return recipe != null && ((ChanceMachineRecipe)recipe).canOperate(this.inventory, 0, 2, 4);
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2 || slotID == 4;
    }

    @Override
    public RECIPE getRecipe() {
        ItemStackInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ItemStackInput)((ChanceMachineRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getChanceRecipe(input, this.getRecipes());
        }
        return (RECIPE)((ChanceMachineRecipe)this.cachedRecipe);
    }

    @Override
    public Map<ItemStackInput, RECIPE> getRecipes() {
        return null;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.isActive};
            }
            case 3: {
                return new Object[]{this.facing};
            }
            case 4: {
                return new Object[]{this.canOperate((RECIPE)this.getRecipe())};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 6: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
        }
        throw new NoSuchMethodException();
    }
}

