/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.layer.hell;

import biomesoplenty.common.world.layer.hell.BiomeLayerHellBiomes;
import biomesoplenty.common.world.layer.hell.BiomeLayerHellCreate;
import biomesoplenty.common.world.layer.hell.BiomeLayerHellFuzzyZoom;
import biomesoplenty.common.world.layer.hell.BiomeLayerHellVoronoiZoom;
import biomesoplenty.common.world.layer.hell.BiomeLayerHellZoom;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public abstract class BiomeLayerHell
extends GenLayer {
    public static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType worldtype, int dim) {
        int biomesize = 3;
        if (dim == 1) {
            biomesize = 2;
        }
        BiomeLayerHell obj = new BiomeLayerHellCreate(1L, false);
        obj = new BiomeLayerHellFuzzyZoom(2000L, obj);
        for (int i = 1; i < 3; ++i) {
            obj = new BiomeLayerHellZoom(2000L + (long)i, obj);
        }
        obj = BiomeLayerHellZoom.magnify(1000L, obj, 0);
        obj = new BiomeLayerHellBiomes(200L, obj);
        obj = BiomeLayerHellZoom.magnify(1000L, obj, 2);
        for (int j = 0; j < biomesize; ++j) {
            obj = new BiomeLayerHellZoom(1000L + (long)j, obj);
        }
        BiomeLayerHellVoronoiZoom genlayervoronoizoom = new BiomeLayerHellVoronoiZoom(10L, obj);
        obj.func_75905_a(seed);
        genlayervoronoizoom.func_75905_a(seed);
        return new GenLayer[]{obj, genlayervoronoizoom};
    }

    public BiomeLayerHell(long seed) {
        super(seed);
    }

    public static byte getModdedBiomeSize(WorldType worldType, byte original) {
        WorldTypeEvent.BiomeSize event = new WorldTypeEvent.BiomeSize(worldType, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.newSize;
    }
}

