/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.ModBlocks;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.item.GarlicHelper;
import de.teamlapen.vampirism.tileEntity.TileEntityCoffin;
import de.teamlapen.vampirism.util.VampireLordData;
import de.teamlapen.vampirism.util.VersionChecker;
import de.teamlapen.vampirism.villages.VillageVampireData;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;

public class VampirismEventHandler {
    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent e) {
        if (e.world.field_72995_K) {
            return;
        }
        ItemStack i = null;
        if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && e.entityPlayer.func_70093_af() && e.world.func_147439_a(e.x, e.y, e.z).equals((Object)ModBlocks.coffin) && (i = e.entityPlayer.field_71071_by.func_70448_g()) != null && i.func_77973_b() instanceof ItemDye) {
            int color = i.func_77960_j();
            TileEntityCoffin t = (TileEntityCoffin)e.world.func_147438_o(e.x, e.y, e.z);
            if (t == null) {
                return;
            }
            if ((t = t.getPrimaryTileEntity()) == null) {
                return;
            }
            t.changeColor(color);
            e.useBlock = Event.Result.DENY;
            e.useItem = Event.Result.DENY;
            if (!e.entityPlayer.field_71075_bZ.field_75098_d) {
                --i.field_77994_a;
            }
        }
    }

    @SubscribeEvent
    public void onBonemeal(BonemealEvent event) {
        if (Configs.disable_vampire_biome && Blocks.field_150349_c.equals(event.block) && event.world.field_73012_v.nextInt(9) == 0) {
            EntityItem flower = new EntityItem(event.world, (double)event.x, (double)(event.y + 1), (double)event.z, new ItemStack((Block)ModBlocks.vampireFlower, 1));
            event.world.func_72838_d((Entity)flower);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        WorldServer w;
        VampirismMod.proxy.onTick(event);
        if (event instanceof TickEvent.ServerTickEvent && (w = DimensionManager.getWorld((int)0)) != null) {
            VampireLordData.get((World)w).tick((TickEvent.ServerTickEvent)event);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent e) {
        if (VampirePlayer.get((EntityPlayer)e.player).sleepingCoffin) {
            VampirePlayer.get(e.player).wakeUpPlayer(true, true, false, false);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent e) {
        if (VampirismMod.vampireCastleFail) {
            e.player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.castle_fail", new Object[0]));
        }
        if (Configs.updateNotification && VersionChecker.newVersion != null && e.player.func_70681_au().nextInt(5) == 0) {
            e.player.func_146105_b((IChatComponent)new ChatComponentTranslation("text.vampirism.outdated", new Object[]{"0.7.9", VersionChecker.newVersion.getModVersion()}));
            IChatComponent component = IChatComponent.Serializer.func_150699_a((String)VersionChecker.addVersionInfo(StatCollector.func_74838_a((String)"text.vampirism.update_message")));
            e.player.func_146105_b(component);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        VillageVampireData.get(event.world).onWorldTick(event);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (!event.world.field_72995_K && event.world.field_73011_w.field_76574_g == 0) {
            VampirismMod.vampireCastleFail = false;
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        int i = GarlicHelper.getGarlicValue(event.itemStack);
        if (i > 0) {
            event.toolTip.add(EnumChatFormatting.YELLOW + StatCollector.func_74838_a((String)"block.vampirism.garlic.name") + " " + i);
        }
    }
}

