/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.castleDim;

import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.generation.castle.CastlePositionData;
import de.teamlapen.vampirism.util.Logger;
import de.teamlapen.vampirism.util.VampireLordData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;

public class TeleporterCastle
extends Teleporter {
    private final WorldServer server;
    private final boolean toCastle;

    public TeleporterCastle(WorldServer worldServer) {
        super(worldServer);
        this.server = worldServer;
        this.toCastle = this.server.field_73011_w.field_76574_g == VampirismMod.castleDimensionId;
    }

    public void func_77185_a(Entity entity, double p_77185_2_, double p_77185_4_, double p_77185_6_, float p_77185_8_) {
        if (this.toCastle && entity instanceof EntityPlayer) {
            this.handleRegeneration();
            this.server.func_73040_p().func_72691_b((EntityPlayerMP)entity);
        }
        ChunkCoordinates chunkCoordinates = null;
        if (entity instanceof EntityPlayer) {
            NBTTagCompound extra = VampirePlayer.get((EntityPlayer)entity).getExtraDataTag();
            if (this.toCastle) {
                extra.func_74783_a("teleporter_castle_old", new int[]{MathHelper.func_76128_c((double)entity.field_70165_t), MathHelper.func_76128_c((double)entity.field_70163_u), MathHelper.func_76128_c((double)entity.field_70161_v)});
            } else {
                int[] old = extra.func_74759_k("teleporter_castle_old");
                extra.func_82580_o("teleporter_castle_old");
                if (old != null && old.length == 3) {
                    chunkCoordinates = new ChunkCoordinates(old[0], old[1], old[2]);
                }
            }
        }
        if (chunkCoordinates == null) {
            if (this.toCastle) {
                chunkCoordinates = this.server.func_73054_j();
            }
            if (!this.toCastle) {
                chunkCoordinates = this.server.func_72861_E();
            }
        }
        double x = (double)chunkCoordinates.field_71574_a - 0.5;
        entity.field_70163_u = (double)chunkCoordinates.field_71572_b + 0.1;
        double z = chunkCoordinates.field_71573_c;
        entity.func_70012_b(x, entity.field_70163_u, z, 180.0f, 0.0f);
        if (entity.func_70089_S()) {
            this.server.func_72866_a(entity, false);
        }
    }

    private void handleRegeneration() {
        if (!VampireLordData.get((World)this.server).shouldRegenerateCastleDim()) {
            return;
        }
        if (this.server.field_73059_b.field_73245_g.size() > 0) {
            Logger.w("Teleporter", "Cannot regenerate the castle dimension, since there are chunks loaded", new Object[0]);
            return;
        }
        CastlePositionData.reset((World)this.server);
        this.server.func_72828_b(this.server.field_72996_f);
        this.server.field_73059_b.func_73154_d(2, 6);
        this.server.field_73059_b.func_73154_d(3, 6);
        for (int x = 0; x < 6; ++x) {
            for (int z = 0; z < 6; ++z) {
                this.server.field_73059_b.func_73154_d(x, z);
                Chunk newC = this.server.field_73059_b.field_73246_d.func_73154_d(x, z);
                Chunk old = (Chunk)this.server.field_73059_b.field_73244_f.func_76159_d(ChunkCoordIntPair.func_77272_a((int)x, (int)z));
                if (old != null) {
                    old.func_76623_d();
                    this.server.field_73059_b.field_73245_g.remove(old);
                }
                this.server.field_73059_b.field_73245_g.add(newC);
                this.server.field_73059_b.field_73244_f.func_76163_a(ChunkCoordIntPair.func_77272_a((int)x, (int)z), (Object)newC);
                newC.func_76631_c();
            }
        }
        VampireLordData.get((World)this.server).setRegenerateCastleDim(false);
    }
}

