/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import de.teamlapen.vampirism.Configs;
import de.teamlapen.vampirism.entity.VampireMob;
import de.teamlapen.vampirism.entity.player.VampirePlayer;
import de.teamlapen.vampirism.entity.player.skills.Skills;
import de.teamlapen.vampirism.util.Logger;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class VampireHudOverlay
extends Gui {
    private static float renderRed;
    private final Minecraft mc;
    private final ResourceLocation icons = new ResourceLocation("vampirism:textures/gui/icons.png");

    public static void setRenderRed(float value) {
        if (value < 0.0f || value > 1.0f) {
            Logger.d("Overlay", "Can't render screen red with value: " + value, new Object[0]);
            return;
        }
        renderRed = value;
    }

    public VampireHudOverlay(Minecraft mc) {
        this.mc = mc;
    }

    protected void drawGradientRect2(int p_73733_1_, int p_73733_2_, int p_73733_3_, int p_73733_4_, int p_73733_5_, int p_73733_6_) {
        float f = (float)(p_73733_5_ >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(p_73733_5_ >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(p_73733_5_ >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(p_73733_5_ & 0xFF) / 255.0f;
        float f4 = (float)(p_73733_6_ >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(p_73733_6_ >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(p_73733_6_ >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(p_73733_6_ & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)p_73733_3_, (double)p_73733_2_, (double)this.field_73735_i);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)p_73733_1_, (double)p_73733_2_, (double)this.field_73735_i);
        tessellator.func_78377_a((double)p_73733_1_, (double)p_73733_4_, (double)this.field_73735_i);
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)p_73733_3_, (double)p_73733_4_, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    @SubscribeEvent
    public void onRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        if (event.type != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        MovingObjectPosition p = Minecraft.func_71410_x().field_71476_x;
        if (p != null && p.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY && p.field_72308_g != null && p.field_72308_g instanceof EntityCreature) {
            VampireMob mob = VampireMob.get((EntityCreature)p.field_72308_g);
            if (mob == null) {
                return;
            }
            if (mob.getBlood() > 0 && VampirePlayer.get((EntityPlayer)Minecraft.func_71410_x().field_71439_g).getLevel() > 0) {
                this.mc.field_71424_I.func_76320_a("vampireFang");
                GL11.glEnable((int)3042);
                this.mc.func_110434_K().func_110577_a(this.icons);
                int left = event.resolution.func_78326_a() / 2 - 8;
                int top = event.resolution.func_78328_b() / 2 - 4;
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)0.8f);
                this.func_73729_b(left, top, 27, 0, 16, 16);
                GL11.glDisable((int)3042);
                this.mc.field_71424_I.func_76319_b();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        int level = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getLevel();
        boolean lord = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).isVampireLord();
        if (this.mc.field_71442_b.func_78763_f() && level > 0) {
            this.mc.field_71424_I.func_76320_a("vampireLevel");
            int color = Color.MAGENTA.getRGB();
            String text = lord ? "Lord" : "" + level;
            int x = (event.resolution.func_78326_a() - this.mc.field_71466_p.func_78256_a(text)) / 2 + Configs.gui_level_offset_x;
            int y = event.resolution.func_78328_b() - Configs.gui_level_offset_y;
            this.mc.field_71466_p.func_78276_b(text, x + 1, y, 0);
            this.mc.field_71466_p.func_78276_b(text, x - 1, y, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y + 1, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y - 1, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y, color);
            this.mc.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public void onRenderFoodBar(RenderGameOverlayEvent.Pre event) {
        if (event.type != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        VampirePlayer p = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g);
        if (p.getLevel() > 0) {
            event.setCanceled(true);
            if (this.mc.field_71442_b.func_78763_f()) {
                VampirePlayer.BloodStats stats = p.getBloodStats();
                this.mc.field_71424_I.func_76320_a("vampireBlood");
                GL11.glEnable((int)3042);
                this.mc.func_110434_K().func_110577_a(this.icons);
                int left = event.resolution.func_78326_a() / 2 + 91;
                int top = event.resolution.func_78328_b() - GuiIngameForge.right_height;
                GuiIngameForge.right_height += 10;
                for (int i = 0; i < 10; ++i) {
                    int idx = i * 2 + 1;
                    int x = left - i * 8 - 9;
                    this.func_73729_b(x, top, 0, 0, 9, 9);
                    if (idx < stats.getBloodLevel()) {
                        this.func_73729_b(x, top, 9, 0, 9, 9);
                        continue;
                    }
                    if (idx != stats.getBloodLevel()) continue;
                    this.func_73729_b(x, top, 18, 0, 9, 9);
                }
                this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                GL11.glDisable((int)3042);
                this.mc.field_71424_I.func_76319_b();
            }
        }
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        int sunTicks;
        boolean lord = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).isSkillActive(Skills.vampireRage);
        int n = sunTicks = Configs.gui_yellow_border ? VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getSunDamageTicksInSun() : 0;
        if (renderRed > 0.0f || lord || sunTicks > 0) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
            GL11.glClear((int)256);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            GL11.glOrtho((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1.0, (double)-1.0);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glPushMatrix();
            GL11.glDisable((int)2929);
            GL11.glEnable((int)3042);
            int w = scaledresolution.func_78326_a();
            int h = scaledresolution.func_78328_b();
            if (renderRed > 0.0f) {
                GL11.glColor4f((float)1.0f, (float)0.0f, (float)0.0f, (float)renderRed);
                GL11.glBegin((int)7);
                GL11.glVertex3f((float)0.0f, (float)h, (float)0.0f);
                GL11.glVertex3f((float)w, (float)h, (float)0.0f);
                GL11.glVertex3f((float)w, (float)0.0f, (float)0.0f);
                GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
                GL11.glEnd();
            } else {
                int color;
                int bw = 0;
                int bh = 0;
                if (lord) {
                    color = -1048576;
                    bh = h / 4;
                    bw = w / 8;
                } else {
                    color = -6400;
                    bh = Math.round((float)h / 4.0f * (float)Math.min(sunTicks, 130) / 100.0f);
                    bw = Math.round((float)w / 8.0f * (float)Math.min(sunTicks, 130) / 100.0f);
                }
                this.func_73733_a(0, 0, w, bh, color, 0);
                this.func_73733_a(0, h - bh, w, h, 0, color);
                this.drawGradientRect2(0, 0, bw, h, 0, color);
                this.drawGradientRect2(w - bw, 0, w, h, color, 0);
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2929);
            GL11.glPopMatrix();
        }
    }
}

