/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.teamlapen.vampirism.client.model.ModelBloodAltar4;
import de.teamlapen.vampirism.tileEntity.TileEntityBloodAltar4;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RendererBloodAltar4
extends TileEntitySpecialRenderer {
    public static final String textureLoc = "vampirism:textures/blocks/bloodAltar4.png";
    private final ModelBloodAltar4 model;
    private final ResourceLocation texture;
    private final ResourceLocation enderDragonCrystalBeamTextures = new ResourceLocation("textures/entity/endercrystal/endercrystal_beam.png");
    private final ResourceLocation beaconBeamTexture = new ResourceLocation("textures/entity/beacon_beam.png");

    public RendererBloodAltar4() {
        this.model = new ModelBloodAltar4();
        this.texture = new ResourceLocation(textureLoc);
    }

    private void adjustRotatePivotViaMeta(World world, int x, int y, int z) {
        if (world != null) {
            int meta = world.func_72805_g(x, y, z);
            GL11.glRotatef((float)(meta * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    private void renderBeam(double relX, double relY, double relZ, double centerX, double centerY, double centerZ, double targetX, double targetY, double targetZ, float tickStuff, boolean beacon) {
        float f2 = 50000.0f;
        float f3 = MathHelper.func_76126_a((float)(f2 * 0.2f)) / 2.0f + 0.5f;
        f3 = (f3 * f3 + f3) * 0.2f;
        float wayX = (float)(targetX - centerX);
        float wayY = (float)(targetY - centerY);
        float wayZ = (float)(targetZ - centerZ);
        float distFlat = MathHelper.func_76129_c((float)(wayX * wayX + wayZ * wayZ));
        float dist = MathHelper.func_76129_c((float)(wayX * wayX + wayY * wayY + wayZ * wayZ));
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)relX), (float)((float)relY), (float)((float)relZ));
        GL11.glRotatef((float)((float)(-Math.atan2(wayZ, wayX)) * 180.0f / (float)Math.PI - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((float)(-Math.atan2(distFlat, wayY)) * 180.0f / (float)Math.PI - 90.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2884);
        if (beacon) {
            this.func_147499_a(this.beaconBeamTexture);
        } else {
            this.func_147499_a(this.enderDragonCrystalBeamTextures);
        }
        GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        GL11.glShadeModel((int)7425);
        float f9 = -(tickStuff * 0.005f);
        float f10 = MathHelper.func_76129_c((float)(wayX * wayX + wayY * wayY + wayZ * wayZ)) / 32.0f + f9;
        tessellator.func_78371_b(5);
        int b0 = 8;
        for (int i = 0; i <= b0; ++i) {
            float f11 = 0.2f * (MathHelper.func_76126_a((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f);
            float f12 = 0.2f * (MathHelper.func_76134_b((float)((float)(i % b0) * (float)Math.PI * 2.0f / (float)b0)) * 0.75f);
            float f13 = (float)(i % b0) * 1.0f / (float)b0;
            tessellator.func_78376_a(255, 0, 0);
            tessellator.func_78374_a((double)f11, (double)f12, 0.0, (double)f13, (double)f10);
            if (!beacon) {
                tessellator.func_78378_d(0xFFFFFF);
            }
            tessellator.func_78374_a((double)f11, (double)f12, (double)dist, (double)f13, (double)f9);
        }
        tessellator.func_78381_a();
        GL11.glEnable((int)2884);
        GL11.glShadeModel((int)7424);
        RenderHelper.func_74519_b();
        GL11.glPopMatrix();
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float par5) {
        TileEntityBloodAltar4 te4 = (TileEntityBloodAltar4)te;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(this.texture);
        GL11.glPushMatrix();
        this.adjustRotatePivotViaMeta(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        TileEntityBloodAltar4.PHASE phase = te4.getPhase();
        if (phase == TileEntityBloodAltar4.PHASE.BEAM1 || phase == TileEntityBloodAltar4.PHASE.BEAM2) {
            x += 0.5;
            y += 3.0;
            z += 0.5;
            double cX = (double)te.field_145851_c + 0.5;
            double cY = te.field_145848_d + 3;
            double cZ = (double)te.field_145849_e + 0.5;
            try {
                EntityPlayer p;
                ChunkCoordinates[] tips = te4.getTips();
                for (int i = 0; i < tips.length; ++i) {
                    this.renderBeam(x, y, z, cX, cY, cZ, (double)tips[i].field_71574_a + 0.5, (double)tips[i].field_71572_b + 0.5, (double)tips[i].field_71573_c + 0.5, (float)te4.getRunningTick() + par5, false);
                }
                if (phase == TileEntityBloodAltar4.PHASE.BEAM2 && (p = te4.getPlayer()) != null) {
                    double rX = 0.0;
                    double rZ = 0.0;
                    double rY = -0.3;
                    double playerY = p.field_70163_u;
                    if (!p.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
                        EntityClientPlayerMP e = Minecraft.func_71410_x().field_71439_g;
                        rX += p.field_70165_t - e.field_70165_t;
                        rY += p.field_70163_u - e.field_70163_u + 1.5;
                        rZ += p.field_70161_v - e.field_70161_v;
                        playerY += 1.5;
                    }
                    this.renderBeam(rX, rY, rZ, p.field_70165_t, playerY, p.field_70161_v, cX, cY + 0.2, cZ, -((float)te4.getRunningTick() + par5), true);
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }
}

