/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.render;

import de.teamlapen.vampirism.client.model.ModelCoffin;
import de.teamlapen.vampirism.tileEntity.TileEntityCoffin;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RendererCoffin
extends TileEntitySpecialRenderer {
    public static final String[] colors = new String[]{"black", "red", "green", "brown", "blue", "purple", "cyan", "silver", "gray", "pink", "lime", "yellow", "lightBlue", "magenta", "orange", "white"};
    private ModelCoffin model;
    private ResourceLocation[] textures = new ResourceLocation[16];
    private final int maxLidPos = 61;

    public RendererCoffin() {
        this.model = new ModelCoffin();
        for (int i = 0; i < colors.length; ++i) {
            this.textures[i] = new ResourceLocation("vampirism:textures/blocks/coffin/coffin_" + colors[i] + ".png");
        }
    }

    private void adjustRotatePivotViaMeta(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        GL11.glRotatef((float)(meta * -90), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    private float calcLidAngle(int pos) {
        if (pos == 61) {
            return 0.0f;
        }
        if (pos == 0) {
            return 2.3561945f;
        }
        return (float)(-Math.pow(1.02, pos) + 1.0 + 2.356194490192345);
    }

    public void func_147500_a(TileEntity te, double x, double y, double z, float scale) {
        boolean occupied;
        TileEntityCoffin tile = (TileEntityCoffin)te;
        if ((te.func_145832_p() & 0xFFFFFFF8) == 0) {
            return;
        }
        boolean bl = occupied = (te.func_145832_p() & 4) != 0;
        if (!occupied && tile.lidPos > 0) {
            --tile.lidPos;
        } else if (occupied && tile.lidPos < 61) {
            ++tile.lidPos;
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        int color = Math.min(tile.color, 15);
        this.func_147499_a(this.textures[color]);
        GL11.glPushMatrix();
        this.adjustRotatePivotViaMeta(te.func_145831_w(), te.field_145851_c, te.field_145848_d, te.field_145849_e);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.rotateLid(this.calcLidAngle(tile.lidPos));
        this.model.func_78088_a(null, 0.0f, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }
}

